/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.compiler.DependEntityMap;
import kd.bos.service.botp.convert.mapping.IMappingField;

public abstract class AbstractMappingdFieldValue {
    private static final Log log = LogFactory.getLog(AbstractMappingdFieldValue.class);
    protected ExtendedDataEntity[] targetExtDataEntitys;
    protected IMappingField mappingField;
    protected Map<String, DynamicProperty> srcFldPropertys;
    protected BatchRequestManager batchRequestManager;
    protected ConvertContext context;
    protected boolean isBatchPreCall;
    protected DependEntityMap entityMap;

    protected abstract boolean checkBeforeCalc();

    protected abstract void doException(Exception var1);

    protected abstract Object getSourceRows(ExtendedDataEntity var1);

    protected void setArgs(ExtendedDataEntity[] targetExtDataEntitys, IMappingField mappingField, Map<String, DynamicProperty> srcFldPropertys, BatchRequestManager batchRequestManager, ConvertContext context, DependEntityMap entityMap) {
        this.targetExtDataEntitys = targetExtDataEntitys;
        this.mappingField = mappingField;
        this.srcFldPropertys = srcFldPropertys;
        this.batchRequestManager = batchRequestManager;
        this.context = context;
        this.entityMap = entityMap;
    }

    protected AbstractMappingdFieldValue setBatchPreCall(boolean batchPreCall) {
        this.isBatchPreCall = batchPreCall;
        return this;
    }

    protected void prepBillAndCalc() {
        for (ExtendedDataEntity extDataEntity : this.targetExtDataEntitys) {
            Object sourceRows;
            boolean checkResult = this.checkBeforeCalc();
            if (!checkResult || (sourceRows = this.getSourceRows(extDataEntity)) == null) continue;
            try {
                if (this.isBatchPreCall) {
                    boolean isPre = this.batchPreCall(this.srcFldPropertys, sourceRows, extDataEntity);
                    if (isPre) continue;
                    break;
                }
                this.calcAndMaping(this.srcFldPropertys, sourceRows, extDataEntity);
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                this.doException(e);
            }
        }
    }

    private boolean batchPreCall(Map<String, DynamicProperty> srcFldPropertys, Object sourceRows, ExtendedDataEntity extDataEntity) {
        try {
            FieldMapItem fieldMapItem = this.mappingField.getFieldMap();
            if (fieldMapItem.getFieldConvertType() != FieldConvertType.ByCondition && fieldMapItem.getFieldConvertType() != FieldConvertType.Formula) {
                return false;
            }
            return this.mappingField.batchPreCall(srcFldPropertys, (List)sourceRows, extDataEntity.getDataEntity(), this.batchRequestManager);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
    }

    private void calcAndMaping(Map<String, DynamicProperty> srcFldPropertys, Object sourceRows, ExtendedDataEntity extDataEntity) {
        this.mappingField.calcAndMappingValue(srcFldPropertys, (List)sourceRows, extDataEntity.getDataEntity(), this.batchRequestManager);
    }
}

