/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.helper.AttachmentPanelConvertHelper;
import kd.bos.entity.botp.runtime.AttachmentPanelMap;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;

public class AttachmentPanelPushAction
extends AbstractConvertAction {
    public AttachmentPanelPushAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        BillEntityType targetEntityType = this.ruleContext.getContext().getTargetMainType();
        BillEntityType sourceEntityType = this.ruleContext.getContext().getSourceMainType();
        Map<String, AttachmentPanelMap> attachmentPanelMapRules = this.ruleContext.getRuleCompiler().getAttachmentPanelMaps();
        if (attachmentPanelMapRules == null || attachmentPanelMapRules.isEmpty()) {
            return;
        }
        if ((attachmentPanelMapRules = attachmentPanelMapRules.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((AttachmentPanelMap)entry.getValue()).getSourceAttachmentPanelKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            return;
        }
        ExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        ExtendedDataEntity[] targetExtDataEntitys = targetExtDataSet.FindByEntityKey(targetEntityType.getName());
        this.loadAttachmentInfos(targetExtDataEntitys, (MainEntityType)sourceEntityType, attachmentPanelMapRules);
    }

    protected void loadAttachmentInfos(ExtendedDataEntity[] targetExtDataEntitys, MainEntityType sourceEntityType, Map<String, AttachmentPanelMap> attachmentPanelMapRules) {
        Map<Object, List<Object>> savingTargetBillSourceIds = this.resultManager.getSavingTargetBillSourceIds();
        for (int i = 0; i < targetExtDataEntitys.length; ++i) {
            List sourceRows;
            ExtendedDataEntity extDataEntity = targetExtDataEntitys[i];
            if (this.ruleResultManager.isFail(extDataEntity.getBillPkId()) || (sourceRows = (List)extDataEntity.getValue("ConvertSource")) == null || sourceRows.isEmpty()) continue;
            List<Object> pushedTargetBillSourceIds = savingTargetBillSourceIds.get(extDataEntity.getBillPkId());
            ArrayList<Object> sourcePks = (ArrayList<Object>)extDataEntity.getValue("botp_attachment_mapping_source_row_ids");
            if (sourcePks == null) {
                sourcePks = new ArrayList<Object>(sourceRows.size());
            }
            for (DynamicObject sourceBill : sourceRows) {
                Object sourceId = sourceBill.get("id");
                if (sourcePks.contains(sourceId)) continue;
                sourcePks.add(sourceId);
            }
            extDataEntity.setValue("botp_attachment_mapping_source_row_ids", sourcePks);
            Map attachInfoMap = AttachmentPanelConvertHelper.loadAttachInfoMap((MainEntityType)sourceEntityType, attachmentPanelMapRules, sourcePks, pushedTargetBillSourceIds);
            extDataEntity.setValue("botp_source_attachmentpanel_infos", (Object)attachInfoMap);
        }
    }
}

