/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.mc.BotpMCParam;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleBatchResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.SingleBatchExecute;
import kd.bos.service.botp.convert.compiler.AbstractEntityMap;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.group.SourceRowIdAndGroupKey;
import kd.bos.service.botp.convert.group.SourceRowIdAndGroupKeyComparator;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.group.SourceRowsGroupKeyBuilder;
import kd.bos.service.botp.convert.report.IBuildDetailReport;
import kd.bos.service.botp.convert.sort.ISortKeyBuilder;
import kd.bos.service.botp.convert.sort.ListSelectedRowComparator;
import kd.bos.service.botp.convert.sort.SourceRowSortKey;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.botp.JobFormProgressUtil;

public class BigDataPushAction
extends AbstractConvertAction {
    private static final Log LOG = LogFactory.getLog(BigDataPushAction.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private LinkEntityMap linkEntityMap = null;
    private EntityType srcLinkEntity = null;
    private ConvertReportManager reportManager = null;
    private IBuildDetailReport reportBuilder = null;
    private CRConditionCompiler rowCondCompiler = null;
    private Boolean outFormula = null;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BigDataPushAction", (int)32);
    private int rowCountOneBatch = BotpMCParam.getIntValue((String)"botp_convert_rowcountonebatch");
    private int finishBatchCount = 0;
    private int batchCount = 1;
    private BigDecimal percentage;
    private int billPushCount = 20000;

    public BigDataPushAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        ConvertOpProgressCache.setProgress((String)this.context.getInputArgs().getTaskId(), (int)2, (String)ResManager.loadKDString((String)"\u8bfb\u53d6\u7b26\u5408\u6570\u636e\u7b5b\u9009\u6761\u4ef6\u7684\u6e90\u5355\u884c", (String)"BigDataPushAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        JobFormProgressUtil.setProgress((String)this.context.getInputArgs().getJobTaskId(), (int)2);
        SourceRowsGroup billGroupRoot = this.readSourceRowIds();
        if (billGroupRoot.getChildGroupList().isEmpty()) {
            this.setSkipNextAction(true);
            return;
        }
        this.genTargetBillPKIds(billGroupRoot);
        ConvertOpProgressCache.setProgress((String)this.context.getInputArgs().getTaskId(), (int)4, (String)ResManager.loadKDString((String)"\u5bf9\u6e90\u5355\u884c\u8fdb\u884c\u5206\u6279", (String)"BigDataPushAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        JobFormProgressUtil.setProgress((String)this.context.getInputArgs().getJobTaskId(), (int)4);
        List<SourceRowsGroup> batchGroupRoots1 = this.split1(billGroupRoot);
        List<SourceRowsGroup> batchGroupRoots2 = this.split2(billGroupRoot);
        this.batchCount = batchGroupRoots1.size() + batchGroupRoots2.size();
        this.percentage = new BigDecimal("90").divide(new BigDecimal(this.batchCount), 4, RoundingMode.HALF_UP);
        ConvertOpProgressCache.setProgress((String)this.context.getInputArgs().getTaskId(), (int)5, (String)ResManager.loadKDString((String)"\u5206\u6279\u6267\u884c\u4e0b\u63a8", (String)"BigDataPushAction_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        JobFormProgressUtil.setProgress((String)this.context.getInputArgs().getJobTaskId(), (int)5);
        this.doBatchExecuteSync(batchGroupRoots1);
        this.doBatchExecuteSync(batchGroupRoots2);
        HashSet<Object> successIds = new HashSet<Object>(this.ruleResultManager.getTargetBillIds());
        successIds.removeAll(this.ruleResultManager.getFailBillIds());
        this.resultManager.getTargetBillIds().addAll(successIds);
        this.doDelete(this.ruleResultManager.getFailBillIds());
    }

    private void initVar() {
        this.reportManager = this.resultManager.getReporter();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        this.rowCondCompiler = this.ruleContext.getRuleCompiler().getDataFilterCompiler();
        this.srcLinkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(this.linkEntityMap.getSourceLinkEntityKey());
        this.reportBuilder = this.ruleContext.getSrcRowReportBuilder(this.srcLinkEntity);
        if (this.ruleContext.getRule().isBillPush()) {
            this.rowCountOneBatch = this.billPushCount;
        }
    }

    private SourceRowsGroup readSourceRowIds() {
        BeforeGetSourceDataEventArgs beforeEventArgs = new BeforeGetSourceDataEventArgs(this.linkEntityMap.getSrcSelectString(), this.linkEntityMap.getQFilters());
        this.ruleContext.getPlugInProxy().fireBeforeGetSourceData(beforeEventArgs);
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        String selectSQLString = this.linkEntityMap.getSrcRowIdSelectString();
        QFilter[] qFilters = beforeEventArgs.getQFilters().toArray(new QFilter[this.linkEntityMap.getQFilters().size()]);
        Map<String, String> fldAlias = this.linkEntityMap.getSrcFldAlias();
        int groupKeyCount = this.linkEntityMap.getSourceRowsGroupKeyBuilders().size();
        List<SourceRowIdAndGroupKey> srcRowIdAndGroupKeys = new ArrayList<SourceRowIdAndGroupKey>();
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);
        Object object = null;
        try {
            if (!ds.hasNext()) {
                this.buildNoDataErrorReport();
            }
            while (ds.hasNext()) {
                Row row = ds.next();
                SourceRowId sourceRowId = SourceRowId.create((AbstractEntityMap)this.linkEntityMap, row);
                this.reportBuilder.addLinkRow(this.reportManager, fldAlias, row);
                if (!this.ruleContext.getRule().getFilterPolicy().getAdvCondition().booleanValue()) {
                    if (!this.rowCondCompiler.executeCondition(fldAlias, row)) {
                        this.buildValidateErrorReport(fldAlias, row, sourceRowId);
                        continue;
                    }
                    ArrayList<SourceRowsGroupKey> groupKeys = new ArrayList<SourceRowsGroupKey>(3);
                    for (int i = 0; i < groupKeyCount; ++i) {
                        SourceRowsGroupKeyBuilder groupKeyBuilder = this.linkEntityMap.getSourceRowsGroupKeyBuilders().get(i);
                        groupKeys.add(groupKeyBuilder.getFldValues(fldAlias, row));
                    }
                    SourceRowIdAndGroupKey srcRowIdAndGroupKey = new SourceRowIdAndGroupKey(sourceRowId, groupKeys);
                    srcRowIdAndGroupKeys.add(srcRowIdAndGroupKey);
                    continue;
                }
                boolean flag = true;
                for (CRConditionCompiler crConditionCompiler : this.ruleContext.getRuleCompiler().getDataFilterCompilers()) {
                    if (crConditionCompiler.executeCondition(fldAlias, row)) continue;
                    String failMessage = crConditionCompiler.buildFailMessage(fldAlias, row, this.isOutFormula());
                    this.reportBuilder.addErrorReport(this.reportManager, sourceRowId, failMessage);
                    flag = false;
                    break;
                }
                if (!flag) continue;
                ArrayList<SourceRowsGroupKey> groupKeys = new ArrayList<SourceRowsGroupKey>(3);
                for (int i = 0; i < groupKeyCount; ++i) {
                    SourceRowsGroupKeyBuilder groupKeyBuilder = this.linkEntityMap.getSourceRowsGroupKeyBuilders().get(i);
                    groupKeys.add(groupKeyBuilder.getFldValues(fldAlias, row));
                }
                SourceRowIdAndGroupKey srcRowIdAndGroupKey = new SourceRowIdAndGroupKey(sourceRowId, groupKeys);
                srcRowIdAndGroupKeys.add(srcRowIdAndGroupKey);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        srcRowIdAndGroupKeys = this.sort(srcRowIdAndGroupKeys);
        SourceRowsGroup billGroupRoot = new SourceRowsGroup(null);
        for (SourceRowIdAndGroupKey srcRowIdAndGroupKey : srcRowIdAndGroupKeys) {
            billGroupRoot.addSourceRow(srcRowIdAndGroupKey.getSourceRowId(), srcRowIdAndGroupKey.getGroupKeys());
        }
        return billGroupRoot;
    }

    private List<SourceRowIdAndGroupKey> sort(List<SourceRowIdAndGroupKey> srcRowIdAndGroupKeys) {
        List list;
        if (srcRowIdAndGroupKeys.size() <= 1) {
            return srcRowIdAndGroupKeys;
        }
        if (srcRowIdAndGroupKeys.size() > 10000) {
            return srcRowIdAndGroupKeys;
        }
        ISortKeyBuilder sortKeyBuilder = ISortKeyBuilder.create(this.ruleContext, this.linkEntityMap, this.ruleContext.getSelectedRows().get(0));
        SourceRowIdAndGroupKeyComparator sortByRowIndex = new SourceRowIdAndGroupKeyComparator();
        List<ListSelectedRow> sortListSelectedRows = this.sortListSelectedRows();
        ArrayList<SourceRowSortKey> sortKeys = new ArrayList<SourceRowSortKey>(sortListSelectedRows.size());
        for (ListSelectedRow listSelectedRow : sortListSelectedRows) {
            SourceRowSortKey sortKey = sortKeyBuilder.buildSortKey(listSelectedRow);
            sortKeys.add(sortKey);
        }
        HashMap<SourceRowSortKey, List> mapSourceRows = new HashMap<SourceRowSortKey, List>(sortKeys.size());
        for (SourceRowIdAndGroupKey sAndSortKey : srcRowIdAndGroupKeys) {
            SourceRowSortKey sourceRowSortKey = sortKeyBuilder.buildSortKey(sAndSortKey.getSourceRowId());
            list = mapSourceRows.computeIfAbsent(sourceRowSortKey, s -> new ArrayList());
            list.add(sAndSortKey);
        }
        ArrayList<SourceRowIdAndGroupKey> arrayList = new ArrayList<SourceRowIdAndGroupKey>();
        for (SourceRowSortKey sourceRowSortKey : sortKeys) {
            list = (List)mapSourceRows.get(sourceRowSortKey);
            if (list == null) continue;
            list.sort(sortByRowIndex);
            arrayList.addAll(list);
            mapSourceRows.remove(sourceRowSortKey);
        }
        for (Map.Entry entry : mapSourceRows.entrySet()) {
            arrayList.addAll((Collection)entry.getValue());
        }
        return arrayList;
    }

    private List<ListSelectedRow> sortListSelectedRows() {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows().size());
        sortRows.addAll(this.ruleContext.getSelectedRows());
        ListSelectedRowComparator comparator = new ListSelectedRowComparator();
        sortRows.sort(comparator);
        return sortRows;
    }

    private List<SourceRowsGroup> split1(SourceRowsGroup groupRootAll) {
        ArrayList<SourceRowsGroup> batchGroupRoots = new ArrayList<SourceRowsGroup>();
        SourceRowsGroup currGroupRoot = new SourceRowsGroup(null);
        for (SourceRowsGroup billGroup : groupRootAll.getChildGroupList()) {
            billGroup.setStartEntrySeq(1);
            int currEntryRowCount = currGroupRoot.getEntryRowCount();
            if (currEntryRowCount != 0 && currEntryRowCount + billGroup.getEntryRowCount() > this.rowCountOneBatch) {
                batchGroupRoots.add(currGroupRoot);
                currGroupRoot = new SourceRowsGroup(null);
            }
            SourceRowsGroup billFirstGroup = null;
            billFirstGroup = billGroup.getChildGroupList().isEmpty() ? billGroup : billGroup.splitSubList(this.rowCountOneBatch);
            if (billFirstGroup == null) continue;
            currGroupRoot.getChildGroupList().add(billFirstGroup);
            currGroupRoot.getChildGroupMap().put(billFirstGroup.getGroupKey(), billFirstGroup);
            currGroupRoot.getSourceRowIds().addAll(billFirstGroup.getSourceRowIds());
        }
        if (!currGroupRoot.getChildGroupList().isEmpty()) {
            batchGroupRoots.add(currGroupRoot);
        }
        return batchGroupRoots;
    }

    private List<SourceRowsGroup> split2(SourceRowsGroup groupRootAll) {
        ArrayList<SourceRowsGroup> batchGroupRoots = new ArrayList<SourceRowsGroup>();
        SourceRowsGroup currGroupRoot = new SourceRowsGroup(null);
        for (SourceRowsGroup billGroup : groupRootAll.getChildGroupList()) {
            while (billGroup.getStartEntrySeq() <= billGroup.getChildGroupList().size()) {
                SourceRowsGroup newBillGroup;
                int currEntryRowCount = currGroupRoot.getEntryRowCount();
                if (currEntryRowCount != 0 && currEntryRowCount + (billGroup.getEntryRowCount() - billGroup.getStartEntrySeq() + 1) > this.rowCountOneBatch) {
                    batchGroupRoots.add(currGroupRoot);
                    currGroupRoot = new SourceRowsGroup(null);
                }
                if ((newBillGroup = billGroup.splitSubList(this.rowCountOneBatch)) == null) continue;
                currGroupRoot.getChildGroupList().add(newBillGroup);
                currGroupRoot.getChildGroupMap().put(newBillGroup.getGroupKey(), newBillGroup);
                currGroupRoot.getSourceRowIds().addAll(newBillGroup.getSourceRowIds());
            }
        }
        if (!currGroupRoot.getChildGroupList().isEmpty()) {
            batchGroupRoots.add(currGroupRoot);
        }
        return batchGroupRoots;
    }

    private void genTargetBillPKIds(SourceRowsGroup billGroupRoot) {
        ISimpleProperty pkProperty = this.context.getTargetMainType().getPrimaryKey();
        if (billGroupRoot.getChildGroupList().isEmpty()) {
            return;
        }
        Object[] ids = null;
        if (pkProperty instanceof VarcharProp) {
            ids = DBServiceHelper.genStringIds((int)billGroupRoot.getChildGroupList().size());
        } else {
            long[] longids = DBServiceHelper.genLongIds((String)"", (int)billGroupRoot.getChildGroupList().size());
            ids = new Object[longids.length];
            for (int i = 0; i < longids.length; ++i) {
                ids[i] = longids[i];
            }
        }
        this.ruleResultManager.addTargetBillIds(ids);
        int i = 0;
        for (SourceRowsGroup billGroup : billGroupRoot.getChildGroupList()) {
            billGroup.setTargetBillId(ids[i]);
            this.checkExceedingQuantity(billGroup);
            ++i;
        }
    }

    private void checkExceedingQuantity(SourceRowsGroup billGroup) {
        if (this.ruleContext.getRule().isBillPush() && billGroup.getChildGroupList().size() > this.billPushCount) {
            String msg = ResManager.loadKDString((String)"\u751f\u6210\u7684\u76ee\u6807\u5355\u5206\u5f55\u884c\u6570\u8d85\u8fc720000\u884c\uff0c\u8bf7\u5173\u95ed\u201c\u6574\u5355\u4e0b\u63a8\u201d\u53c2\u6570\u540e\u518d\u6267\u884c\u4e0b\u63a8\u3002", (String)"BigDataPushAction_8", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private void doBatchExecuteSync(List<SourceRowsGroup> batchGroupRoots) {
        LinkedList<SingleBatchExecute> batchExecutes = new LinkedList<SingleBatchExecute>();
        for (SourceRowsGroup billGroup : batchGroupRoots) {
            SingleBatchExecute batchExecute = new SingleBatchExecute(RequestContext.get(), this.context, this.ruleContext, this.resultManager, this.ruleResultManager, billGroup);
            batchExecute.setSyncExecute(true);
            batchExecutes.offer(batchExecute);
        }
        while (!batchExecutes.isEmpty()) {
            SingleBatchExecute batchExecute = (SingleBatchExecute)batchExecutes.poll();
            this.context.setCurrentAutoSaveNum(this.context.getCurrentAutoSaveNum() + (long)batchExecute.getCurrGroupRoot().getSourceRowIds().size());
            SingleBatchResultManager batchResult = null;
            try {
                batchResult = batchExecute.call();
            }
            catch (InterruptedException ex) {
                batchResult = new SingleBatchResultManager();
                batchResult.setException(ex);
                LOG.error((Throwable)ex);
            }
            catch (KDBizException ex) {
                batchResult = new SingleBatchResultManager();
                batchResult.setException(ex);
                LOG.warn((Throwable)ex);
            }
            catch (Throwable ex) {
                batchResult = new SingleBatchResultManager();
                batchResult.setException(ex);
                LOG.error(ex);
            }
            this.outBatchExecuteResult(batchResult);
            ++this.finishBatchCount;
            String processTip = String.format(ResManager.loadKDString((String)"\u5206\u6279\u751f\u6210\u76ee\u6807\u5355\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BigDataPushAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.finishBatchCount, this.batchCount);
            int process = 5 + this.percentage.multiply(new BigDecimal(this.finishBatchCount - 1)).intValue();
            ConvertOpProgressCache.setProgress((String)this.context.getInputArgs().getTaskId(), (int)process, (String)processTip);
            int selectRowNum = 0;
            if (this.context.getInputArgs() instanceof PushArgs) {
                selectRowNum = ((PushArgs)this.context.getInputArgs()).getSelectedRows().size();
            }
            JobFormProgressUtil.setProgress((String)this.context.getInputArgs().getJobTaskId(), (int)process, (long)this.context.getCurrentAutoSaveNum(), (long)selectRowNum);
        }
        batchGroupRoots.clear();
    }

    private void doBatchExecuteAnsy(List<SourceRowsGroup> batchGroupRoots) {
        ArrayList<Future> results = new ArrayList<Future>(batchGroupRoots.size());
        for (SourceRowsGroup billGroup : batchGroupRoots) {
            SingleBatchExecute batchExecute = new SingleBatchExecute(RequestContext.get(), this.context, this.ruleContext, this.resultManager, this.ruleResultManager, billGroup);
            Future ret = threadPool.submit((Callable)batchExecute);
            results.add(ret);
        }
        for (Future result : results) {
            SingleBatchResultManager batchResult = null;
            try {
                batchResult = (SingleBatchResultManager)result.get();
            }
            catch (InterruptedException ex) {
                batchResult = new SingleBatchResultManager();
                batchResult.setException(ex);
                LOG.error((Throwable)ex);
            }
            catch (KDBizException ex) {
                batchResult = new SingleBatchResultManager();
                batchResult.setException(ex);
                LOG.warn((Throwable)ex);
            }
            catch (Throwable ex) {
                batchResult = new SingleBatchResultManager();
                batchResult.setException(ex);
                LOG.error(ex);
            }
            this.outBatchExecuteResult(batchResult);
            ++this.finishBatchCount;
            String processTip = String.format(ResManager.loadKDString((String)"\u5206\u6279\u751f\u6210\u76ee\u6807\u5355\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BigDataPushAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.finishBatchCount, this.batchCount);
            int process = 5 + this.percentage.multiply(new BigDecimal(this.finishBatchCount - 1)).intValue();
            ConvertOpProgressCache.setProgress((String)this.context.getInputArgs().getTaskId(), (int)process, (String)processTip);
        }
        batchGroupRoots.clear();
        batchGroupRoots = null;
    }

    private void outBatchExecuteResult(SingleBatchResultManager batchResult) {
        HashSet<Object> failIds = new HashSet<Object>(0);
        for (SourceRowsGroup billGroup : batchResult.getSourceRowsGroupRoot().getChildGroupList()) {
            if (batchResult.getSuccessIds().contains(billGroup.getTargetBillId())) continue;
            failIds.add(billGroup.getTargetBillId());
            String failMessage = batchResult.getFailIds().get(billGroup.getTargetBillId());
            if (failMessage == null) {
                failMessage = batchResult.getException() != null ? batchResult.getException().getMessage() : ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u8f6c\u6362\u5931\u8d25", (String)"BigDataPushAction_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            }
            for (SourceRowId sourceRowId : billGroup.getSourceRowIds()) {
                this.reportBuilder.addErrorReport(this.reportManager, sourceRowId, failMessage);
            }
        }
        this.ruleResultManager.addFailBillIds(failIds.toArray());
        batchResult.getSourceRowsGroupRoot().clearMemory();
        batchResult.setSourceRowsGroupRoot(null);
    }

    private void doDelete(Set<Object> failIds) {
        if (failIds.isEmpty()) {
            return;
        }
        OperateOption delOption = OperateOption.create();
        delOption.setVariableValue("ignorewarn", String.valueOf(true));
        delOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        Operations operations = EntityMetadataCache.getDataEntityOperations((String)this.context.getTargetMainType().getName());
        OperationServiceHelper.executeOperate((String)(StringUtils.isBlank((CharSequence)operations.getDelete()) ? "delete" : operations.getDelete()), (String)this.context.getTargetMainType().getName(), (Object[])failIds.toArray(new Object[0]), (OperateOption)delOption);
    }

    private boolean isOutFormula() {
        if (this.outFormula == null) {
            String paramValue = (String)this.getContext().getInputArgs().getCustomParams().get("botp_outformula");
            this.outFormula = paramValue == null ? Boolean.FALSE : Boolean.valueOf(paramValue);
        }
        return this.outFormula;
    }

    private void buildNoDataErrorReport() {
        String failMessage = null;
        failMessage = this.srcLinkEntity instanceof EntryType && ((EntryType)this.srcLinkEntity).isMustIuput() ? String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e\uff0c\u53ef\u80fd\u662f%s\u6ca1\u6709\u8bb0\u5f55", (String)"BigDataPushAction_5", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.srcLinkEntity.getDisplayName().toString()) : (this.isOutFormula() ? String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e: %s", (String)"BigDataPushAction_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.linkEntityMap.getQFilters()) : ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e", (String)"BigDataPushAction_7", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), failMessage);
    }

    private void buildValidateErrorReport(Map<String, String> fldAlias, Row row, SourceRowId sourceRowId) {
        String failMessage = this.rowCondCompiler.buildFailMessage(fldAlias, row, this.isOutFormula());
        this.reportBuilder.addErrorReport(this.reportManager, sourceRowId, failMessage);
    }
}

