/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.actions.BuildDrawFilter;
import kd.bos.service.botp.convert.actions.BuildDrawFilterContext;
import kd.bos.service.botp.convert.actions.IFieldFilterBuilder;

class BuildDrawBillTypeFilter
extends BuildDrawFilter {
    private BillTypeProp sourceBillTypeProp;
    private BillTypeProp targetBillTypeProp;

    public BuildDrawBillTypeFilter(BuildDrawFilterContext buildDrawFilterContext) {
        super(buildDrawFilterContext);
        if (StringUtils.isNotBlank((CharSequence)this.getBuildDrawFilterContext().getTargetMainType().getBillType())) {
            this.targetBillTypeProp = (BillTypeProp)this.getBuildDrawFilterContext().getTargetMainType().findProperty(this.getBuildDrawFilterContext().getTargetMainType().getBillType());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBuildDrawFilterContext().getSourceMainType().getBillType())) {
            this.sourceBillTypeProp = (BillTypeProp)this.getBuildDrawFilterContext().getSourceMainType().findProperty(this.getBuildDrawFilterContext().getSourceMainType().getBillType());
        }
    }

    @Override
    public QFilter buildFilter() {
        if (this.targetBillTypeProp == null || this.sourceBillTypeProp == null) {
            return null;
        }
        DynamicObject targetBillTypeObj = (DynamicObject)IFieldFilterBuilder.getTargetFieldValue(this.getBuildDrawFilterContext().getTargetExtDataSet(), (IDataEntityProperty)this.targetBillTypeProp);
        QFilter billTypeFilter = null;
        BillTypeMapParser parser = new BillTypeMapParser();
        parser.tryGetSourceBillTypeIds(this.getBuildDrawFilterContext().getRuleContext().getRule().getBillTypeMapPolicy(), targetBillTypeObj);
        if (parser.isCannotDrawAnyOne()) {
            billTypeFilter = QFilter.of((String)(this.sourceBillTypeProp.getName() + " != " + this.sourceBillTypeProp.getName()), (Object[])new Object[0]);
        } else if (parser.isCanDrawAll()) {
            if (!parser.getOutCannotDrawBillTypeIds().isEmpty()) {
                billTypeFilter = new QFilter(this.sourceBillTypeProp.getName(), "not in", (Object)parser.getOutCannotDrawBillTypeIds().toArray(new Long[0]));
            }
        } else if (!parser.getOutBillTypeIds().isEmpty()) {
            billTypeFilter = new QFilter(this.sourceBillTypeProp.getName(), "in", (Object)parser.getOutBillTypeIds().toArray(new Long[0]));
        }
        return billTypeFilter;
    }
}

