/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.HashSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

class BuildDrawFilterContext {
    private ConvertContext context;
    private ConvertResultManager resultManager;
    private SingleRuleContext ruleContext;
    private SingleRuleResultManager ruleResultManager;
    private BillEntityType sourceMainType;
    private EntryType sourceEntry;
    private SubEntryType sourceSubEntry;
    private BillEntityType targetMainType;
    private LinkSetItemElement linkSetItem;
    private HashSet<String> targetEntityKeys = new HashSet();
    private DynamicObject targetDataEntity;
    private ExtendedDataEntitySet targetExtDataSet;

    public BuildDrawFilterContext(SingleRuleContext ruleContext, SingleRuleResultManager ruleResultManager) {
        this.context = ruleContext.getContext();
        this.resultManager = ruleResultManager.getConvertResultManager();
        this.ruleContext = ruleContext;
        this.ruleResultManager = ruleResultManager;
        this.initVars();
    }

    public ConvertContext getContext() {
        return this.context;
    }

    public ConvertResultManager getResultManager() {
        return this.resultManager;
    }

    public SingleRuleContext getRuleContext() {
        return this.ruleContext;
    }

    public SingleRuleResultManager getRuleResultManager() {
        return this.ruleResultManager;
    }

    public BillEntityType getSourceMainType() {
        return this.sourceMainType;
    }

    public EntryType getSourceEntry() {
        return this.sourceEntry;
    }

    public SubEntryType getSourceSubEntry() {
        return this.sourceSubEntry;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public LinkSetItemElement getLinkSetItem() {
        return this.linkSetItem;
    }

    public HashSet<String> getTargetEntityKeys() {
        return this.targetEntityKeys;
    }

    public DynamicObject getTargetDataEntity() {
        return this.targetDataEntity;
    }

    public ExtendedDataEntitySet getTargetExtDataSet() {
        return this.targetExtDataSet;
    }

    private void initVars() {
        this.sourceMainType = this.context.getSourceMainType();
        this.targetMainType = this.context.getTargetMainType();
        LinkEntityPolicy linkPolicy = this.ruleContext.getRule().getLinkEntityPolicy();
        String linkParentEntityKey = linkPolicy.getTargetEntryKey();
        if (StringUtils.isBlank((CharSequence)linkParentEntityKey)) {
            linkParentEntityKey = this.targetMainType.getName();
        }
        this.initLinkSet(linkParentEntityKey);
        this.initTargetEntityKeys(linkParentEntityKey);
        this.initSourceEntityKeys();
        this.targetDataEntity = ((BeforeDrawArgs)this.context.getInputArgs()).getTargetDataEntity((objs, dt) -> BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dt));
        this.targetExtDataSet = new ExtendedDataEntitySet();
        this.targetExtDataSet.Parse(new DynamicObject[]{this.targetDataEntity}, (MainEntityType)this.targetMainType);
    }

    private void initLinkSet(String linkParentEntityKey) {
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)this.targetMainType.getName());
        if (linkSet == null) {
            return;
        }
        for (LinkSetItemElement item : linkSet.getItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)linkParentEntityKey, (CharSequence)item.getParentEntityKey())) continue;
            this.linkSetItem = item;
            break;
        }
    }

    private void initTargetEntityKeys(String linkParentEntityKey) {
        this.targetEntityKeys.add(this.targetMainType.getName());
        EntityType entityType = (EntityType)this.targetMainType.getAllEntities().get(linkParentEntityKey);
        if (entityType instanceof SubEntryType) {
            this.targetEntityKeys.add(entityType.getName());
            this.targetEntityKeys.add(entityType.getParent().getName());
        } else if (entityType instanceof EntryType) {
            this.targetEntityKeys.add(entityType.getName());
            LinkEntityPolicy linkPolicy = this.ruleContext.getRule().getLinkEntityPolicy();
            if (StringUtils.isNotBlank((CharSequence)linkPolicy.getTargetSubEntryKey())) {
                this.targetEntityKeys.add(linkPolicy.getTargetSubEntryKey());
            }
        }
    }

    private void initSourceEntityKeys() {
        LinkEntityPolicy linkPolicy = this.ruleContext.getRule().getLinkEntityPolicy();
        if (StringUtils.isBlank((CharSequence)linkPolicy.getSourceEntryKey())) {
            return;
        }
        EntityType sourceEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkPolicy.getSourceEntryKey());
        if (sourceEntity instanceof SubEntryType) {
            this.sourceEntry = (EntryType)sourceEntity.getParent();
            this.sourceSubEntry = (SubEntryType)sourceEntity;
        } else if (sourceEntity instanceof EntryType) {
            EntityType sourceSubEntity;
            this.sourceEntry = (EntryType)sourceEntity;
            if (StringUtils.isNotBlank((CharSequence)linkPolicy.getSourceSubEntryKey()) && (sourceSubEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkPolicy.getSourceSubEntryKey())) instanceof SubEntryType) {
                this.sourceSubEntry = (SubEntryType)sourceSubEntity;
            }
        }
    }
}

