/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.actions.BuildDrawFilter;
import kd.bos.service.botp.convert.actions.BuildDrawFilterContext;
import kd.bos.service.botp.convert.actions.IFieldFilterBuilder;
import kd.bos.service.botp.convert.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.convert.getvaluemode.GetValueByCondition;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

class BuildDrawMainOrgFilter
extends BuildDrawFilter {
    private FieldMapItem orgFieldMapItem;
    private MainOrgProp targetMainOrgProp;

    public BuildDrawMainOrgFilter(BuildDrawFilterContext buildDrawFilterContext) {
        super(buildDrawFilterContext);
        if (StringUtils.isNotBlank((CharSequence)buildDrawFilterContext.getTargetMainType().getMainOrg())) {
            for (FieldMapItem item : buildDrawFilterContext.getRuleContext().getRule().getFieldMapPolicy().getFieldMaps()) {
                if (!item.isValid() || !StringUtils.equalsIgnoreCase((CharSequence)buildDrawFilterContext.getTargetMainType().getMainOrg(), (CharSequence)item.getTargetFieldKey())) continue;
                this.orgFieldMapItem = item;
            }
        }
        this.targetMainOrgProp = buildDrawFilterContext.getTargetMainType().getMainOrgProperty();
    }

    @Override
    public QFilter buildFilter() {
        Long targetOrgId;
        QFilter orgFilter = null;
        if (this.targetMainOrgProp == null) {
            return orgFilter;
        }
        DynamicObject targetOrgObj = (DynamicObject)IFieldFilterBuilder.getTargetFieldValue(this.getBuildDrawFilterContext().getTargetExtDataSet(), (IDataEntityProperty)this.targetMainOrgProp);
        Long l = targetOrgId = targetOrgObj == null ? Long.valueOf(0L) : (Long)targetOrgObj.getPkValue();
        if (0L == targetOrgId) {
            return orgFilter;
        }
        if (this.orgFieldMapItem == null) {
            return orgFilter;
        }
        IMappingField mappingOrgField = IMappingField.create(this.getBuildDrawFilterContext().getRuleContext(), this.orgFieldMapItem);
        switch (this.orgFieldMapItem.getFieldConvertType()) {
            case CONSTANT: {
                break;
            }
            case SourceField: {
                if (this.orgFieldMapItem.isDrawFilter()) break;
                orgFilter = IFieldFilterBuilder.buildQFilter(this.getBuildDrawFilterContext(), this.orgFieldMapItem);
                break;
            }
            case Formula: {
                if (!(mappingOrgField.getUnionMode().getValueMode() instanceof GetFormulaValue)) break;
                GetFormulaValue formula = (GetFormulaValue)mappingOrgField.getUnionMode().getValueMode();
                orgFilter = this.getOrgByFormula(formula, targetOrgId);
                break;
            }
            case ByCondition: {
                if (!(mappingOrgField.getUnionMode().getValueMode() instanceof GetValueByCondition)) break;
                GetValueByCondition conditions = (GetValueByCondition)mappingOrgField.getUnionMode().getValueMode();
                orgFilter = this.getOrgByCondition(conditions, targetOrgId);
                break;
            }
        }
        return orgFilter;
    }

    private QFilter getOrgByFormula(GetFormulaValue getValueModel, Long targetOrgId) {
        QFilter qFilter = null;
        if (getValueModel.getFuncs().contains("GetRelationOrg")) {
            String[] params = this.parseFuncParams(getValueModel.getFormula());
            if (params == null || params.length < 4) {
                return qFilter;
            }
            for (IVariableMode var : getValueModel.getVars()) {
                if (!(var instanceof SourceFieldVariable)) continue;
                if (!(((SourceFieldVariable)var).getSourceField() instanceof OrgProp)) break;
                OrgProp srcOrgProp = (OrgProp)((SourceFieldVariable)var).getSourceField();
                String direction = params[1];
                boolean isEntrust = StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)"0");
                String formViewType = params[2];
                String toViewType = params[3];
                List relationOrgs = null;
                relationOrgs = isEntrust ? OrgUnitServiceHelper.getFromOrgs((String)toViewType, (Long)targetOrgId, (String)formViewType) : OrgUnitServiceHelper.getAllToOrg((String)formViewType, (String)toViewType, (Long)targetOrgId);
                if (relationOrgs.isEmpty()) {
                    qFilter = new QFilter(IFieldFilterBuilder.buildSrcFieldFullName((IDataEntityProperty)srcOrgProp), "=", (Object)targetOrgId);
                    break;
                }
                if (relationOrgs.size() == 1) {
                    qFilter = new QFilter(IFieldFilterBuilder.buildSrcFieldFullName((IDataEntityProperty)srcOrgProp), "=", relationOrgs.get(0));
                    break;
                }
                qFilter = new QFilter(IFieldFilterBuilder.buildSrcFieldFullName((IDataEntityProperty)srcOrgProp), "in", (Object)relationOrgs.toArray(new Long[0]));
                break;
            }
        }
        return qFilter;
    }

    private QFilter getOrgByCondition(GetValueByCondition getValueModel, Long targetOrgId) {
        QFilter qFilter = null;
        for (Tuple<IGetValueMode, IGetValueMode> item : getValueModel.getValueHandlers()) {
            QFilter qFilter2;
            if (!(item.item2 instanceof GetFormulaValue) || (qFilter2 = this.getOrgByFormula((GetFormulaValue)item.item2, targetOrgId)) == null) continue;
            if (qFilter == null) {
                qFilter = qFilter2;
                continue;
            }
            qFilter = qFilter.or(qFilter2);
        }
        return qFilter;
    }

    private String[] parseFuncParams(String formula) {
        int begin = formula.indexOf(40);
        if (begin < 0) {
            return null;
        }
        String paramStr = formula.substring(begin + 1);
        int end = paramStr.indexOf(41);
        String[] params = (paramStr = paramStr.substring(0, end)).split(",");
        if (params.length < 4) {
            return null;
        }
        String orgPropName = params[0].trim();
        String direction = params[1].trim();
        direction = direction.replaceAll("'", "");
        String formViewType = params[2].trim();
        formViewType = formViewType.replaceAll("'", "");
        String toViewType = params[3].trim();
        toViewType = toViewType.replaceAll("'", "");
        return new String[]{orgPropName, direction, formViewType, toViewType};
    }
}

