/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.PushAndDrawUtil;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;

public class BuildPushLayoutAction
extends AbstractConvertAction {
    public BuildPushLayoutAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        Map<String, String> formidMap;
        super.doAction();
        String layout = this.getContext().getTargetMainType().getName();
        String layout_mob = layout + "_mob";
        String op_target_bill_formid = this.context.getOption().getVariableValue("botp_push_target_bill_formid", "");
        String op_target_bills_formid = this.context.getOption().getVariableValue("botp_push_target_bills_formid", "");
        String op_target_bill_mobformid = this.context.getOption().getVariableValue("botp_push_target_bill_mobformid", "");
        String op_target_bills_mobformid = this.context.getOption().getVariableValue("botp_push_target_bills_mobformid", "");
        String mobTargetLayout = this.getRuleContext().getRule().getLinkEntityPolicy().getMobTargetLayout();
        layout = StringUtils.isNotBlank((CharSequence)op_target_bill_formid) ? op_target_bill_formid : (StringUtils.isNotBlank((CharSequence)op_target_bills_formid) ? ((formidMap = this.fromJsonString(op_target_bills_formid)).containsKey(this.context.getTargetMainType().getName()) ? formidMap.get(this.context.getTargetMainType().getName()) : this.getBillLayout()) : this.getBillLayout());
        if (StringUtils.isNotBlank((CharSequence)op_target_bill_mobformid)) {
            layout_mob = op_target_bill_mobformid;
        } else if (StringUtils.isNotBlank((CharSequence)op_target_bills_mobformid)) {
            formidMap = this.fromJsonString(op_target_bills_mobformid);
            if (formidMap.containsKey(this.context.getTargetMainType().getName())) {
                layout_mob = formidMap.get(this.context.getTargetMainType().getName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)mobTargetLayout)) {
            layout_mob = mobTargetLayout;
        }
        layout = PushAndDrawUtil.isMetadataExist((String)layout) ? layout : this.getContext().getTargetMainType().getName();
        layout_mob = PushAndDrawUtil.isMetadataExist((String)layout_mob) ? layout_mob : this.getContext().getTargetMainType().getName() + "_mob";
        this.getResultManager().setTargetBillFormId(layout);
        this.getResultManager().setTargetBillMobFormId(layout_mob);
    }

    private String getBillLayout() {
        String layout;
        String billTypeLayout = this.getBillTypeLayout();
        if (StringUtils.isNotBlank((CharSequence)billTypeLayout)) {
            layout = billTypeLayout;
        } else {
            String targetLayout = this.getRuleContext().getRule().getLinkEntityPolicy().getTargetLayout();
            boolean hasRuleLayout = StringUtils.isNotBlank((CharSequence)targetLayout);
            boolean isPushArgs = this.getContext().getInputArgs() instanceof PushArgs;
            boolean batchPushAutoMatchRule = isPushArgs && ((PushArgs)this.getContext().getInputArgs()).getSelectedRows() != null && ((PushArgs)this.getContext().getInputArgs()).getSelectedRows().size() > 1 && StringUtils.isBlank((CharSequence)this.getContext().getInputArgs().getRuleId());
            boolean limitSingleRule = isPushArgs && ((PushArgs)this.getContext().getInputArgs()).getRuleIds() != null && ((PushArgs)this.getContext().getInputArgs()).getRuleIds().size() == 1;
            boolean useRuleLayout = hasRuleLayout && (!batchPushAutoMatchRule || limitSingleRule);
            layout = useRuleLayout ? targetLayout : this.getContext().getTargetMainType().getName();
        }
        return layout;
    }

    private Map<String, String> fromJsonString(String str) {
        try {
            if (StringUtils.isBlank((CharSequence)str)) {
                return new HashMap<String, String>(0);
            }
            return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        catch (Exception e) {
            return new HashMap<String, String>(0);
        }
    }

    private String getBillTypeLayout() {
        BillEntityType targetMainType = this.getContext().getTargetMainType();
        if (StringUtils.isBlank((CharSequence)targetMainType.getBillType())) {
            return null;
        }
        ExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        ExtendedDataEntity[] headDataEntities = targetExtDataSet.FindByEntityKey(targetMainType.getName());
        if (headDataEntities == null || headDataEntities.length == 0) {
            return null;
        }
        Long billTypeId = headDataEntities[0].getDataEntity().getLong(targetMainType.getBillType() + "_id");
        if (billTypeId != null && Long.compare(0L, billTypeId) != 0) {
            String billFormId;
            ORM orm = ORM.create();
            QFilter[] filter = new QFilter[]{new QFilter("id", "=", (Object)billTypeId)};
            String layoutId = null;
            try (DataSet ds = orm.queryDataSet("BuildPushLayoutAction.getBillTypeLayout", "bos_billtype", "id, number, billformid, layoutsolution", filter);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    layoutId = row.getString("layoutsolution");
                }
            }
            if (StringUtils.isNotBlank(layoutId) && !StringUtils.equalsIgnoreCase((CharSequence)"null", (CharSequence)layoutId) && StringUtils.isNotBlank((CharSequence)(billFormId = this.loadFormNumber(targetMainType.getName(), layoutId)))) {
                return billFormId;
            }
        }
        return null;
    }

    private String loadFormNumber(String entityNumber, String layoutId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.FId, t0.FNumber ");
        sBuilder.append("FROM T_META_FORMDESIGN t0 LEFT JOIN T_META_ENTITYDESIGN t1 on (t0.FEntityId = t1.FId)");
        sBuilder.append("WHERE t0.FId = ? AND t1.FNumber = ?");
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)layoutId), new SqlParameter(":FNumber", 12, (Object)entityNumber)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String formNumber = rs.getString("FNumber");
                    return formNumber;
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
    }
}

