/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.botp.constants.PluginPositionEnum;
import kd.bos.entity.botp.plugin.ConvertPlugInProxy;
import kd.bos.entity.botp.plugin.IConvertPlugIn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.plugin.PluginRegistService;
import org.apache.commons.collections.MapUtils;

public class CreateConvertPlugAction
extends AbstractConvertAction {
    private static final Log log = LogFactory.getLog(CreateConvertPlugAction.class);

    public CreateConvertPlugAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initializePlugIns();
    }

    private void initializePlugIns() {
        List pluginDefines = this.ruleContext.getRule().getPlugInPolicy().getPlugins();
        ArrayList<CRPlugin> sortPlugins = new ArrayList<CRPlugin>(pluginDefines);
        sortPlugins.sort(new Comparator<CRPlugin>(){

            @Override
            public int compare(CRPlugin o1, CRPlugin o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        Map<String, Integer> pluginMap = PluginRegistService.getPluginMap();
        if (MapUtils.isNotEmpty(pluginMap)) {
            log.info("\u6ce8\u518c\u7684\u6709\u5168\u5c40\u63d2\u4ef6\u3002");
        }
        for (Map.Entry<String, Integer> entry : pluginMap.entrySet()) {
            CRPlugin crPlugin = new CRPlugin();
            crPlugin.setClassName(entry.getKey());
            crPlugin.setEnabled(true);
            crPlugin.setType(0);
            if (entry.getValue().equals(PluginPositionEnum.BEFORE.getValue())) {
                sortPlugins.add(0, crPlugin);
                continue;
            }
            sortPlugins.add(crPlugin);
        }
        ConvertPlugInProxy plugProxy = new ConvertPlugInProxy(sortPlugins);
        plugProxy.setContext(this.context.getConvertOpType(), this.context.getSourceMainType(), this.context.getTargetMainType(), this.ruleContext.getRule());
        plugProxy.setCreateReport(Boolean.valueOf(this.ruleContext.isCreateReport()));
        for (IConvertPlugIn plugIn : plugProxy.getPlugIns()) {
            plugIn.setOption(this.context.getOption());
        }
        this.ruleContext.setPlugInProxy(plugProxy);
    }
}

