/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.SubEntryType;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.DependEntityMap;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.sort.SourceRowComparator;
import kd.bos.service.business.datamodel.DrawDataModel;

public class CreateDependEntityRowsAction
extends AbstractConvertAction {
    private DrawDataModel modelProxy = null;
    private ExtendedDataEntitySet targetExtSet;

    private List<DynamicObject> getSourceRows(DependEntityMap entityMap) {
        if (this.batchContext != null) {
            return this.batchContext.getDependEntitySourceRows(entityMap);
        }
        return entityMap.getSourceRows();
    }

    public CreateDependEntityRowsAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        this.modelProxy = this.getModelProxy();
        this.targetExtSet = this.getTargetExtendedDataEntities();
        this.getRuleContext().getRuleCompiler().getLinkEntityMap();
        HashMap<String, DependEntityMap> headEntityMap = new HashMap<String, DependEntityMap>();
        HashMap<String, DependEntityMap> entryEntityMap = new HashMap<String, DependEntityMap>();
        HashMap<String, DependEntityMap> subEntryEntityMap = new HashMap<String, DependEntityMap>();
        for (Map.Entry<String, DependEntityMap> entry : this.ruleContext.getRuleCompiler().getDependEntityMaps().entrySet()) {
            String key = entry.getKey();
            DependEntityMap entityMap = entry.getValue();
            for (EntityType targetEntry : entityMap.getTargetFields().keySet()) {
                if (targetEntry instanceof SubEntryType) {
                    subEntryEntityMap.put(key, entityMap);
                    continue;
                }
                if (targetEntry instanceof EntryType) {
                    entryEntityMap.put(key, entityMap);
                    continue;
                }
                headEntityMap.put(key, entityMap);
            }
        }
        this.modelProxy.beginInit();
        for (Map.Entry<String, DependEntityMap> entry : headEntityMap.entrySet()) {
            this.mapMainType(entry.getValue());
        }
        for (Map.Entry<String, DependEntityMap> entry : entryEntityMap.entrySet()) {
            this.mapEntryType(entry.getValue());
        }
        for (Map.Entry<String, DependEntityMap> entry : subEntryEntityMap.entrySet()) {
            DependEntityMap entityMap = entry.getValue();
            if (entityMap.getTargetAnchorEntityKey().equalsIgnoreCase(this.context.getTargetMainType().getName())) {
                this.mapSubEntryTypeWithParent(entityMap);
                continue;
            }
            this.mapSubEntryTypeOnly(entityMap);
        }
        this.modelProxy.endInit();
    }

    private void mapMainType(DependEntityMap entityMap) {
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        ExtendedDataEntity[] headRows = this.targetExtSet.FindByEntityKey(this.context.getTargetMainType().getName());
        SourceRowComparator comparator = new SourceRowComparator(this.ruleContext, entityMap);
        for (ExtendedDataEntity dataEntity : headRows) {
            List<DynamicObject> myBillDependRows = this.findMyBillDependRows(dataEntity, entityMap, comparator, srcDependRows);
            if (myBillDependRows.isEmpty()) continue;
            dataEntity.setValue(entityMap.getJoinSourceEntityKeys(), myBillDependRows);
        }
    }

    private void mapEntryType(DependEntityMap entityMap) {
        ExtendedDataEntity[] headDataEntities;
        EntityType entityType = entityMap.getTargetEntity();
        if (entityType instanceof SubEntryType) {
            entityType = (EntityType)entityType.getParent();
        }
        ArrayList<ExtendedDataEntity> entryExtEntitys = new ArrayList<ExtendedDataEntity>();
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        SourceRowComparator comparator = new SourceRowComparator(this.ruleContext, entityMap);
        for (ExtendedDataEntity headDataEntity : headDataEntities = this.targetExtSet.FindByEntityKey(this.context.getTargetMainType().getName())) {
            List<DynamicObject> myDependRows = this.findMyBillDependRows(headDataEntity, entityMap, comparator, srcDependRows);
            if (myDependRows.isEmpty() || this.isMergeIntoLinkEntryRow(entityMap, entityMap.getTargetEntryKey(), myDependRows)) continue;
            Map<SourceRowsGroupKey, List<DynamicObject>> srcRowGroups = this.splitBySourceEntityId(entityMap, myDependRows);
            this.modelProxy.draw(headDataEntity.getDataEntity());
            int rowIndex = this.batchCreateNewEntryRow(headDataEntity, entityType.getName(), srcRowGroups.size());
            for (Map.Entry<SourceRowsGroupKey, List<DynamicObject>> group : srcRowGroups.entrySet()) {
                List<DynamicObject> list = group.getValue();
                DynamicObject entryRow = this.modelProxy.getEntryEntity(entityType.getName(), rowIndex);
                entryRow.getDataEntityState().setPushChanged(true);
                ExtendedDataEntity entryExtEntity = new ExtendedDataEntity(entryRow, headDataEntity.getDataEntityIndex(), rowIndex);
                entryExtEntity.setValue(entityMap.getJoinSourceEntityKeys(), list);
                entryExtEntity.setValue("isNewEntity", (Object)Boolean.TRUE);
                entryExtEntitys.add(entryExtEntity);
                ++rowIndex;
            }
        }
        this.targetExtSet.AddExtendedDataEntities(entityType.getName(), entryExtEntitys);
    }

    private void mapSubEntryTypeOnly(DependEntityMap entityMap) {
        SubEntryType subEntryType = (SubEntryType)entityMap.getTargetEntity();
        EntryType entryType = (EntryType)subEntryType.getParent();
        ArrayList<ExtendedDataEntity> extSubEntryEntitys = new ArrayList<ExtendedDataEntity>();
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        SourceRowComparator comparator = new SourceRowComparator(this.ruleContext, entityMap);
        ExtendedDataEntity[] headDataEntities = this.targetExtSet.FindByEntityKey(this.context.getTargetMainType().getName());
        Map<Integer, List<ExtendedDataEntity>> entryDataEntityMap = this.splitByDataIndex(entryType.getName());
        for (ExtendedDataEntity headDataEntitiy : headDataEntities) {
            this.modelProxy.draw(headDataEntitiy.getDataEntity());
            List<ExtendedDataEntity> entryRows = entryDataEntityMap.get(headDataEntitiy.getDataEntityIndex());
            if (entryRows == null) continue;
            for (ExtendedDataEntity entryRow : entryRows) {
                this.createSubEntryRows(entityMap, headDataEntitiy, entryRow, subEntryType, extSubEntryEntitys, srcDependRows, comparator);
            }
        }
        this.targetExtSet.AddExtendedDataEntities(subEntryType.getName(), extSubEntryEntitys);
    }

    private void createSubEntryRows(DependEntityMap entityMap, ExtendedDataEntity headDataEntitiy, ExtendedDataEntity entryRow, SubEntryType subEntryType, List<ExtendedDataEntity> extSubEntryEntitys, Map<Long, List<DynamicObject>> srcDependRows, SourceRowComparator comparator) {
        List<DynamicObject> myEntryDependRows = this.findMyEntryDependRows(entryRow, entityMap, comparator, srcDependRows);
        if (myEntryDependRows.isEmpty()) {
            return;
        }
        if (this.isMergeIntoLinkEntryRow(entityMap, entityMap.getTargetSubEntryKey(), myEntryDependRows)) {
            return;
        }
        Map<SourceRowsGroupKey, List<DynamicObject>> srcRowGroups = this.splitBySourceEntityId(entityMap, myEntryDependRows);
        this.modelProxy.setEntryCurrentRowIndex(subEntryType.getParent().getName(), entryRow.getRowIndex());
        int subRowIndex = 0;
        int subRowCount = this.modelProxy.getEntryRowCount(subEntryType.getName());
        if (subRowCount < srcRowGroups.size()) {
            this.modelProxy.batchCreateNewEntryRow(subEntryType.getName(), srcRowGroups.size() - subRowCount);
        }
        for (Map.Entry<SourceRowsGroupKey, List<DynamicObject>> group : srcRowGroups.entrySet()) {
            List<DynamicObject> list = group.getValue();
            DynamicObject subEntryRow = this.modelProxy.getEntryEntity(subEntryType.getName(), subRowIndex);
            subEntryRow.getDataEntityState().setPushChanged(true);
            ExtendedDataEntity subEntryExtEntity = new ExtendedDataEntity(subEntryRow, headDataEntitiy.getDataEntityIndex(), entryRow.getRowIndex(), subRowIndex, "");
            subEntryExtEntity.setValue(entityMap.getJoinSourceEntityKeys(), list);
            subEntryExtEntity.setValue("isNewEntity", (Object)Boolean.TRUE);
            extSubEntryEntitys.add(subEntryExtEntity);
            ++subRowIndex;
        }
    }

    private void mapSubEntryTypeWithParent(DependEntityMap entityMap) {
        ExtendedDataEntity[] headDataEntities;
        SubEntryType subEntryType = (SubEntryType)entityMap.getTargetEntity();
        EntryType entryType = (EntryType)subEntryType.getParent();
        ArrayList<ExtendedDataEntity> extEntryEntitys = new ArrayList<ExtendedDataEntity>();
        ArrayList<ExtendedDataEntity> extSubEntryEntitys = new ArrayList<ExtendedDataEntity>();
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        SourceRowComparator comparator = new SourceRowComparator(this.ruleContext, entityMap);
        for (ExtendedDataEntity headDataEntity : headDataEntities = this.targetExtSet.FindByEntityKey(this.context.getTargetMainType().getName())) {
            List<DynamicObject> myBillDependRows = this.findMyBillDependRows(headDataEntity, entityMap, comparator, srcDependRows);
            if (myBillDependRows.isEmpty()) continue;
            Map<SourceRowsGroupKey, List<DynamicObject>> srcRowGroups = this.splitBySourceEntityId(entityMap, myBillDependRows);
            this.modelProxy.draw(headDataEntity.getDataEntity());
            int rowIndex = this.batchCreateNewEntryRow(headDataEntity, entryType.getName(), srcRowGroups.size());
            for (Map.Entry<SourceRowsGroupKey, List<DynamicObject>> group : srcRowGroups.entrySet()) {
                this.modelProxy.setEntryCurrentRowIndex(entryType.getName(), rowIndex);
                List<DynamicObject> srcRows = group.getValue();
                DynamicObject entryRow = this.modelProxy.getEntryEntity(entryType.getName(), rowIndex);
                entryRow.getDataEntityState().setPushChanged(true);
                ExtendedDataEntity extEntryRow = new ExtendedDataEntity(entryRow, headDataEntity.getDataEntityIndex(), rowIndex);
                extEntryRow.setValue(entityMap.getJoinSourceEntityKeys(), srcRows);
                extEntryRow.setValue("isNewEntity", (Object)Boolean.TRUE);
                extEntryEntitys.add(extEntryRow);
                int subRowIndex = 0;
                int subRowCount = this.modelProxy.getEntryRowCount(subEntryType.getName());
                if (subRowCount == 0) {
                    this.modelProxy.createNewEntryRow(subEntryType.getName());
                }
                DynamicObject subEntryRow = this.modelProxy.getEntryRowEntity(subEntryType.getName(), subRowIndex);
                subEntryRow.getDataEntityState().setPushChanged(true);
                ExtendedDataEntity extSubEntryRow = new ExtendedDataEntity(subEntryRow, headDataEntity.getDataEntityIndex(), rowIndex, subRowIndex, "");
                extSubEntryRow.setValue(entityMap.getJoinSourceEntityKeys(), srcRows);
                extSubEntryRow.setValue("isNewEntity", (Object)Boolean.TRUE);
                extSubEntryEntitys.add(extSubEntryRow);
                ++rowIndex;
            }
        }
        this.targetExtSet.AddExtendedDataEntities(entryType.getName(), extEntryEntitys);
        this.targetExtSet.AddExtendedDataEntities(subEntryType.getName(), extSubEntryEntitys);
    }

    private boolean isMergeIntoLinkEntryRow(DependEntityMap entityMap, String targetEntityKey, List<DynamicObject> myDependRows) {
        return false;
    }

    private Map<Long, List<DynamicObject>> splitBySrcAnchorRowId(DependEntityMap entityMap) {
        Map<String, DynamicProperty> srcFldPropertys = entityMap.getSrcFldPropertys();
        HashMap<Long, List<DynamicObject>> srcDependRows = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject dependRow : this.getSourceRows(entityMap)) {
            Long srcRowId = (Long)entityMap.getSrcAnchorRowIdGetter().getValue(srcFldPropertys, dependRow);
            if (!srcDependRows.containsKey(srcRowId)) {
                srcDependRows.put(srcRowId, new ArrayList());
            }
            ((List)srcDependRows.get(srcRowId)).add(dependRow);
        }
        return srcDependRows;
    }

    private List<DynamicObject> findMyBillDependRows(ExtendedDataEntity headDataEntity, DependEntityMap entityMap, SourceRowComparator comparator, Map<Long, List<DynamicObject>> srcDependRows) {
        List<ExtendedDataEntity> targetAnchorRows = this.findMyBillEntryRows(headDataEntity, entityMap);
        ArrayList<DynamicObject> myBillDependRows = new ArrayList<DynamicObject>();
        for (ExtendedDataEntity targetAnchorRow : targetAnchorRows) {
            Set<Long> srcRowIds = this.findMySrcAnchorRowIds(entityMap, targetAnchorRow);
            for (Long srcRowId : srcRowIds) {
                List<DynamicObject> list = srcDependRows.get(srcRowId);
                if (list == null) continue;
                list.sort(comparator);
                myBillDependRows.addAll(list);
            }
        }
        return myBillDependRows;
    }

    private List<ExtendedDataEntity> findMyBillEntryRows(ExtendedDataEntity headDataEntity, DependEntityMap entityMap) {
        ArrayList<ExtendedDataEntity> targetAnchorRows = new ArrayList<ExtendedDataEntity>();
        if (entityMap.getTargetAnchorEntityKey().equalsIgnoreCase(this.context.getTargetMainType().getName())) {
            targetAnchorRows.add(headDataEntity);
        } else {
            ExtendedDataEntity[] extRows;
            for (ExtendedDataEntity extRow : extRows = this.targetExtSet.FindByEntityKey(entityMap.getTargetAnchorEntityKey())) {
                if (extRow.getDataEntityIndex() != headDataEntity.getDataEntityIndex()) continue;
                targetAnchorRows.add(extRow);
            }
        }
        return targetAnchorRows;
    }

    private Set<Long> findMySrcAnchorRowIds(DependEntityMap entityMap, ExtendedDataEntity targetAnchorRow) {
        LinkedHashSet<Long> srcRowIds = new LinkedHashSet<Long>(32);
        Object sourceRows = null;
        sourceRows = entityMap.getTargetAnchorEntityMap() instanceof LinkEntityMap ? targetAnchorRow.getValue("ConvertSource") : targetAnchorRow.getValue(entityMap.getTargetAnchorEntityMap().getJoinSourceEntityKeys());
        if (sourceRows == null) {
            return srcRowIds;
        }
        List srcAnchorRows = (List)sourceRows;
        Map<String, DynamicProperty> anchorRowFldPropertys = entityMap.getTargetAnchorEntityMap().getSrcFldPropertys();
        for (DynamicObject srcAnchorRow : srcAnchorRows) {
            Long srcRowId = (Long)entityMap.getSrcAnchorRowIdGetter().getValue(anchorRowFldPropertys, srcAnchorRow);
            if (srcRowIds.contains(srcRowId)) continue;
            srcRowIds.add(srcRowId);
        }
        return srcRowIds;
    }

    private List<DynamicObject> findMyEntryDependRows(ExtendedDataEntity entryDataEntity, DependEntityMap entityMap, SourceRowComparator comparator, Map<Long, List<DynamicObject>> srcDependRows) {
        ArrayList<DynamicObject> myEntryDependRows = new ArrayList<DynamicObject>();
        Map<String, DynamicProperty> anchorRowFldPropertys = entityMap.getTargetAnchorEntityMap().getSrcFldPropertys();
        Object sourceRows = null;
        sourceRows = entityMap.getTargetAnchorEntityMap() instanceof LinkEntityMap ? entryDataEntity.getValue("ConvertSource") : entryDataEntity.getValue(entityMap.getTargetAnchorEntityMap().getJoinSourceEntityKeys());
        if (sourceRows == null) {
            return myEntryDependRows;
        }
        List srcAnchorRows = (List)sourceRows;
        HashSet<Long> srcRowIds = new HashSet<Long>();
        for (DynamicObject srcAnchorRow : srcAnchorRows) {
            Long srcRowId = (Long)entityMap.getSrcAnchorRowIdGetter().getValue(anchorRowFldPropertys, srcAnchorRow);
            if (srcRowIds.contains(srcRowId)) continue;
            srcRowIds.add(srcRowId);
            List<DynamicObject> list = srcDependRows.get(srcRowId);
            if (list == null) continue;
            list.sort(comparator);
            myEntryDependRows.addAll(list);
        }
        return myEntryDependRows;
    }

    private Map<SourceRowsGroupKey, List<DynamicObject>> splitBySourceEntityId(DependEntityMap dependEntityMap, List<DynamicObject> srcRows) {
        LinkedHashMap<SourceRowsGroupKey, List<DynamicObject>> groups = new LinkedHashMap<SourceRowsGroupKey, List<DynamicObject>>();
        for (DynamicObject srcRow : srcRows) {
            SourceRowsGroupKey groupKey = dependEntityMap.getSourceRowsGroupKeyBuilders().get(0).getFldValues(dependEntityMap.getSrcFldPropertys(), srcRow);
            if (!groups.containsKey(groupKey)) {
                groups.put(groupKey, new ArrayList());
            }
            ((List)groups.get(groupKey)).add(srcRow);
        }
        return groups;
    }

    private Map<Integer, List<ExtendedDataEntity>> splitByDataIndex(String entityKey) {
        ExtendedDataEntity[] entryDataEntities = this.targetExtSet.FindByEntityKey(entityKey);
        HashMap<Integer, List<ExtendedDataEntity>> entryDataEntityMap = new HashMap<Integer, List<ExtendedDataEntity>>();
        for (ExtendedDataEntity entryDataEntity : entryDataEntities) {
            Integer dataIndex = entryDataEntity.getDataEntityIndex();
            if (!entryDataEntityMap.containsKey(dataIndex)) {
                entryDataEntityMap.put(dataIndex, new ArrayList());
            }
            ((List)entryDataEntityMap.get(dataIndex)).add(entryDataEntity);
        }
        return entryDataEntityMap;
    }

    private int batchCreateNewEntryRow(ExtendedDataEntity headDataEntity, String entryKey, int count) {
        int rowCount;
        boolean isNewBill = this.isNewEntity(headDataEntity);
        int rowIndex = rowCount = this.modelProxy.getEntryRowCount(entryKey);
        if (!isNewBill) {
            this.modelProxy.batchCreateNewEntryRow(entryKey, count);
        } else {
            rowIndex = 0;
            if (count > rowCount) {
                this.modelProxy.batchCreateNewEntryRow(entryKey, count - rowCount);
            }
        }
        return rowIndex;
    }

    private boolean isNewEntity(ExtendedDataEntity dataEntity) {
        boolean newEntity = false;
        Object extNewEntityValue = dataEntity.getValue("isNewEntity");
        if (extNewEntityValue != null) {
            newEntity = (Boolean)extNewEntityValue;
        }
        return newEntity;
    }
}

