/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.report.IBuildDetailReport;
import kd.bos.util.CollectionUtils;

public class CreateOrgCheckAction
extends AbstractConvertAction {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final String CUSTOM_PARAM_KEY = "checkBaseDataCtrl";
    private boolean checkBillFlag = false;

    public CreateOrgCheckAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void doAction() {
        String targetNumber;
        super.doAction();
        BillEntityType sourceMainType = this.context.getSourceMainType();
        BillEntityType targetMainType = this.context.getTargetMainType();
        String string = targetNumber = targetMainType.getName() == null ? "" : targetMainType.getName();
        if (sourceMainType.getName().equals("bd_material") && (targetNumber.equals("bd_materialpurchaseinfo") || targetNumber.equals("bd_materialinventoryinfo") || targetNumber.equals("bd_materialsalinfo") || targetNumber.equals("bd_materialmftinfo") || targetNumber.equals("bd_inspect_cfg") || targetNumber.equals("bd_materialcalinfo"))) {
            this.checkBillFlag = true;
        }
        if (this.context.isBaseDataCtrl() && this.context.isParamCheckBaseDataCtrl() && this.checkBillFlag) {
            ConvertReportManager reportManager = this.resultManager.getReporter();
            LinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
            Map<String, DynamicProperty> fldProperties = linkEntityMap.getSrcFldPropertys();
            EntityType linkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(linkEntityMap.getSourceLinkEntityKey());
            IBuildDetailReport reportBuilder = this.ruleContext.getSrcRowReportBuilder(linkEntity);
            boolean orgCheck = false;
            ExtendedDataEntitySet targetExtSet = this.getTargetExtendedDataEntities();
            ExtendedDataEntity[] headExtEntitys = targetExtSet.FindByEntityKey(targetMainType.getName());
            if (headExtEntitys == null) {
                return;
            }
            for (ExtendedDataEntity headExtEntity : headExtEntitys) {
                String failMessage;
                List<Long> list;
                String createOrgName = "";
                DynamicObject createOrg = (DynamicObject)headExtEntity.getValue("createorg");
                if (createOrg == null) continue;
                Long createOrgId = (Long)createOrg.getPkValue();
                OrmLocaleValue orgLocalName = (OrmLocaleValue)createOrg.get("name");
                if (orgLocalName != null) {
                    createOrgName = orgLocalName.getLocaleValue();
                }
                if (CollectionUtils.isNotEmpty(list = this.context.getTargetCreateOrgList()) && !list.contains(createOrgId)) {
                    orgCheck = true;
                    failMessage = String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7[%1$s]\u65e0[%2$s]\u521b\u5efa\u6743\u9650", (String)"CreateOrgCheckAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), createOrgName, targetMainType.getDisplayName() == null ? targetNumber : targetMainType.getDisplayName().toString());
                    for (DynamicObject sourceRow : linkEntityMap.getSourceRows()) {
                        reportBuilder.addLinkRow(reportManager, fldProperties, sourceRow);
                        reportBuilder.addErrorReport(reportManager, fldProperties, sourceRow, failMessage);
                    }
                    continue;
                }
                if (!CollectionUtils.isEmpty(list)) continue;
                orgCheck = true;
                failMessage = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa[%s]\u7684\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e", (String)"CreateOrgCheckAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), targetMainType.getDisplayName() == null ? targetNumber : targetMainType.getDisplayName().toString());
                for (DynamicObject sourceRow : linkEntityMap.getSourceRows()) {
                    reportBuilder.addLinkRow(reportManager, fldProperties, sourceRow);
                    reportBuilder.addErrorReport(reportManager, fldProperties, sourceRow, failMessage);
                }
            }
            if (orgCheck) {
                this.setSkipNextAction(true);
                String failMessage = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u65e0\u521b\u5efa\u6743\u9650", (String)"CreateOrgCheckAction_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
                this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), failMessage);
            }
        }
    }
}

