/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.plugin.args.AfterBizRuleEventArgs;
import kd.bos.entity.botp.runtime.CRBizRuleAction;
import kd.bos.entity.botp.runtime.CRBizRuleContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;

public class ExecuteBizRuleAction
extends AbstractConvertAction {
    private BillEntityType tgtMainType;
    private ExtendedDataEntitySet extDataEntitySet;

    public ExecuteBizRuleAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.tgtMainType = this.context.getTargetMainType();
        this.extDataEntitySet = this.getTargetExtendedDataEntities();
        List<CRBizRuleElement> bizRules = this.sortBizRules();
        for (CRBizRuleElement bizRule : bizRules) {
            if (StringUtils.isBlank((CharSequence)bizRule.getActionId()) || StringUtils.isBlank((CharSequence)bizRule.getRunActionClass())) continue;
            CRBizRuleAction bizRuleAction = this.createBizRuleAction(bizRule);
            this.executeBizRuleAction(bizRuleAction);
        }
        AfterBizRuleEventArgs eventArgs = new AfterBizRuleEventArgs(this.extDataEntitySet, this.ruleContext.getRuleCompiler().getLinkEntityMap().getSrcFldPropertys());
        this.ruleContext.getPlugInProxy().fireAfterBizRule(eventArgs);
    }

    private void executeBizRuleAction(CRBizRuleAction bizRuleAction) {
        String entityKey = bizRuleAction.getEntityKey();
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            entityKey = this.tgtMainType.getName();
        }
        ExtendedDataEntity[] extDataEntities = this.extDataEntitySet.FindByEntityKey(entityKey);
        RowDataModel rowDataModel = new RowDataModel(entityKey, (MainEntityType)this.tgtMainType);
        extDataEntities = this.validatePreCondition(bizRuleAction, rowDataModel, extDataEntities);
        bizRuleAction.doAction(this.extDataEntitySet, rowDataModel, extDataEntities);
    }

    private ExtendedDataEntity[] validatePreCondition(CRBizRuleAction bizRuleAction, RowDataModel rowDataModel, ExtendedDataEntity[] extDataEntities) {
        ArrayList<ExtendedDataEntity> passRows = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity entityRow : extDataEntities) {
            if (!bizRuleAction.checkPreCondition(rowDataModel, entityRow.getDataEntity())) continue;
            passRows.add(entityRow);
        }
        return passRows.toArray(new ExtendedDataEntity[0]);
    }

    private List<CRBizRuleElement> sortBizRules() {
        ArrayList<CRBizRuleElement> bizRules = new ArrayList<CRBizRuleElement>();
        for (CRBizRuleElement bizRule : this.ruleContext.getRule().getBizRulePolicy().getActions()) {
            if (!bizRule.isEnabled()) continue;
            bizRules.add(bizRule);
        }
        bizRules.sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        return bizRules;
    }

    private CRBizRuleAction createBizRuleAction(CRBizRuleElement bizRule) {
        CRBizRuleAction bizRuleAction = (CRBizRuleAction)TypesContainer.createInstance((String)bizRule.getRunActionClass());
        CRBizRuleContext bizRuleContext = new CRBizRuleContext(this.tgtMainType, this.getRuleContext().getRule(), bizRule);
        FunctionManage funcLib = FunctionManage.get();
        bizRuleContext.setFuncLib(funcLib);
        bizRuleAction.setContext(bizRuleContext);
        return bizRuleAction;
    }
}

