/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.DependEntityMap;

public class LoadDependEntityRowsAction
extends AbstractConvertAction {
    public LoadDependEntityRowsAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.loadDependEntityRows();
    }

    private void loadDependEntityRows() {
        ArrayList<DependEntityMap> headEntityMap = new ArrayList<DependEntityMap>();
        ArrayList<DependEntityMap> entryEntityMap = new ArrayList<DependEntityMap>();
        ArrayList<DependEntityMap> subEntryEntityMap = new ArrayList<DependEntityMap>();
        for (DependEntityMap entityMap : this.ruleContext.getRuleCompiler().getDependEntityMaps().values()) {
            if (entityMap.getTargetEntity() instanceof SubEntryType) {
                subEntryEntityMap.add(entityMap);
                continue;
            }
            if (entityMap.getTargetEntity() instanceof EntryType) {
                entryEntityMap.add(entityMap);
                continue;
            }
            headEntityMap.add(entityMap);
        }
        for (DependEntityMap entityMap : headEntityMap) {
            this.loadDependEntityRows(entityMap);
        }
        for (DependEntityMap entityMap : entryEntityMap) {
            this.loadDependEntityRows(entityMap);
        }
        for (DependEntityMap entityMap : subEntryEntityMap) {
            this.loadDependEntityRows(entityMap);
        }
    }

    private void loadDependEntityRows(DependEntityMap entityMap) {
        if (entityMap.getTargetAnchorEntityMap().getJoinSourceEntityKeys().contains(entityMap.getJoinSourceEntityKeys())) {
            List<DynamicObject> rows = this.getTargetAnchorSourceRows(entityMap);
            this.setSourceRows(entityMap, rows);
            if (!rows.isEmpty() && entityMap.getSrcFldPropertys().isEmpty()) {
                DynamicObjectType dType = rows.get(0).getDynamicObjectType();
                Set<Map.Entry<String, String>> entrySet = entityMap.getSrcFldAlias().entrySet();
                HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(entrySet.size());
                HashMap<String, String> fldAlias = new HashMap<String, String>(entrySet.size());
                for (Map.Entry<String, String> fldAliasItem : entrySet) {
                    String var = fldAliasItem.getKey();
                    String alias = entityMap.getTargetAnchorEntityMap().getSrcFldAlias().get(var);
                    fldAlias.put(var, alias);
                    DynamicProperty property = dType.getProperty(alias);
                    fldPropertys.put(var, property);
                }
                entityMap.getSrcFldAlias().putAll(fldAlias);
                entityMap.setSrcFldPropertys(fldPropertys);
            }
        } else {
            QFilter[] qFilters = this.compileQFilter(entityMap);
            if (qFilters == null || qFilters.length == 0) {
                return;
            }
            String selectSQLString = entityMap.getSrcSelectString();
            String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
            DynamicObjectCollection rows = null;
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);){
                rows = orm.toPlainDynamicObjectCollection(ds);
            }
            this.setSourceRows(entityMap, (List<DynamicObject>)rows);
            if (entityMap.getSrcFldPropertys().isEmpty()) {
                DynamicObjectType dType = rows.getDynamicObjectType();
                Map<String, DynamicProperty> fldPropertys = this.buildSourceRowPropsDictory(dType, entityMap.getSrcFldAlias());
                entityMap.setSrcFldPropertys(fldPropertys);
            }
        }
    }

    private Map<String, DynamicProperty> buildSourceRowPropsDictory(DynamicObjectType dType, Map<String, String> fldAlias) {
        HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(fldAlias.size());
        for (Map.Entry<String, String> fldAliasItem : fldAlias.entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            fldPropertys.put(var, property);
        }
        return fldPropertys;
    }

    protected QFilter[] compileQFilter(DependEntityMap entityMap) {
        entityMap.compileQFilter();
        return entityMap.getQFilters().toArray(new QFilter[entityMap.getQFilters().size()]);
    }

    protected List<DynamicObject> getTargetAnchorSourceRows(DependEntityMap entityMap) {
        return entityMap.getTargetAnchorEntityMap().getSourceRows();
    }

    protected void setSourceRows(DependEntityMap entityMap, List<DynamicObject> sourceRows) {
        entityMap.getSourceRows().clear();
        entityMap.getSourceRows().addAll(sourceRows);
    }
}

