/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.AbstractEntityMap;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.report.PushReport;

public class LoadSourceDataBatchAction
extends AbstractConvertAction {
    private static final Log log = LogFactory.getLog(LoadSourceDataBatchAction.class);

    public LoadSourceDataBatchAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        LinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        QFilter[] qFilters = new QFilter[]{linkEntityMap.comileQFilter(this.ruleContext, this.getSourceRowsGroupRoot())};
        String selectSQLString = linkEntityMap.getSrcSelectString();
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        DynamicObjectCollection rows = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        DynamicObjectType dType = rows.getDynamicObjectType();
        if (linkEntityMap.getSrcFldPropertys().isEmpty()) {
            Map<String, DynamicProperty> fldPropertys = this.buildSourceRowPropsDictory(dType, linkEntityMap.getSrcFldAlias());
            linkEntityMap.setSrcFldPropertys(fldPropertys);
        }
        HashMap<SourceRowId, DynamicObject> sourceRowIds = new HashMap<SourceRowId, DynamicObject>();
        for (DynamicObject sourceRow : rows) {
            SourceRowId sourceRowId = SourceRowId.create((AbstractEntityMap)linkEntityMap, sourceRow);
            sourceRowIds.put(sourceRowId, sourceRow);
            PushReport.setReportManager(this.context, this.resultManager, this.ruleContext, sourceRow);
        }
        this.getSourceRowsGroupRoot().fillSourceRow(sourceRowIds);
        this.ruleContext.getMulbasedataParaManager().collectMulbasedataNumberForLoadSource(linkEntityMap, linkEntityMap.getSrcFldPropertys(), rows);
    }

    private Map<String, DynamicProperty> buildSourceRowPropsDictory(DynamicObjectType dType, Map<String, String> fldAlias) {
        HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(fldAlias.size());
        for (Map.Entry<String, String> fldAliasItem : fldAlias.entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            fldPropertys.put(var, property);
        }
        return fldPropertys;
    }
}

