/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.BusinessFlowDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PushAgainCheckAction
extends AbstractConvertAction {
    public PushAgainCheckAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (!this.getRuleContext().getRule().getOptionPolicy().isPushOneTime()) {
            return;
        }
        Set<Long> srcBillIds = this.getSrcBillIds();
        Set<Long> noPushBillIds = this.findNoPushBills(srcBillIds);
        this.filterSelectedRows(noPushBillIds);
        if (this.ruleContext.getSelectedRows().isEmpty()) {
            this.setSkipNextAction(true);
        }
    }

    private Set<Long> getSrcBillIds() {
        HashSet<Long> srcBillIds = new HashSet<Long>(this.getRuleContext().getSelectedRows().size());
        for (ListSelectedRow selectedRow : this.getRuleContext().getSelectedRows()) {
            Long srcBillId = (Long)selectedRow.getPrimaryKeyValue();
            srcBillIds.add(srcBillId);
        }
        return srcBillIds;
    }

    private Set<Long> findNoPushBills(Set<Long> srcBillIds) {
        BusinessFlowDataService bfDataService = new BusinessFlowDataService();
        Map nodes = bfDataService.loadBillLinkDownNodes(this.getContext().getSourceMainType().getName(), srcBillIds.toArray(new Long[0]), true);
        if (nodes == null || nodes.isEmpty()) {
            return new HashSet<Long>(srcBillIds);
        }
        String targetEntityNumber = this.getContext().getTargetMainType().getName();
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntityNumber);
        HashSet<Long> targetBillIds = new HashSet<Long>(nodes.size());
        for (Map.Entry entry : nodes.entrySet()) {
            List targetNodes = ((BFRowLinkDownNode)entry.getValue()).findTargetNodes(tableDefine.getTableId(), (Long)entry.getKey());
            for (BFRowLinkDownNode targetNode : targetNodes) {
                targetBillIds.add(targetNode.getRowId().getBillId());
            }
        }
        if (targetBillIds.isEmpty()) {
            return new HashSet<Long>(srcBillIds);
        }
        HashSet<String> fields = new HashSet<String>(1);
        fields.add("id");
        MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)targetEntityNumber, fields);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])targetBillIds.toArray(), (DynamicObjectType)subType);
        if (objs == null || objs.length == 0) {
            return new HashSet<Long>(srcBillIds);
        }
        targetBillIds.clear();
        for (DynamicObject obj : objs) {
            targetBillIds.add((Long)obj.getPkValue());
        }
        String failMessage = String.format(ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u3010%s\u3011\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u63a8", (String)"PushAgainCheckAction_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.getContext().getTargetMainType().getDisplayName().toString());
        HashSet<Long> noPushBillIds = new HashSet<Long>(srcBillIds.size());
        for (Long srcBillId : srcBillIds) {
            BFRowLinkDownNode node = (BFRowLinkDownNode)nodes.get(srcBillId);
            if (node == null) {
                noPushBillIds.add(srcBillId);
                continue;
            }
            List targetNodes = node.findTargetNodes(tableDefine.getTableId(), srcBillId);
            if (targetNodes.isEmpty()) {
                noPushBillIds.add(srcBillId);
                continue;
            }
            boolean exist = false;
            for (BFRowLinkDownNode targetNode : targetNodes) {
                if (!targetBillIds.contains(targetNode.getRowId().getBillId())) continue;
                exist = true;
                break;
            }
            if (exist) {
                this.getResultManager().getReporter().failBill(srcBillId, failMessage);
                continue;
            }
            noPushBillIds.add(srcBillId);
        }
        return noPushBillIds;
    }

    private void filterSelectedRows(Set<Long> noPushBillIds) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows());
        this.ruleContext.getSelectedRows().clear();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billId = selectedRow.getPrimaryKeyValue();
            if (!noPushBillIds.contains(billId)) continue;
            this.ruleContext.getSelectedRows().add(selectedRow);
        }
    }
}

