/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.report.IBuildDetailReport;

public class RunDataConditionAction
extends AbstractConvertAction {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private Boolean outFormula = null;

    private boolean isOutFormula() {
        if (this.outFormula == null) {
            String paramValue = (String)this.getContext().getInputArgs().getCustomParams().get("botp_outformula");
            this.outFormula = paramValue == null ? Boolean.FALSE : Boolean.valueOf(paramValue);
        }
        return this.outFormula;
    }

    public RunDataConditionAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        ConvertReportManager reportManager = this.resultManager.getReporter();
        LinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        Map<String, DynamicProperty> fldProperties = linkEntityMap.getSrcFldPropertys();
        EntityType linkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(linkEntityMap.getSourceLinkEntityKey());
        IBuildDetailReport reportBuilder = this.ruleContext.getSrcRowReportBuilder(linkEntity);
        if (linkEntityMap.getSourceRows().isEmpty()) {
            this.setSkipNextAction(true);
            String failMessage = null;
            failMessage = linkEntity instanceof EntryType && ((EntryType)linkEntity).isMustIuput() ? String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e\uff0c\u53ef\u80fd\u662f%s\u6ca1\u6709\u8bb0\u5f55", (String)"RunDataConditionAction_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), linkEntity.getDisplayName().toString()) : ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165\u7684\u6e90\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u5230\u6e90\u5355\u6570\u636e", (String)"RunDataConditionAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), failMessage);
            return;
        }
        ArrayList<DynamicObject> sourceRows = new ArrayList<DynamicObject>(16);
        if (!this.ruleContext.getRule().getFilterPolicy().getAdvCondition().booleanValue()) {
            CRConditionCompiler rowCondCompiler = this.ruleContext.getRuleCompiler().getDataFilterCompiler();
            ArrayList<CRConditionCompiler> rowCondCompilers = new ArrayList<CRConditionCompiler>(1);
            rowCondCompilers.add(rowCondCompiler);
            this.runCondition(sourceRows, fldProperties, rowCondCompilers, linkEntityMap, reportManager, reportBuilder);
        } else {
            List<CRConditionCompiler> crConditionCompilers = this.ruleContext.getRuleCompiler().getDataFilterCompilers();
            this.runCondition(sourceRows, fldProperties, crConditionCompilers, linkEntityMap, reportManager, reportBuilder);
        }
        AfterGetSourceDataEventArgs eventArgs = new AfterGetSourceDataEventArgs(sourceRows, fldProperties);
        this.ruleContext.getPlugInProxy().fireAfterGetSourceData(eventArgs);
        if (sourceRows.isEmpty()) {
            this.setSkipNextAction(true);
            String failMessage = null;
            failMessage = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u7b5b\u9009\u6761\u4ef6", (String)"RunDataConditionAction_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), failMessage);
        }
        linkEntityMap.getSourceRows().clear();
        linkEntityMap.getSourceRows().addAll(eventArgs.getSourceRows());
    }

    private void runCondition(List<DynamicObject> sourceRows, Map<String, DynamicProperty> fldProperties, List<CRConditionCompiler> rowCondCompilers, LinkEntityMap linkEntityMap, ConvertReportManager reportManager, IBuildDetailReport reportBuilder) {
        for (DynamicObject sourceRow : linkEntityMap.getSourceRows()) {
            reportBuilder.addLinkRow(reportManager, fldProperties, sourceRow);
            boolean flag = false;
            for (CRConditionCompiler rowCondCompiler : rowCondCompilers) {
                this.ruleContext.getBasedataVersionManager().setGetValueFuncToValueModel(fldProperties, rowCondCompiler.getExpressionExecuter());
                this.ruleContext.getBasedataVersionManager().setGetValueFuncToValueModel(fldProperties, rowCondCompiler.getGridFilterExecuter());
                this.ruleContext.getBasedataVersionManager().setGetValueFuncToValueModel(fldProperties, rowCondCompiler.getCustExpressionExecuter());
                if (rowCondCompiler.executeCondition(fldProperties, sourceRow)) {
                    flag = true;
                    continue;
                }
                String failMessage = rowCondCompiler.buildFailMessage(fldProperties, sourceRow, this.isOutFormula());
                reportBuilder.addErrorReport(reportManager, fldProperties, sourceRow, failMessage);
                flag = false;
                break;
            }
            if (!flag) continue;
            sourceRows.add(sourceRow);
        }
    }
}

