/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.baseversion.BasedataVersionManager;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;

public class RunRuleConditionAction
extends AbstractConvertAction {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";

    public RunRuleConditionAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        Set<Object> srcBillIds = this.getSrcBillIds();
        if (srcBillIds.isEmpty()) {
            this.resultManager.setSkipNextRule(true);
            this.setSkipNextAction(true);
            return;
        }
        Set<Object> myBillIds = this.runCondition(srcBillIds);
        this.filterSelectedRows(myBillIds);
        if (this.ruleContext.getSelectedRows().isEmpty()) {
            this.setSkipNextAction(true);
        }
        this.updateRuleId(myBillIds);
    }

    private Set<Object> getSrcBillIds() {
        return new HashSet<Object>(this.resultManager.getReporter().getNoRuleBillIds());
    }

    private Set<Object> runCondition(Set<Object> srcBillIds) {
        CRConditionCompiler runCondCompiler;
        BasedataVersionManager basedataVersionManagerForRunRule;
        block18: {
            basedataVersionManagerForRunRule = new BasedataVersionManager();
            runCondCompiler = null;
            ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
            try {
                runCondCompiler = ruleCompiler.compileRunCondition();
            }
            catch (KDBizException exp) {
                if (!exp.getErrorCode().getCode().equals("bos.fieldNotExist")) break block18;
                KDBizException e = new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53[%1$s]\u8f6c\u6362\u89c4\u5219[%2$s]\u914d\u7f6e\u6709\u8bef\uff1a\u89c4\u5219\u542f\u7528\u6761\u4ef6\u4e2d\u7684\u5b57\u6bb5[%3$s]\uff0c\u5728\u6e90\u5355\u4e0a\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219", (String)"RunRuleConditionAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.ruleContext.getRule().getSourceEntityNumber(), this.ruleContext.getRule().getName(), exp.getArgs().length > 1 ? exp.getArgs()[1].toString().split("\uff0c")[0] : ""));
                throw e;
            }
        }
        if (runCondCompiler == null || runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            return srcBillIds;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        fieldAlias.put(pkFieldName, pkFieldName);
        selectFields.add(pkFieldName);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        this.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
        this.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
        Map<String, SourceFieldVariable> fields = this.buildVarSourceFieldMap(expressExecutor, gridFilterExecutor);
        basedataVersionManagerForRunRule.prepareBasedataPropForVersion(srcMainType, fields, fieldAlias, selectFields);
        String selectString = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        qFilters.add(idFilter);
        QFilter[] arrQFilters = new QFilter[qFilters.size()];
        arrQFilters = qFilters.toArray(arrQFilters);
        ORM orm = ORM.create();
        DynamicObjectCollection rows = null;
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectString, arrQFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = rows.getDynamicObjectType();
        for (Map.Entry entry : fieldAlias.entrySet()) {
            String string = (String)entry.getKey();
            String fldAlias = (String)entry.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(string, property);
        }
        this.ruleContext.getMulbasedataParaManager().collectMulbasedataNumberForRunRule(runCondCompiler, expressExecutor.getVars(), fieldPropertys, rows);
        basedataVersionManagerForRunRule.setGetValueFuncToValueModel(fieldPropertys, expressExecutor);
        basedataVersionManagerForRunRule.setGetValueFuncToValueModel(fieldPropertys, gridFilterExecutor);
        HashMap<String, Object> memIdSet = new HashMap<String, Object>(srcBillIds.size());
        for (Object object : srcBillIds) {
            String idString = String.valueOf(object);
            memIdSet.put(idString, object);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (DynamicObject row : rows) {
            if (!((Boolean)expressExecutor.getValue(fieldPropertys, row)).booleanValue() || !((Boolean)gridFilterExecutor.getValue(fieldPropertys, row)).booleanValue()) continue;
            Object billId = row.get(pkFieldName);
            String idString = String.valueOf(billId);
            Object memBillId = memIdSet.get(idString);
            hashSet.add(memBillId);
        }
        return hashSet;
    }

    private Map<String, SourceFieldVariable> buildVarSourceFieldMap(IGetValueMode expressExecutor, IGetValueMode gridFilterExecutor) {
        HashMap<String, SourceFieldVariable> fields = new HashMap<String, SourceFieldVariable>();
        if (expressExecutor != null) {
            for (IVariableMode var : expressExecutor.getVars()) {
                if (!(var instanceof SourceFieldVariable) || fields.containsKey(var.getVar())) continue;
                fields.put(var.getVar(), (SourceFieldVariable)var);
            }
        }
        if (gridFilterExecutor != null) {
            for (IVariableMode var : gridFilterExecutor.getVars()) {
                if (!(var instanceof SourceFieldVariable) || fields.containsKey(var.getVar())) continue;
                fields.put(var.getVar(), (SourceFieldVariable)var);
            }
        }
        return fields;
    }

    private void filterSelectedRows(Set<Object> myBillIds) {
        List selectedRows = null;
        selectedRows = this.context.getConvertOpType() == ConvertOpType.Push ? ((PushArgs)this.context.getInputArgs()).getSelectedRows() : ((DrawArgs)this.context.getInputArgs()).getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billId = selectedRow.getPrimaryKeyValue();
            if (!myBillIds.contains(billId)) continue;
            this.ruleContext.getSelectedRows().add(selectedRow);
        }
    }

    private void updateRuleId(Set<Object> myBillIds) {
        String ruleId = this.ruleContext.getRule().getId();
        String ruleName = this.ruleContext.getRule().getName().toString();
        ConvertReportManager reportManager = this.resultManager.getReporter();
        for (Object billId : myBillIds) {
            reportManager.updateRuleId(billId, ruleId, ruleName);
        }
    }

    private void addSourceFields(List<IVariableMode> vars, List<String> selectFldStrings, Map<String, String> fieldAlias) {
        int fieldIndex = fieldAlias.size();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable) || fieldAlias.containsKey(var.getVar())) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldAlias = "f" + Integer.toString(fieldIndex);
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            fieldAlias.put(var.getVar(), fldAlias);
            ++fieldIndex;
        }
    }
}

