/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.runtime.AttachmentInfoPackage;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.AttachmentPanelMap;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SaveAction
extends AbstractConvertAction {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";

    public SaveAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        ExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        AfterConvertEventArgs eventArgs = new AfterConvertEventArgs(targetExtDataSet, this.ruleContext.getRuleCompiler().getLinkEntityMap().getSrcFldPropertys());
        this.ruleContext.getPlugInProxy().fireAfterConvert(eventArgs);
        targetExtDataSet = eventArgs.getTargetExtDataEntitySet();
        ExtendedDataEntity[] headExtEntitys = targetExtDataSet.FindByEntityKey(this.context.getInputArgs().getTargetEntityNumber());
        HashSet<Object> savingBillList = new HashSet<Object>(headExtEntitys.length);
        ArrayList<DynamicObject> targetBillObjs = new ArrayList<DynamicObject>(headExtEntitys.length);
        for (int i = 0; i < headExtEntitys.length; ++i) {
            DynamicObject obj = headExtEntitys[i].getDataEntity();
            Object billId = obj.getPkValue();
            if (this.ruleResultManager.isFail(billId)) {
                this.batchResultManager.addFailId(billId, ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5176\u4ed6\u5206\u6279\u8f6c\u6362\u5931\u8d25\uff0c\u672c\u6279\u8df3\u8fc7", (String)"SaveAction_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                continue;
            }
            targetBillObjs.add(obj);
            savingBillList.add(billId);
        }
        if (!targetBillObjs.isEmpty()) {
            this.doSave(targetBillObjs.toArray(new DynamicObject[0]), savingBillList, headExtEntitys);
        }
        targetBillObjs = null;
        headExtEntitys = null;
        this.setTargetExtendedDataEntities(null);
        this.batchContext.getSourceRowsGroupRoot().clearSourceRow();
    }

    private void doSave(DynamicObject[] objs, Set<Object> savingBillList, ExtendedDataEntity[] extendedDataEntities) {
        String strTure = String.valueOf(true);
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", strTure);
        saveOption.setVariableValue("ignoreinteraction", strTure);
        saveOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
        saveOption.setVariableValue("bos_save_appendentryrows", strTure);
        saveOption.setVariableValue("ishasright", strTure);
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)this.getContext().getTargetMainType().getName(), (DynamicObject[])objs, (OperateOption)saveOption);
        List<Object> successPkIds = new ArrayList<Object>(0);
        if (saveResult != null && saveResult.getSuccessPkIds() != null && !saveResult.getSuccessPkIds().isEmpty()) {
            successPkIds = saveResult.getSuccessPkIds();
        }
        this.batchResultManager.addSuccessIds(successPkIds);
        this.resultManager.getLogger().updateConvertTargetInfo(this.context, extendedDataEntities);
        this.persistAttachmentPanelInfos(successPkIds, extendedDataEntities);
        this.outFailMessage(savingBillList, saveResult);
        this.outSuccessObjs(saveResult);
    }

    private void persistAttachmentPanelInfos(List<Object> successPkIds, ExtendedDataEntity[] extendedDataEntities) {
        Map<String, AttachmentPanelMap> attachmentPanelMapRules = this.ruleContext.getRuleCompiler().getAttachmentPanelMaps();
        if (attachmentPanelMapRules == null || attachmentPanelMapRules.isEmpty()) {
            return;
        }
        Set<String> firstRowMappingAttachmentPanelKeys = this.getFirstRowMappingAttachmentPanelKeys(attachmentPanelMapRules);
        Map<Object, List<Object>> savingTargetBillSourceIds = this.resultManager.getSavingTargetBillSourceIds();
        for (ExtendedDataEntity extDataEntity : extendedDataEntities) {
            List<Object> targetBillSourceIds;
            Object targetPk = extDataEntity.getBillPkId();
            ArrayList sourcePks = (ArrayList)extDataEntity.getValue("botp_attachment_mapping_source_row_ids");
            if (sourcePks == null) {
                sourcePks = new ArrayList();
            }
            if ((targetBillSourceIds = savingTargetBillSourceIds.get(targetPk)) == null) {
                savingTargetBillSourceIds.put(targetPk, sourcePks);
            } else {
                targetBillSourceIds.addAll(sourcePks);
            }
            Map attachInfoMap = (Map)extDataEntity.getValue("botp_source_attachmentpanel_infos");
            if (attachInfoMap == null) {
                return;
            }
            if (!firstRowMappingAttachmentPanelKeys.isEmpty()) {
                this.removeSavedFirstSourceBillAttachmentsByLastBatch(this.ruleContext.getContext().getTargetMainType().getName(), targetPk, firstRowMappingAttachmentPanelKeys);
            }
            this.persistAttachments(targetPk, attachInfoMap);
            this.resultManager.getBillAttachmentPanelInfos().remove(targetPk);
        }
    }

    private Set<String> getFirstRowMappingAttachmentPanelKeys(Map<String, AttachmentPanelMap> attachmentPanelMapRules) {
        HashSet<String> firstRowMappingAttachmentPanelKeys = new HashSet<String>();
        for (Map.Entry<String, AttachmentPanelMap> entry : attachmentPanelMapRules.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isMergeAttachments()) continue;
            firstRowMappingAttachmentPanelKeys.add(entry.getKey());
        }
        return firstRowMappingAttachmentPanelKeys;
    }

    private void removeSavedFirstSourceBillAttachmentsByLastBatch(String targetFormId, Object targetPk, Set<String> firstRowMappingAttachmentPanelKeys) {
        ORM orm = ORM.create();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("FInterID", "=", (Object)String.valueOf(targetPk)));
        filters.add(new QFilter("FBillType", "=", (Object)targetFormId));
        filters.add(new QFilter("fattachmentpanel", "in", firstRowMappingAttachmentPanelKeys));
        orm.delete("bos_attachment", filters.toArray(new QFilter[0]));
    }

    private void persistAttachments(Object targetPk, Map<String, List<AttachmentItemInfo>> billAttachItemInfos) {
        BillEntityType targetEntityType = this.ruleContext.getContext().getTargetMainType();
        AttachmentInfoPackage pkg = new AttachmentInfoPackage();
        pkg.setAppId(targetEntityType.getAppId());
        pkg.setFormId(targetEntityType.getName());
        pkg.setPkId(targetPk);
        pkg.setAttachmentInfo(billAttachItemInfos);
        pkg.persist();
    }

    private void outFailMessage(Set<Object> pkIds, OperationResult saveResult) {
        ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>(0);
        HashMap<Object, List<IOperateInfo>> billErrors = new HashMap<Object, List<IOperateInfo>>(0);
        this.splitErrorInfoByBill(pkIds, saveResult, opFailInfos, billErrors);
        StringBuilder failMessage = new StringBuilder();
        for (IOperateInfo info : opFailInfos) {
            failMessage.append(info.getMessage()).append("  \r\n");
        }
        for (Object id : pkIds) {
            if (this.batchResultManager.getSuccessIds().contains(id)) continue;
            if (!billErrors.containsKey(id)) {
                this.batchResultManager.addFailId(id, failMessage.toString());
                continue;
            }
            StringBuilder errBuilder = new StringBuilder();
            errBuilder.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u6821\u9a8c\u5931\u8d25\uff1a", (String)"SaveAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0])).append("\r\n");
            int i = 0;
            for (IOperateInfo info : (List)billErrors.get(id)) {
                if (i >= 3) {
                    errBuilder.append(info.getMessage()).append("  ...");
                    break;
                }
                errBuilder.append(info.getMessage()).append("  \r\n");
                ++i;
            }
            this.batchResultManager.addFailId(id, errBuilder.toString());
        }
        if (!this.batchResultManager.getFailIds().isEmpty()) {
            this.ruleResultManager.addFailBillIds(this.batchResultManager.getFailIds().keySet().toArray());
        }
    }

    private void outSuccessObjs(OperationResult saveResult) {
        if (saveResult == null || saveResult.getSuccessPkIds() == null || saveResult.getSuccessPkIds().isEmpty()) {
            return;
        }
        Map<Object, DynamicObject> idToObjs = this.loadHead(saveResult.getSuccessPkIds().toArray());
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (SourceRowsGroup billGroup : this.getSourceRowsGroupRoot().getChildGroupList()) {
            if (billGroup.getStartEntrySeq() != 1 || !billGroup.isExistNextBatch() || !this.batchResultManager.getSuccessIds().contains(billGroup.getTargetBillId())) continue;
            successObjs.add(idToObjs.get(billGroup.getTargetBillId()));
        }
        if (!successObjs.isEmpty()) {
            this.ruleResultManager.putTargetBillHeads(successObjs.toArray(new DynamicObject[0]));
        }
    }

    private Map<Object, DynamicObject> loadHead(Object[] pkIds) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getContext().getTargetMainType());
        dataManager.setSelectHeadOnly(true);
        Object[] objs = dataManager.read(pkIds);
        if (objs == null || objs.length == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager((IDataEntityType)this.getContext().getTargetMainType(), false);
        manager.Load(objs);
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(objs.length);
        for (Object obj : objs) {
            DynamicObject o = (DynamicObject)obj;
            map.put(o.getPkValue(), o);
        }
        return map;
    }

    private void splitErrorInfoByBill(Set<Object> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<Object, List<IOperateInfo>> billErrors) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!pkIds.contains(pkValue)) {
                opFailInfos.add(info);
                continue;
            }
            if (!billErrors.containsKey(pkValue)) {
                billErrors.put(pkValue, new ArrayList());
            }
            billErrors.get(pkValue).add(info);
        }
        if (opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SaveAction_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }
}

