/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleBatchContext;
import kd.bos.service.botp.convert.SingleBatchResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.AttachmentPanelPushForSaveAction;
import kd.bos.service.botp.convert.actions.BuildPushLayoutAction;
import kd.bos.service.botp.convert.actions.CreateDependEntityRowsAction;
import kd.bos.service.botp.convert.actions.CreateLinkEntityRowsAction;
import kd.bos.service.botp.convert.actions.CreateOrgCheckAction;
import kd.bos.service.botp.convert.actions.CreateTargetBillBatchAction;
import kd.bos.service.botp.convert.actions.ExecuteBizRuleAction;
import kd.bos.service.botp.convert.actions.FillLinkInfoAction;
import kd.bos.service.botp.convert.actions.LoadDependEntityRowsBatchAction;
import kd.bos.service.botp.convert.actions.LoadSourceDataBatchAction;
import kd.bos.service.botp.convert.actions.MappingDependFieldAction;
import kd.bos.service.botp.convert.actions.MappingFieldAction;
import kd.bos.service.botp.convert.actions.SaveAction;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.business.datamodel.DrawDataModel;

public class SingleBatchExecute
implements Callable<SingleBatchResultManager> {
    private RequestContext rc;
    private boolean syncExecute = false;
    private static Log log = LogFactory.getLog(SingleBatchExecute.class);
    private ConvertContext context;
    private SingleRuleContext ruleContext;
    private ConvertResultManager resultManager;
    private SingleRuleResultManager ruleResultManager;
    private SourceRowsGroup currGroupRoot;
    private List<AbstractConvertAction> actions = new ArrayList<AbstractConvertAction>(0);

    public boolean isSyncExecute() {
        return this.syncExecute;
    }

    public void setSyncExecute(boolean syncExecute) {
        this.syncExecute = syncExecute;
    }

    public SingleBatchExecute(RequestContext rc, ConvertContext context, SingleRuleContext ruleContext, ConvertResultManager resultManager, SingleRuleResultManager ruleResultManager, SourceRowsGroup currGroupRoot) {
        this.rc = rc;
        this.context = context;
        this.ruleContext = ruleContext;
        this.resultManager = resultManager;
        this.ruleResultManager = ruleResultManager;
        this.currGroupRoot = currGroupRoot;
    }

    @Override
    public SingleBatchResultManager call() throws Exception {
        if (!this.isSyncExecute()) {
            RequestContext.copyAndSet((RequestContext)this.rc);
        }
        this.actions = this.createActions();
        SingleBatchContext batchContext = new SingleBatchContext();
        batchContext.setRuleContext(this.ruleContext);
        batchContext.setSourceRowsGroupRoot(this.currGroupRoot);
        batchContext.setModelProxy(this.createDataModel());
        SingleBatchResultManager batchResultManager = new SingleBatchResultManager();
        batchResultManager.setSourceRowsGroupRoot(this.currGroupRoot);
        try {
            for (AbstractConvertAction action : this.actions) {
                action.setRuleContext(this.ruleContext);
                action.setRuleResultManager(this.ruleResultManager);
                action.setBatchContext(batchContext);
                action.setBatchResultManager(batchResultManager);
                action.action();
            }
        }
        catch (KDBizException ex) {
            batchResultManager.setException(ex);
        }
        catch (Throwable ex) {
            batchResultManager.setException(ex);
            log.error(ex);
        }
        batchContext.clearMemory();
        batchContext = null;
        return batchResultManager;
    }

    private List<AbstractConvertAction> createActions() {
        ArrayList<AbstractConvertAction> list = new ArrayList<AbstractConvertAction>();
        list.add(new LoadSourceDataBatchAction(this.context, this.resultManager));
        list.add(new LoadDependEntityRowsBatchAction(this.context, this.resultManager));
        list.add(new CreateTargetBillBatchAction(this.context, this.resultManager));
        list.add(new CreateLinkEntityRowsAction(this.context, this.resultManager));
        list.add(new CreateDependEntityRowsAction(this.context, this.resultManager));
        list.add(new MappingDependFieldAction(this.context, this.resultManager));
        list.add(new MappingFieldAction(this.context, this.resultManager));
        list.add(new CreateOrgCheckAction(this.context, this.resultManager));
        list.add(new FillLinkInfoAction(this.context, this.resultManager));
        list.add(new ExecuteBizRuleAction(this.context, this.resultManager));
        list.add(new BuildPushLayoutAction(this.context, this.resultManager));
        list.add(new AttachmentPanelPushForSaveAction(this.context, this.resultManager));
        list.add(new SaveAction(this.context, this.resultManager));
        return list;
    }

    private DrawDataModel createDataModel() {
        HashMap services = new HashMap();
        String targetEntityNumber = this.context.getInputArgs().getTargetEntityNumber();
        String pageId = UUID.randomUUID().toString();
        return new DrawDataModel(targetEntityNumber, pageId, services);
    }

    public SourceRowsGroup getCurrGroupRoot() {
        return this.currGroupRoot;
    }
}

