/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.baseversion;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.nameversion.NameVersionEntry;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.BasedataProp;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.getvaluemode.basedataver.GetConditionValueBasedataVer;
import kd.bos.service.botp.convert.getvaluemode.basedataver.GetFormulaValueBasedataVer;
import kd.bos.service.botp.convert.getvaluemode.basedataver.GetSourceFieldValueBasedataVer;
import kd.bos.service.botp.convert.getvaluemode.basedataver.GetValueByConditionBasedataVer;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.mapping.MappingBasedataVersionField;
import kd.bos.service.botp.convert.mapping.MappingField;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import org.apache.commons.collections4.CollectionUtils;

public class BasedataVersionManager {
    private static final String BOTP_ENABLE_BASEDATAVERSION = "botp.enable.basedataversion";
    private Map<String, String> basedataPropVarMap = new HashMap<String, String>();
    private String versionControlVar = null;

    public void prepareBasedataPropForVersion(BillEntityType billEntityType, Map<String, SourceFieldVariable> srcFields, Map<String, String> srcFldAlias, List<String> selectFldStrings) {
        if (!Boolean.getBoolean(BOTP_ENABLE_BASEDATAVERSION)) {
            return;
        }
        int lastFldIndex = srcFldAlias.size();
        for (SourceFieldVariable srcField : srcFields.values()) {
            if (!BasedataVersionManager.validateFieldPropForVersion(srcField) || srcField.getKeyItems().length <= 1) continue;
            String var = srcField.getSourceField().getName();
            this.basedataPropVarMap.put(srcField.getFullPropName(), var);
            if (srcFldAlias.containsKey(var)) continue;
            String fldAlias = "f" + lastFldIndex++;
            String selectFldString = var + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            srcFldAlias.put(var, fldAlias);
        }
        this.prepareVersionControlField(billEntityType, srcFldAlias, selectFldStrings, lastFldIndex);
    }

    private void prepareVersionControlField(BillEntityType billEntityType, Map<String, String> srcFldAlias, List<String> selectFldStrings, int lastFldIndex) {
        if (!this.basedataPropVarMap.isEmpty()) {
            String versionControl = billEntityType.getVersionControl();
            if (StringUtils.isBlank((CharSequence)versionControl)) {
                return;
            }
            DynamicProperty versionControlProp = billEntityType.getProperty(versionControl);
            if (versionControlProp == null) {
                return;
            }
            this.versionControlVar = versionControlProp.getName();
            String fldAlias = "f" + lastFldIndex++;
            String selectFldString = this.versionControlVar + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            srcFldAlias.put(this.versionControlVar, fldAlias);
        }
    }

    private static boolean validateFieldPropForVersion(SourceFieldVariable srcField) {
        return srcField.getSourceField() instanceof BasedataProp;
    }

    public IMappingField mappingFieldRecreate(SingleRuleContext ruleContext, FieldMapItem fieldMapItem, DynamicProperty fieldProp, IMappingField mappingField) {
        if (!Boolean.getBoolean(BOTP_ENABLE_BASEDATAVERSION)) {
            return mappingField;
        }
        if (mappingField.getClass() != MappingField.class) {
            return mappingField;
        }
        if (!(this.validateFieldConvertTypeSourceField(fieldMapItem, mappingField) || this.validateFieldConvertTypeFormula(fieldMapItem, mappingField) || this.validateFieldConvertTypeByCondition(fieldMapItem, mappingField))) {
            return mappingField;
        }
        mappingField = new MappingBasedataVersionField();
        mappingField.initialize(ruleContext, fieldMapItem, fieldProp);
        mappingField.compile(ruleContext);
        return mappingField;
    }

    private boolean validateFieldConvertTypeSourceField(FieldMapItem fieldMapItem, IMappingField mappingField) {
        return fieldMapItem.getFieldConvertType() == FieldConvertType.SourceField && CollectionUtils.isNotEmpty(mappingField.getVars()) && mappingField.getVars().get(0) instanceof SourceFieldVariable && BasedataVersionManager.validateFieldPropForVersion((SourceFieldVariable)mappingField.getVars().get(0));
    }

    private boolean validateFieldConvertTypeFormula(FieldMapItem fieldMapItem, IMappingField mappingField) {
        if (fieldMapItem.getFieldConvertType() == FieldConvertType.Formula && CollectionUtils.isNotEmpty(mappingField.getVars())) {
            for (IVariableMode var : mappingField.getVars()) {
                if (!(var instanceof SourceFieldVariable) || !BasedataVersionManager.validateFieldPropForVersion((SourceFieldVariable)var)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateFieldConvertTypeByCondition(FieldMapItem fieldMapItem, IMappingField mappingField) {
        if (fieldMapItem.getFieldConvertType() == FieldConvertType.ByCondition && CollectionUtils.isNotEmpty(mappingField.getVars())) {
            for (IVariableMode var : mappingField.getVars()) {
                if (!(var instanceof SourceFieldVariable) || !BasedataVersionManager.validateFieldPropForVersion((SourceFieldVariable)var)) continue;
                return true;
            }
        }
        return false;
    }

    public void setGetValueFuncToValueModel(Map<String, DynamicProperty> fldProperties, IGetValueMode valueMode) {
        if (!Boolean.getBoolean(BOTP_ENABLE_BASEDATAVERSION)) {
            return;
        }
        this.setGetValueFuncForSourceField(fldProperties, valueMode);
        this.setGetValueFuncForFormula(fldProperties, valueMode);
        this.setGetValueFuncForCondition(fldProperties, valueMode);
        this.setGetValueFuncForByCondition(fldProperties, valueMode);
    }

    private void setGetValueFuncForSourceField(Map<String, DynamicProperty> fldProperties, IGetValueMode valueMode) {
        if (valueMode instanceof GetSourceFieldValueBasedataVer) {
            ((GetSourceFieldValueBasedataVer)valueMode).setGetValueFunctionForBasedataVersion(var -> activeObj -> this.doGetValueFunctionForBasedataVersion(fldProperties, this.getBasedataPropVarMap(), (IVariableMode)var, (DynamicObject)activeObj));
        }
    }

    private void setGetValueFuncForFormula(Map<String, DynamicProperty> fldProperties, IGetValueMode valueMode) {
        if (valueMode instanceof GetFormulaValueBasedataVer) {
            ((GetFormulaValueBasedataVer)valueMode).setGetValueFunctionForBasedataVersion(var -> activeObj -> this.doGetValueFunctionForBasedataVersion(fldProperties, this.getBasedataPropVarMap(), (IVariableMode)var, (DynamicObject)activeObj));
        }
    }

    private void setGetValueFuncForCondition(Map<String, DynamicProperty> fldProperties, IGetValueMode valueMode) {
        if (valueMode instanceof GetConditionValueBasedataVer) {
            ((GetConditionValueBasedataVer)valueMode).setGetValueFunctionForBasedataVersion(var -> activeObj -> this.doGetValueFunctionForBasedataVersion(fldProperties, this.getBasedataPropVarMap(), (IVariableMode)var, (DynamicObject)activeObj));
        }
    }

    private void setGetValueFuncForByCondition(Map<String, DynamicProperty> fldProperties, IGetValueMode valueMode) {
        if (valueMode instanceof GetValueByConditionBasedataVer) {
            for (Tuple<IGetValueMode, IGetValueMode> valueHandler : ((GetValueByConditionBasedataVer)valueMode).getValueHandlers()) {
                this.setGetValueFuncForCondition(fldProperties, (IGetValueMode)valueHandler.item1);
                this.setGetValueFuncForFormula(fldProperties, (IGetValueMode)valueHandler.item2);
            }
        }
    }

    private Optional<Object> doGetValueFunctionForBasedataVersion(Map<String, DynamicProperty> fldProperties, Map<String, String> basedataPropVarMap, IVariableMode var, DynamicObject activeObj) {
        NameVersionEntry nameByDate;
        DynamicProperty tmpVersionControlProp;
        if (!(var instanceof SourceFieldVariable)) {
            return Optional.empty();
        }
        IDataEntityProperty sourceField = ((SourceFieldVariable)var).getSourceField();
        if (!(sourceField instanceof BasedataProp)) {
            return Optional.empty();
        }
        String basedataPropVar = basedataPropVarMap.get(var.getVar());
        if (StringUtils.isBlank((CharSequence)basedataPropVar)) {
            return Optional.empty();
        }
        DynamicProperty tmpBasedataProp = fldProperties.get(basedataPropVar);
        if (tmpBasedataProp == null) {
            return Optional.empty();
        }
        Object basedataPkId = tmpBasedataProp.getValue((Object)activeObj);
        boolean enableNameVersionControl = NameVersionService.getInstance().enableNameVersionControl(((BasedataProp)sourceField).getBaseEntityId());
        if (!enableNameVersionControl) {
            return Optional.empty();
        }
        Object versionDate = null;
        String versionControlVar = this.getVersionControlVar();
        if (StringUtils.isNotBlank((CharSequence)versionControlVar) && !((versionDate = (tmpVersionControlProp = fldProperties.get(versionControlVar)).getValue((Object)activeObj)) instanceof Date)) {
            versionDate = null;
        }
        return (nameByDate = NameVersionService.getInstance().getNameByDate(((BasedataProp)sourceField).getBaseEntityId(), basedataPkId, (Date)versionDate)) == null ? Optional.empty() : Optional.of(nameByDate.getName().getLocaleValue());
    }

    public Map<String, String> getBasedataPropVarMap() {
        return this.basedataPropVarMap;
    }

    public String getVersionControlVar() {
        return this.versionControlVar;
    }
}

