/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.batchrequest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.service.botp.convert.batchrequest.DecimalFieldSetValueRequest;
import kd.bos.service.botp.convert.getscale.IGetScale;

public class BatchDecimalFieldSetValue {
    private BillEntityType mainType;
    private List<DecimalFieldSetValueRequest> requests = new ArrayList<DecimalFieldSetValueRequest>();

    public BatchDecimalFieldSetValue(BillEntityType mainType) {
        this.mainType = mainType;
    }

    public BillEntityType getMainType() {
        return this.mainType;
    }

    public List<DecimalFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public void batchDo() {
        HashMap fields = new HashMap();
        for (DecimalFieldSetValueRequest decimalFieldSetValueRequest : this.requests) {
            DecimalProp field = decimalFieldSetValueRequest.getTargetFieldProp();
            if (!fields.containsKey(field)) {
                fields.put(field, new ArrayList());
            }
            ((List)fields.get(field)).add(decimalFieldSetValueRequest);
        }
        for (Map.Entry entry : fields.entrySet()) {
            this.setOneFieldScale((DecimalProp)entry.getKey(), (List)entry.getValue());
        }
    }

    private void setOneFieldScale(DecimalProp prop, List<DecimalFieldSetValueRequest> requests) {
        IGetScale getScaleHandler = IGetScale.create(this.mainType, prop);
        for (DecimalFieldSetValueRequest request : requests) {
            BigDecimal fldValue = request.getOldValue();
            int scale = getScaleHandler.getScale(request.getActiveRow());
            fldValue = fldValue.setScale(scale, prop.getRoundingMode());
            request.setNewValue(fldValue);
            request.setValue();
        }
    }
}

