/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.bizrule;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.UnitConvertDTO;
import kd.bos.entity.botp.runtime.CRBizRuleAction;
import kd.bos.entity.botp.runtime.CRBizRuleContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.IUserService;
import kd.bos.service.botp.convert.bizrule.UnitConvertDTOCompiler;
import kd.bos.service.botp.track.getvaluemode.FieldVariable;
import kd.bos.service.botp.track.getvaluemode.GetConstValue;
import kd.bos.service.botp.track.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.track.getvaluemode.IGetValueMode;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.user.UserService;

public class FillQtyAction
extends CRBizRuleAction {
    private static final Log log = LogFactory.getLog(FillQtyAction.class);
    private String entityKey;
    private List<UnitConvertDTO> unitConvertExpressions;
    private List<UnitConvertDTOCompiler> unitConvertDTOCompilers;
    private IGetValueMode preConditionExecuter;
    private boolean breakNoConvert = false;
    private String bizRuleInfo = null;
    private static final String KEY_NUMBER = "number";

    public boolean isBreakNoConvert() {
        return this.breakNoConvert;
    }

    public void setContext(CRBizRuleContext bizRuleContext) {
        super.setContext(bizRuleContext);
        String parameterJson = this.getBizRule().getParameters();
        Map parameters = (Map)SerializationUtils.fromJsonString((String)parameterJson, Map.class);
        String expressionStr = parameters.get("Expression").toString();
        if (StringUtils.isNotBlank((CharSequence)expressionStr)) {
            this.unitConvertExpressions = JSON.parseArray((String)expressionStr, UnitConvertDTO.class);
        }
        HashSet<EntityType> distEntityTypes = new HashSet<EntityType>(1);
        if (this.unitConvertExpressions != null) {
            this.unitConvertDTOCompilers = new ArrayList<UnitConvertDTOCompiler>(this.unitConvertExpressions.size());
            for (UnitConvertDTO unitConvertDTO : this.unitConvertExpressions) {
                UnitConvertDTOCompiler unitConvertDTOCompiler = new UnitConvertDTOCompiler((MainEntityType)bizRuleContext.getMainType(), unitConvertDTO);
                this.unitConvertDTOCompilers.add(unitConvertDTOCompiler);
                distEntityTypes.add(unitConvertDTOCompiler.getDistEntityType());
                if (unitConvertDTOCompiler.isConvertable()) {
                    this.getFieldProps().put(unitConvertDTOCompiler.getMaterialProp().getName(), unitConvertDTOCompiler.getMaterialProp());
                    this.getFieldProps().put(unitConvertDTOCompiler.getSrcUnitProp().getName(), unitConvertDTOCompiler.getSrcUnitProp());
                    this.getFieldProps().put(unitConvertDTOCompiler.getSrcQtyProp().getName(), unitConvertDTOCompiler.getSrcQtyProp());
                    this.getFieldProps().put(unitConvertDTOCompiler.getDistUnitProp().getName(), unitConvertDTOCompiler.getDistUnitProp());
                    this.getFieldProps().put(unitConvertDTOCompiler.getDistQtyProp().getName(), unitConvertDTOCompiler.getDistQtyProp());
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)unitConvertDTOCompiler.getErrMessage())) continue;
                throw new KDBizException(unitConvertDTOCompiler.getErrMessage());
            }
        }
        if (this.getBizRule().getPreCondition() == null) {
            this.preConditionExecuter = new GetConstValue(Boolean.TRUE);
        } else {
            UserService userService = new UserService();
            String preCondition = this.getBizRule().getPreCondition().buildFullFormula((MainEntityType)this.getMainType(), (IUserService)userService, null);
            this.preConditionExecuter = StringUtils.isBlank((CharSequence)preCondition) ? new GetConstValue(Boolean.TRUE) : new GetFormulaValue(this.getMainType(), preCondition, bizRuleContext.getFuncLib());
        }
        for (FieldVariable var : this.preConditionExecuter.getVars()) {
            this.getFieldProps().put(var.getFieldProp().getName(), var.getFieldProp());
        }
        EntityType distEntityType = null;
        for (EntityType et : distEntityTypes) {
            if (distEntityType == null) {
                distEntityType = et;
                continue;
            }
            if (this.getEntityLevel(et) <= this.getEntityLevel(distEntityType)) continue;
            distEntityType = et;
        }
        this.entityKey = distEntityType != null ? distEntityType.getName() : this.getMainType().getName();
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public boolean checkPreCondition(RowDataModel rowDataModel, DynamicObject activeRow) {
        rowDataModel.setRowContext(activeRow);
        return (Boolean)this.preConditionExecuter.getValue(rowDataModel);
    }

    protected void doWriteBack(RowDataModel rowDataModel, DynamicObject activeRow) {
        if (this.unitConvertDTOCompilers == null) {
            return;
        }
        for (UnitConvertDTOCompiler item : this.unitConvertDTOCompilers) {
            BigDecimal distValue;
            if (!item.isConvertable() || !item.isExistDistQtyProp(activeRow) || (distValue = this.getDistqty(item, rowDataModel)) == null) continue;
            rowDataModel.setValue(item.getDistQtyProp().getName(), (Object)distValue);
        }
    }

    protected void doConvert(ExtendedDataEntitySet extDataSet, RowDataModel rowDataModel, ExtendedDataEntity[] extDataEntities) {
        this.breakNoConvert = true;
        BillEntityType dt = this.getMainType();
        if (this.unitConvertDTOCompilers != null) {
            for (UnitConvertDTOCompiler item : this.unitConvertDTOCompilers) {
                if (!item.isConvertable()) continue;
                ExtendedDataEntity[] rows = extDataEntities;
                if (!StringUtils.equals((CharSequence)item.getDistEntityType().getName(), (CharSequence)this.entityKey)) {
                    rows = extDataSet.FindByEntityKey(item.getDistEntityType().getName());
                }
                RowDataModel myRowDataModel = new RowDataModel(item.getDistEntityType().getName(), (MainEntityType)dt);
                for (ExtendedDataEntity row : rows) {
                    myRowDataModel.setRowContext((Object)row.getDataEntity(), row.getRowIndex());
                    BigDecimal distValue = this.getDistqty(item, myRowDataModel);
                    if (distValue == null) continue;
                    myRowDataModel.setValue(item.getDistQtyProp().getName(), (Object)distValue);
                }
            }
        }
    }

    private BigDecimal getDistqty(UnitConvertDTOCompiler unitConvertItem, RowDataModel rowModel) {
        String masterIdPropName;
        BigDecimal distQty = BigDecimal.ZERO;
        DynamicObject srcUnitObj = (DynamicObject)rowModel.getValue(unitConvertItem.getSrcQtyProp().getRelatedUnit());
        long srcUnitId = srcUnitObj == null ? 0L : (Long)srcUnitObj.getPkValue();
        String srcUnitNumber = srcUnitObj == null ? "" : (String)srcUnitObj.get(KEY_NUMBER);
        DynamicObject distUnitObj = (DynamicObject)rowModel.getValue(unitConvertItem.getDistQtyProp().getRelatedUnit());
        long distUnitId = distUnitObj == null ? 0L : (Long)distUnitObj.getPkValue();
        String distUnitNumber = distUnitObj == null ? "" : (String)distUnitObj.get(KEY_NUMBER);
        DynamicObject materialObj = (DynamicObject)rowModel.getValue(unitConvertItem.getMaterialProp().getName());
        if (materialObj != null && materialObj.get(masterIdPropName = ((BasedataEntityType)materialObj.getDataEntityType()).getMasteridPropName()) instanceof DynamicObject) {
            materialObj = (DynamicObject)materialObj.get(masterIdPropName);
        }
        long materialId = materialObj == null ? 0L : (Long)materialObj.getPkValue();
        String materialNumber = materialObj == null ? "" : (String)materialObj.get(KEY_NUMBER);
        BigDecimal srcmuCount = (BigDecimal)rowModel.getValue(unitConvertItem.getSrcQtyProp().getName());
        if (srcUnitId == distUnitId) {
            distQty = srcmuCount;
        } else {
            StringBuilder errMsg = new StringBuilder();
            distQty = UnitConvertHelper.calculateNewQty((BigDecimal)srcmuCount, (Long)distUnitId, (Long)srcUnitId, (Long)materialId, (StringBuilder)errMsg);
            if (errMsg.length() > 0) {
                if (this.isBreakNoConvert()) {
                    ErrorCode unitConvertError = new ErrorCode("unit convert error", ResManager.loadKDString((String)"\u5355\u4f4d\u6362\u7b97\u5f02\u5e38\uff0c\u6e90\u5355\u4f4d\u7f16\u7801:%1$s \u76ee\u6807\u5355\u4f4d\u7f16\u7801:%2$s \u7269\u6599\u7f16\u7801:%3$s\u3002 \u9519\u8bef\u4fe1\u606f:%4$s\u3002", (String)"FillQtyAction_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
                    log.info(String.format(unitConvertError.getMessage(), srcUnitNumber, distUnitNumber, materialNumber, errMsg.toString()));
                    throw new KDBizException(unitConvertError, new Object[]{srcUnitNumber, distUnitNumber, materialNumber, errMsg.toString()});
                }
                log.info(String.format("%s, materialId: %s, srcUnitId: %s, distUnitId: %s, srcQty: %s, return %s, error info: %s ", this.buildBizRuleInfo(), materialId, srcUnitId, distUnitId, srcmuCount, null, errMsg.toString()));
                return null;
            }
        }
        log.info(String.format("%s, materialId: %s, srcUnitId: %s, distUnitId: %s, srcQty: %s, return %s", this.buildBizRuleInfo(), materialId, srcUnitId, distUnitId, srcmuCount, distQty));
        return distQty;
    }

    private String buildBizRuleInfo() {
        if (this.bizRuleInfo != null) {
            return this.bizRuleInfo;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getBizRuleContext() != null && this.getBizRuleContext().getConvertRule() != null) {
            sb.append(this.getBizRuleContext().getConvertRule().getSourceEntityNumber());
            sb.append("->");
            sb.append(this.getBizRuleContext().getConvertRule().getTargetEntityNumber());
            sb.append("(");
            sb.append(this.getBizRuleContext().getConvertRule().getName().toString());
            sb.append("), ");
            if (this.getBizRule() != null && this.getBizRule().getDescription() != null) {
                sb.append(this.getBizRule().getDescription().toString());
            }
        } else if (this.getBizRuleContext() != null && this.getBizRuleContext().getWritebackRule() != null) {
            sb.append(this.getBizRuleContext().getWritebackRule().getTargetEntityNumber());
            sb.append("->");
            sb.append(this.getBizRuleContext().getWritebackRule().getSourceEntityNumber());
            sb.append("(");
            sb.append(this.getBizRuleContext().getWritebackRule().getName().toString());
            sb.append("), ");
            sb.append("BR - ");
            if (this.getBizRule() != null && this.getBizRule().getDescription() != null) {
                sb.append(this.getBizRule().getDescription().toString());
            }
        }
        this.bizRuleInfo = sb.toString();
        return this.bizRuleInfo;
    }

    private int getEntityLevel(EntityType et) {
        if (et instanceof SubEntryType) {
            return 3;
        }
        if (et instanceof EntityType) {
            return 2;
        }
        if (et instanceof MainEntityType) {
            return 1;
        }
        return 0;
    }
}

