/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.bizrule;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.UnitConvertDTO;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.servicehelper.UnitConvertHelper;

class UnitConvertDTOCompiler {
    private MainEntityType mainType;
    private UnitConvertDTO unitConvertDTO;
    private MaterielProp materialProp;
    private UnitProp srcUnitProp;
    private QtyProp srcQtyProp;
    private UnitProp distUnitProp;
    private QtyProp distQtyProp;
    private EntityType distEntityType;
    private boolean convertable;
    private String errMessage;

    public UnitConvertDTOCompiler(MainEntityType mainType, UnitConvertDTO unitConvertDTO) {
        this.mainType = mainType;
        this.unitConvertDTO = unitConvertDTO;
        this.compiler();
    }

    public MainEntityType getMainType() {
        return this.mainType;
    }

    public UnitConvertDTO getUnitConvertDTO() {
        return this.unitConvertDTO;
    }

    public EntityType getDistEntityType() {
        return this.distEntityType;
    }

    public MaterielProp getMaterialProp() {
        return this.materialProp;
    }

    public UnitProp getDistUnitProp() {
        return this.distUnitProp;
    }

    public QtyProp getDistQtyProp() {
        return this.distQtyProp;
    }

    public UnitProp getSrcUnitProp() {
        return this.srcUnitProp;
    }

    public QtyProp getSrcQtyProp() {
        return this.srcQtyProp;
    }

    public boolean isConvertable() {
        return this.convertable;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public boolean isExistDistQtyProp(DynamicObject activeRow) {
        if (activeRow.getDataEntityType().getProperties().containsKey((Object)this.getDistQtyProp().getName())) {
            return true;
        }
        for (IDataEntityType parentType = activeRow.getDataEntityType().getParent(); parentType != null; parentType = parentType.getParent()) {
            if (!parentType.getProperties().containsKey((Object)this.getDistQtyProp().getName())) continue;
            return true;
        }
        return false;
    }

    private void compiler() {
        this.convertable = false;
        this.errMessage = null;
        if (this.unitConvertDTO == null || this.mainType == null) {
            return;
        }
        String distQtyFieldKey = this.unitConvertDTO.getDistQtyField();
        String srcQtyFieldKey = this.unitConvertDTO.getSrcQtyField();
        if (StringUtils.isBlank((CharSequence)srcQtyFieldKey)) {
            this.errMessage = "srcQtyFieldKey is null.";
            return;
        }
        IDataEntityProperty srcProp = this.mainType.findProperty(srcQtyFieldKey);
        if (!(srcProp instanceof QtyProp)) {
            this.errMessage = "srcQtyProp is not exist.";
            return;
        }
        if (StringUtils.isBlank((CharSequence)distQtyFieldKey)) {
            this.errMessage = "distQtyFieldKey is null.";
            return;
        }
        IDataEntityProperty distProp = this.mainType.findProperty(distQtyFieldKey);
        if (!(distProp instanceof QtyProp)) {
            this.errMessage = "distQtyProp is not exist.";
            return;
        }
        this.srcQtyProp = (QtyProp)srcProp;
        this.srcUnitProp = (UnitProp)this.mainType.findProperty(this.srcQtyProp.getRelatedUnit());
        this.distQtyProp = (QtyProp)distProp;
        this.distUnitProp = (UnitProp)this.mainType.findProperty(this.distQtyProp.getRelatedUnit());
        if (this.distUnitProp != null) {
            this.materialProp = (MaterielProp)this.mainType.findProperty(this.distUnitProp.getMaterielField());
        }
        this.distEntityType = (EntityType)this.distQtyProp.getParent();
        StringBuilder errMsg = new StringBuilder();
        this.convertable = UnitConvertHelper.isConvertable((QtyProp)this.distQtyProp, (QtyProp)this.srcQtyProp, (MainEntityType)this.mainType, (StringBuilder)errMsg);
        if (!this.convertable) {
            this.errMessage = errMsg.toString();
        }
    }
}

