/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKeyBuilder;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.query.BotpQueryParameter;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.service.botp.convert.var.UnknowVariable;

public abstract class AbstractEntityMap {
    protected String sourceEntryKey;
    protected String sourceSubEntryKey;
    protected Map<EntityType, List<SourceFieldVariable>> sourceFields = new HashMap<EntityType, List<SourceFieldVariable>>();
    protected String sourceEntityKeys;
    private IGetValueMode srcBillIdReader;
    private IGetValueMode srcEntryIdReader;
    private IGetValueMode srcEntrySeqReader;
    private IGetValueMode srcSubEntryIdReader;
    private IGetValueMode srcSubEntrySeqReader;
    protected String targetEntryKey;
    protected String targetSubEntryKey;
    protected Map<EntityType, List<IMappingField>> targetFields = new HashMap<EntityType, List<IMappingField>>();
    protected String targetEntityKeys;
    protected String srcSelectString;
    protected Map<String, String> srcFldAlias = new HashMap<String, String>();
    protected List<QFilter> qFilters = new ArrayList<QFilter>();
    protected Map<String, DynamicProperty> srcFldPropertys = new HashMap<String, DynamicProperty>();
    protected BotpQueryParameter queryParameter;
    protected List<DynamicObject> sourceRows = new ArrayList<DynamicObject>();
    protected List<SourceRowsGroupKeyBuilder> sourceRowsGroupKeyBuilders = new ArrayList<SourceRowsGroupKeyBuilder>();
    protected SourceRowsGroup sourceRowsGroup;

    public String getSourceEntryKey() {
        return this.sourceEntryKey;
    }

    public void setSourceEntryKey(String sourceEntryKey) {
        this.sourceEntryKey = sourceEntryKey;
    }

    public String getSourceEntryPKFullName() {
        return this.sourceEntryKey + ".id";
    }

    public String getSourceEntrySeqFullName() {
        return this.sourceEntryKey + ".seq";
    }

    public String getSourceSubEntryKey() {
        return this.sourceSubEntryKey;
    }

    public void setSourceSubEntryKey(String sourceSubEntryKey) {
        this.sourceSubEntryKey = sourceSubEntryKey;
    }

    public String getSourceSubEntryPKFullName() {
        return this.sourceEntryKey + "." + this.sourceSubEntryKey + ".id";
    }

    public String getSourceSubEntrySeqFullName() {
        return this.sourceEntryKey + "." + this.sourceSubEntryKey + ".seq";
    }

    public Map<EntityType, List<SourceFieldVariable>> getSourceFields() {
        return this.sourceFields;
    }

    public IGetValueMode getSrcBillIdReader() {
        return this.srcBillIdReader;
    }

    public IGetValueMode getSrcEntryIdReader() {
        return this.srcEntryIdReader;
    }

    public IGetValueMode getSrcEntrySeqReader() {
        return this.srcEntrySeqReader;
    }

    public IGetValueMode getSrcSubEntryIdReader() {
        return this.srcSubEntryIdReader;
    }

    public IGetValueMode getSrcSubEntrySeqReader() {
        return this.srcSubEntrySeqReader;
    }

    public Map<String, SourceFieldVariable> getAllSourceFields() {
        HashMap<String, SourceFieldVariable> fields = new HashMap<String, SourceFieldVariable>();
        for (Map.Entry<EntityType, List<SourceFieldVariable>> entityItem : this.sourceFields.entrySet()) {
            for (SourceFieldVariable srcFldVar : entityItem.getValue()) {
                String var = srcFldVar.getVar();
                if (fields.containsKey(var)) continue;
                fields.put(var, srcFldVar);
            }
        }
        return fields;
    }

    public String getTargetEntryKey() {
        return this.targetEntryKey;
    }

    public void setTargetEntryKey(String targetEntryKey) {
        this.targetEntryKey = targetEntryKey;
    }

    public String getTargetSubEntryKey() {
        return this.targetSubEntryKey;
    }

    public void setTargetSubEntryKey(String targetSubEntryKey) {
        this.targetSubEntryKey = targetSubEntryKey;
    }

    public Map<EntityType, List<IMappingField>> getTargetFields() {
        return this.targetFields;
    }

    public String getSrcSelectString() {
        return this.srcSelectString;
    }

    public void setSrcSelectString(String srcSelectString) {
        this.srcSelectString = srcSelectString;
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public Map<String, String> getSrcFldAlias() {
        return this.srcFldAlias;
    }

    public synchronized Map<String, DynamicProperty> getSrcFldPropertys() {
        return this.srcFldPropertys;
    }

    public synchronized void setSrcFldPropertys(Map<String, DynamicProperty> map) {
        if (this.srcFldPropertys.isEmpty()) {
            this.srcFldPropertys.putAll(map);
        }
    }

    public synchronized BotpQueryParameter getQueryParameter() {
        return this.queryParameter;
    }

    public List<DynamicObject> getSourceRows() {
        return this.sourceRows;
    }

    public SourceRowsGroup getSourceRowsGroup() {
        return this.sourceRowsGroup;
    }

    public void setSourceRowsGroup(SourceRowsGroup sourceRowsGroup) {
        this.sourceRowsGroup = sourceRowsGroup;
    }

    public List<SourceRowsGroupKeyBuilder> getSourceRowsGroupKeyBuilders() {
        return this.sourceRowsGroupKeyBuilders;
    }

    public void addMappingField(IMappingField mappingField) {
        EntityType entityType = (EntityType)mappingField.getTargetFieldProp().getParent();
        if (!this.targetFields.containsKey(entityType)) {
            this.targetFields.put(entityType, new ArrayList());
        }
        this.targetFields.get(entityType).add(mappingField);
        for (SourceFieldVariable srcFieldVar : mappingField.getSrcFieldVars()) {
            this.addSourceField(srcFieldVar);
        }
    }

    public void addMappingFields(List<IMappingField> mappingFields) {
        for (IMappingField mappingField : mappingFields) {
            this.addMappingField(mappingField);
        }
    }

    public void addSourceField(SourceFieldVariable srcFldVar) {
        if (srcFldVar == null) {
            return;
        }
        EntityType srcEntityType = (EntityType)srcFldVar.getSourceField().getParent();
        if (!this.sourceFields.containsKey(srcEntityType)) {
            this.sourceFields.put(srcEntityType, new ArrayList());
        }
        this.sourceFields.get(srcEntityType).add(srcFldVar);
        this.sourceEntityKeys = null;
    }

    public void addSourceRowsGroupKeyBuilders(SourceRowsGroupKeyBuilder groupKeyBuilder) {
        this.sourceRowsGroupKeyBuilders.add(groupKeyBuilder);
        for (IVariableMode var : groupKeyBuilder.getVars()) {
            if (var instanceof UnknowVariable) {
                String srcEntityNumber = groupKeyBuilder.getRuleContext() == null ? "" : groupKeyBuilder.getRuleContext().getRule().getSourceEntityNumber();
                KDBizException e = new KDBizException(BosErrorCode.fieldNotExist, new Object[]{srcEntityNumber, var.getVar()});
                throw e;
            }
            this.addSourceField((SourceFieldVariable)var);
        }
    }

    public String getJoinSourceEntityKeys() {
        if (StringUtils.isBlank((CharSequence)this.sourceEntityKeys)) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("billhead").append('|');
            if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
                sBuilder.append(this.sourceEntryKey).append('|');
                if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
                    sBuilder.append(this.sourceSubEntryKey).append('|');
                }
            }
            this.sourceEntityKeys = sBuilder.toString();
        }
        return this.sourceEntityKeys;
    }

    public String getJoinTargetEntityKeys() {
        if (StringUtils.isBlank((CharSequence)this.targetEntityKeys)) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("billhead").append('|');
            if (StringUtils.isNotBlank((CharSequence)this.targetEntryKey)) {
                sBuilder.append(this.targetEntryKey).append('|');
                if (StringUtils.isNotBlank((CharSequence)this.targetSubEntryKey)) {
                    sBuilder.append(this.targetSubEntryKey).append('|');
                }
            }
            this.targetEntityKeys = sBuilder.toString();
        }
        return this.targetEntityKeys;
    }

    public boolean includeOther(String a, String b) {
        return StringUtils.isBlank((CharSequence)a) || StringUtils.isBlank((CharSequence)b) || a.startsWith(b) || b.startsWith(a);
    }

    public void compileSelectString(SingleRuleContext ruleContext) {
        String alias;
        this.compileSourceRowIdReader(ruleContext);
        ArrayList<String> selectFldStrings = new ArrayList<String>(10);
        int fldIndex = 0;
        BillEntityType srcMainType = ruleContext.getContext().getSourceMainType();
        this.queryParameter = new BotpQueryParameter(srcMainType.getName(), StringUtils.equals((CharSequence)"true", (CharSequence)ruleContext.getRule().getOptionPolicy().getOnlyReadBillTable()));
        String pkPropName = srcMainType.getPrimaryKey().getName();
        this.srcFldAlias.put(pkPropName, pkPropName);
        selectFldStrings.add(pkPropName);
        this.queryParameter.addSelectField((IDataEntityProperty)srcMainType.getPrimaryKey(), null, pkPropName);
        ++fldIndex;
        if (StringUtils.isNotBlank((CharSequence)srcMainType.getBillNo())) {
            this.srcFldAlias.put(srcMainType.getBillNo(), srcMainType.getBillNo());
            selectFldStrings.add(srcMainType.getBillNo());
            this.queryParameter.addSelectField((IDataEntityProperty)srcMainType.getProperty(srcMainType.getBillNo()), null, srcMainType.getBillNo());
            ++fldIndex;
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
            String entryPKPropName = this.getSourceEntryPKFullName();
            alias = "f" + Integer.toString(fldIndex);
            this.srcFldAlias.put(entryPKPropName, alias);
            selectFldStrings.add(entryPKPropName + " " + alias);
            this.queryParameter.addSelectField(srcMainType.findProperty(entryPKPropName), null, alias);
            ++fldIndex;
            String entrySeqPropName = this.getSourceEntrySeqFullName();
            if (srcMainType.findProperty(entrySeqPropName) != null) {
                String seqAlias = "f" + Integer.toString(fldIndex);
                this.srcFldAlias.put(entrySeqPropName, seqAlias);
                selectFldStrings.add(entrySeqPropName + " " + seqAlias);
                this.queryParameter.addSelectField(srcMainType.findProperty(entrySeqPropName), null, seqAlias);
                ++fldIndex;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
            String subEntryPKPropName = this.getSourceSubEntryPKFullName();
            alias = "f" + Integer.toString(fldIndex);
            String subEntryIdProp = this.sourceSubEntryKey + ".id";
            this.srcFldAlias.put(subEntryPKPropName, alias);
            this.srcFldAlias.put(subEntryIdProp, alias);
            selectFldStrings.add(subEntryPKPropName + " " + alias);
            this.queryParameter.addSelectField(srcMainType.findProperty(subEntryIdProp), null, alias);
            ++fldIndex;
            String subEntrySeqPropName = this.sourceSubEntryKey + ".seq";
            String subEntrySeqProp = this.sourceSubEntryKey + ".seq";
            if (srcMainType.findProperty(subEntrySeqPropName) != null) {
                subEntrySeqPropName = this.getSourceSubEntrySeqFullName();
                String seqAlias = "f" + Integer.toString(fldIndex);
                this.srcFldAlias.put(subEntrySeqPropName, seqAlias);
                this.srcFldAlias.put(this.sourceSubEntryKey + ".seq", seqAlias);
                selectFldStrings.add(subEntrySeqPropName + " " + seqAlias);
                this.queryParameter.addSelectField(srcMainType.findProperty(subEntrySeqProp), null, seqAlias);
                ++fldIndex;
            }
        }
        Map<String, SourceFieldVariable> srcFields = this.getAllSourceFields();
        for (SourceFieldVariable srcField : srcFields.values()) {
            String var = srcField.getVar();
            if (this.srcFldAlias.containsKey(var)) continue;
            String fldAlias = "f" + fldIndex;
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            this.srcFldAlias.put(var, fldAlias);
            this.queryParameter.addSelectField(srcField.getSourceField(), StringUtils.join((Object[])srcField.getRefProps(), (String)"."), fldAlias);
            ++fldIndex;
        }
        ruleContext.getBasedataVersionManager().prepareBasedataPropForVersion(srcMainType, srcFields, this.srcFldAlias, selectFldStrings);
        this.srcSelectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
    }

    private void compileSourceRowIdReader(SingleRuleContext ruleContext) {
        BillEntityType srcMainType = ruleContext.getContext().getSourceMainType();
        this.srcBillIdReader = new GetSourceFieldValue(ruleContext, "id");
        if (StringUtils.isBlank((CharSequence)this.sourceEntryKey)) {
            this.srcEntryIdReader = new GetConstValue(null);
            this.srcEntrySeqReader = new GetConstValue(0);
        } else {
            this.srcEntryIdReader = new GetSourceFieldValue(ruleContext, this.getSourceEntryPKFullName());
            String entrySeqPropName = this.getSourceEntrySeqFullName();
            this.srcEntrySeqReader = srcMainType.findProperty(entrySeqPropName) == null ? new GetConstValue(0) : new GetSourceFieldValue(ruleContext, this.getSourceEntrySeqFullName());
        }
        if (StringUtils.isBlank((CharSequence)this.sourceSubEntryKey)) {
            this.srcSubEntryIdReader = new GetConstValue(null);
            this.srcSubEntrySeqReader = new GetConstValue(0);
        } else {
            this.srcSubEntryIdReader = new GetSourceFieldValue(ruleContext, this.getSourceSubEntryPKFullName());
            String subEntrySeqPropName = this.sourceSubEntryKey + ".seq";
            this.srcSubEntrySeqReader = srcMainType.findProperty(subEntrySeqPropName) == null ? new GetConstValue(0) : new GetSourceFieldValue(ruleContext, this.getSourceSubEntrySeqFullName());
        }
    }
}

