/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.getvaluemode.basedataver.GetConditionValueBasedataVer;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.user.UserService;

public class CRConditionCompiler {
    private CRCondition crCondition;
    private List<QFilter> gridQFilters = new ArrayList<QFilter>();
    private IGetValueMode gridFilterExecuter;
    private IGetValueMode expressionExecuter;
    private List<QFilter> custQFilters = new ArrayList<QFilter>();
    private String custFilterExpression;
    private IGetValueMode custExpressionExecuter;
    private String custFilterDesc;
    private List<CRConditionCompiler> subCondCompilers = new ArrayList<CRConditionCompiler>();
    private String description;
    private String fullExpression;
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();

    public CRConditionCompiler(CRCondition crCondition) {
        this.crCondition = crCondition;
    }

    public CRConditionCompiler(List<QFilter> custQFilters, String custFilterExpression, String custFilterDesc) {
        if (custQFilters != null) {
            this.custQFilters.addAll(custQFilters);
        }
        this.custFilterExpression = custFilterExpression;
        this.custFilterDesc = custFilterDesc;
    }

    public CRConditionCompiler(CRCondition crCondition, List<QFilter> custQFilters, String custFilterExpression, String custFilterDesc) {
        this.crCondition = crCondition;
        if (custQFilters != null) {
            this.custQFilters.addAll(custQFilters);
        }
        this.custFilterExpression = custFilterExpression;
        this.custFilterDesc = custFilterDesc;
    }

    public CRCondition getCRCondition() {
        return this.crCondition;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFullExpression() {
        return this.fullExpression;
    }

    public List<QFilter> getGridQFilters() {
        return this.gridQFilters;
    }

    public IGetValueMode getGridFilterExecuter() {
        return this.gridFilterExecuter;
    }

    public IGetValueMode getExpressionExecuter() {
        return this.expressionExecuter;
    }

    public List<QFilter> getCustQFilters() {
        return this.custQFilters;
    }

    public String getCustFilterDesc() {
        return this.custFilterDesc;
    }

    public void setCustFilterDesc(String custFilterDesc) {
        this.custFilterDesc = custFilterDesc;
    }

    public String getCustFilterExpression() {
        return this.custFilterExpression;
    }

    public IGetValueMode getCustExpressionExecuter() {
        return this.custExpressionExecuter;
    }

    public List<CRConditionCompiler> getSubCondCompilers() {
        return this.subCondCompilers;
    }

    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public EntityType getDependEntityType(SingleRuleContext ruleContext) {
        BillEntityType entityType = ruleContext.getContext().getSourceMainType();
        for (IVariableMode var : this.vars) {
            if (!(var instanceof SourceFieldVariable)) continue;
            IDataEntityType fldParentType = ((SourceFieldVariable)var).getSourceField().getParent();
            if (fldParentType instanceof SubEntryType) {
                entityType = (SubEntryType)fldParentType;
                continue;
            }
            if (!(fldParentType instanceof EntryType) || !(entityType instanceof BillEntityType)) continue;
            entityType = (EntryType)fldParentType;
        }
        return entityType;
    }

    public void compile(SingleRuleContext ruleContext) {
        String gridFilterDesc = null;
        ArrayList<String> exps = new ArrayList<String>();
        if (this.crCondition == null) {
            this.gridFilterExecuter = new GetConstValue(Boolean.TRUE);
            this.expressionExecuter = new GetConstValue(Boolean.TRUE);
        } else {
            FilterCondition filterCondition = this.crCondition.getFilterCondition();
            if (filterCondition == null || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
                this.gridFilterExecuter = new GetConstValue(Boolean.TRUE);
            } else {
                FilterBuilder filterBuilder = new FilterBuilder((MainEntityType)ruleContext.getContext().getSourceMainType(), filterCondition);
                TimeService timeService = new TimeService();
                filterBuilder.setTimeService((ITimeService)timeService);
                UserService userService = new UserService();
                filterBuilder.setUserService((IUserService)userService);
                filterBuilder.buildFilter(false);
                this.gridQFilters.clear();
                this.gridQFilters.add(filterBuilder.getQFilter());
                String[] filterScripts = filterBuilder.buildFilterScript();
                String gridFilterString = filterScripts[0];
                if (StringUtils.isNotBlank((CharSequence)gridFilterString)) {
                    this.gridFilterExecuter = new GetConditionValueBasedataVer(ruleContext, gridFilterString);
                    exps.add(gridFilterString);
                } else {
                    this.gridFilterExecuter = new GetConstValue(Boolean.TRUE);
                }
                gridFilterDesc = filterScripts[1];
            }
            if (StringUtils.isBlank((CharSequence)this.crCondition.getExpression())) {
                this.expressionExecuter = new GetConstValue(Boolean.TRUE);
            } else {
                this.expressionExecuter = new GetConditionValueBasedataVer(ruleContext, this.crCondition.getExpression());
                exps.add(this.crCondition.getExpression());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.custFilterExpression)) {
            this.custExpressionExecuter = new GetConditionValueBasedataVer(ruleContext, this.custFilterExpression);
            exps.add(this.custFilterExpression);
        } else {
            this.custExpressionExecuter = new GetConstValue(Boolean.TRUE);
        }
        this.description = this.crCondition != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? this.crCondition.getDescription().toString() : gridFilterDesc;
        this.fullExpression = StringUtils.join((Object[])exps.toArray(), (String)" and ");
        this.vars.addAll(this.gridFilterExecuter.getVars());
        this.vars.addAll(this.expressionExecuter.getVars());
        this.vars.addAll(this.custExpressionExecuter.getVars());
    }

    public void compileSubCondition(SingleRuleContext ruleContext) {
        if (this.crCondition == null && this.custQFilters.size() == 0) {
            return;
        }
        if (this.crCondition != null && this.crCondition.getFilterCondition() != null && !this.crCondition.getFilterCondition().getFilterRow().isEmpty()) {
            String str = SerializationUtils.toJsonString((Object)this.crCondition.getFilterCondition());
            FilterCondition copyFilter = (FilterCondition)SerializationUtils.fromJsonString((String)str, FilterCondition.class);
            List<List<SimpleFilterRow>> rowGroups = this.splitFilterRows(copyFilter.getFilterRow());
            for (List<SimpleFilterRow> rows : rowGroups) {
                FilterCondition filterCondition = new FilterCondition();
                filterCondition.setFilterRow(rows);
                CRCondition subCondition = new CRCondition();
                subCondition.setFilterCondition(filterCondition);
                CRConditionCompiler subCondCompiler = new CRConditionCompiler(subCondition);
                subCondCompiler.compile(ruleContext);
                this.subCondCompilers.add(subCondCompiler);
            }
        }
        if (this.crCondition != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getExpression())) {
            CRCondition subCondition = new CRCondition();
            subCondition.setExpression(this.crCondition.getExpression());
            subCondition.setDescription(this.crCondition.getDescription());
            CRConditionCompiler subCondCompiler = new CRConditionCompiler(subCondition);
            subCondCompiler.compile(ruleContext);
            this.subCondCompilers.add(subCondCompiler);
        }
        if (!this.custQFilters.isEmpty() || StringUtils.isNotBlank((CharSequence)this.custFilterExpression)) {
            CRConditionCompiler subCondCompiler = new CRConditionCompiler(this.custQFilters, this.custFilterExpression, this.custFilterDesc);
            subCondCompiler.compile(ruleContext);
            this.subCondCompilers.add(subCondCompiler);
        }
    }

    public boolean executeCondition(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        return (Boolean)this.gridFilterExecuter.getValue(fldProperties, sourceRow) != false && (Boolean)this.expressionExecuter.getValue(fldProperties, sourceRow) != false && (Boolean)this.custExpressionExecuter.getValue(fldProperties, sourceRow) != false;
    }

    public boolean executeCondition(Map<String, String> fldAlias, Row row) {
        return (Boolean)this.gridFilterExecuter.getValue(fldAlias, row) != false && (Boolean)this.expressionExecuter.getValue(fldAlias, row) != false && (Boolean)this.custExpressionExecuter.getValue(fldAlias, row) != false;
    }

    public String buildFailMessage(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, boolean outFormula) {
        String failMessage = null;
        CRConditionCompiler subCondition = null;
        for (CRConditionCompiler condition : this.getSubCondCompilers()) {
            if (condition.executeCondition(fldProperties, sourceRow)) continue;
            subCondition = condition;
            break;
        }
        if (subCondition != null) {
            if (!outFormula) {
                failMessage = StringUtils.isNotBlank((CharSequence)subCondition.getCustFilterDesc()) ? String.format(this.getMultiLMismatchCondition(), subCondition.getCustFilterDesc()) : (this.crCondition != null && this.crCondition.getDescription() != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? String.format(this.getMultiLMismatchCondition(), this.getDescription()) : String.format(this.getMultiLMismatchCondition(), subCondition.getDescription()));
            }
            if (StringUtils.isBlank(failMessage)) {
                failMessage = String.format(this.getMultiLMismatchCondition(), subCondition.getFullExpression());
            }
        }
        if (failMessage == null && this.executeCondition(fldProperties, sourceRow)) {
            failMessage = String.format(this.getMultiLMismatchCondition(), this.getFullExpression());
        }
        return failMessage;
    }

    public String buildFailMessage(Map<String, String> fldAlias, Row row, boolean outFormula) {
        String failMessage = null;
        CRConditionCompiler subCondition = null;
        for (CRConditionCompiler condition : this.getSubCondCompilers()) {
            if (condition.executeCondition(fldAlias, row)) continue;
            subCondition = condition;
            break;
        }
        if (subCondition != null) {
            if (!outFormula) {
                failMessage = StringUtils.isNotBlank((CharSequence)subCondition.getCustFilterDesc()) ? String.format(this.getMultiLMismatchCondition(), subCondition.getCustFilterDesc()) : (this.crCondition != null && this.crCondition.getDescription() != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? String.format(this.getMultiLMismatchCondition(), this.getDescription()) : String.format(this.getMultiLMismatchCondition(), subCondition.getDescription()));
            }
            if (StringUtils.isBlank(failMessage)) {
                failMessage = String.format(this.getMultiLMismatchCondition(), subCondition.getFullExpression());
            }
        }
        if (failMessage == null && this.executeCondition(fldAlias, row)) {
            failMessage = String.format(this.getMultiLMismatchCondition(), this.getFullExpression());
        }
        return failMessage;
    }

    private List<List<SimpleFilterRow>> splitFilterRows(List<SimpleFilterRow> rows) {
        List<List<SimpleFilterRow>> lstGroup = new ArrayList<List<SimpleFilterRow>>();
        if (rows == null || rows.isEmpty()) {
            return lstGroup;
        }
        if (rows.size() == 1) {
            lstGroup.add(rows);
            return lstGroup;
        }
        lstGroup = this.splitByBracket(rows);
        if (lstGroup.isEmpty()) {
            return lstGroup;
        }
        if (lstGroup.size() == 1) {
            String leftBracket = rows.get(0).getLeftBracket().replace(" ", "");
            String rightBracket = rows.get(rows.size() - 1).getRightBracket().replace(" ", "");
            rows.get(0).setLeftBracket(leftBracket.substring(1));
            rows.get(rows.size() - 1).setRightBracket(rightBracket.substring(1));
            lstGroup = this.splitFilterRows(rows);
        }
        if (lstGroup.size() > 1) {
            boolean hadOr = this.isJoinByOr(lstGroup);
            if (hadOr) {
                lstGroup = new ArrayList();
                lstGroup.add(rows);
            } else {
                ArrayList<List<SimpleFilterRow>> tmpGroup = new ArrayList<List<SimpleFilterRow>>();
                tmpGroup.addAll(lstGroup);
                lstGroup.clear();
                for (List list : tmpGroup) {
                    List<List<SimpleFilterRow>> subListGroup = this.splitFilterRows(list);
                    lstGroup.addAll(subListGroup);
                }
            }
        }
        return lstGroup;
    }

    private List<List<SimpleFilterRow>> splitByBracket(List<SimpleFilterRow> rows) {
        ArrayList<List<SimpleFilterRow>> lstGroup = new ArrayList<List<SimpleFilterRow>>();
        int totalLeftBracket = 0;
        ArrayList<SimpleFilterRow> groupDetail = new ArrayList<SimpleFilterRow>();
        for (SimpleFilterRow row : rows) {
            int currRightBracket;
            int currLeftBracket = row.getLeftBracket().replace(" ", "").length();
            if ((totalLeftBracket = totalLeftBracket + currLeftBracket - (currRightBracket = row.getRightBracket().replace(" ", "").length())) > 0) {
                groupDetail.add(row);
                continue;
            }
            groupDetail.add(row);
            lstGroup.add(groupDetail);
            groupDetail = new ArrayList();
        }
        if (!groupDetail.isEmpty()) {
            lstGroup.add(groupDetail);
        }
        return lstGroup;
    }

    private boolean isJoinByOr(List<List<SimpleFilterRow>> lstGroup) {
        boolean hadOr = false;
        for (int i = 0; i < lstGroup.size() - 1; ++i) {
            List<SimpleFilterRow> group = lstGroup.get(i);
            String logic = group.get(group.size() - 1).getLogic();
            if (!StringUtils.equals((CharSequence)logic, (CharSequence)String.valueOf(LogicOperate.OR.getValue())) && !StringUtils.equalsIgnoreCase((CharSequence)logic, (CharSequence)LogicOperate.OR.toString())) continue;
            hadOr = true;
            break;
        }
        return hadOr;
    }

    private String getMultiLMismatchCondition() {
        return ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a %s", (String)"CRConditionCompiler_0", (String)"bos-mservice-botp", (Object[])new Object[0]);
    }
}

