/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.func;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.func.AbstractBOTPFuncImpl;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class GetRelationOrg
extends AbstractBOTPFuncImpl {
    private static final Log log = LogFactory.getLog(GetRelationOrg.class);

    public String getName() {
        return "GetRelationOrg";
    }

    public BOSUDFunction getInstance(ExpressionContext context) {
        return new GetRelationOrg(context);
    }

    public GetRelationOrg() {
    }

    public GetRelationOrg(ExpressionContext context) {
        super(context);
    }

    public Object call(Object ... arg) {
        if (arg.length < 4) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570GetRelationOrg\u7684\u53c2\u6570\u4e0d\u591f\uff0c\u53c2\u6570\u5305\u62ec'\u6e90\u7ec4\u7ec7'\u3001'\u59d4\u6258\u65b9\u5411'\u3001'\u59d4\u6258\u65b9\u7ec4\u7ec7\u804c\u80fd'\u3001'\u53d7\u6258\u65b9\u7ec4\u7ec7\u804c\u80fd'", (String)"GetRelationOrg_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
        }
        Long orgId = (Long)arg[0];
        String direction = (String)arg[1];
        boolean isEntrust = StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)"0");
        String formViewType = (String)arg[2];
        String toViewType = (String)arg[3];
        String targetOrgFunc = isEntrust ? toViewType : formViewType;
        boolean isIncludeFromOrgSelf = true;
        if (arg.length > 4 && arg[4] instanceof Boolean) {
            isIncludeFromOrgSelf = (Boolean)arg[4];
        }
        if (StringUtils.isBlank((CharSequence)toViewType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570GetRelationOrg\u7684'\u53d7\u6258\u7ec4\u7ec7\u804c\u80fd'\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"GetRelationOrg_1", (String)"bos-mservice-botp", (Object[])new Object[0]));
        }
        if (orgId == null || Long.compare(0L, orgId) == 0) {
            log.info(String.format("orgId = %s, return 0L", orgId));
            return 0L;
        }
        Long firstOrgId = this.getFirstOrgId();
        List relationOrgs = null;
        StringBuilder sb = new StringBuilder();
        if (isEntrust) {
            relationOrgs = OrgUnitServiceHelper.getAllToOrg((String)formViewType, (String)toViewType, (Long)orgId);
            sb.append("GetRelationOrg.getAllToOrg(").append("formViewType:= '").append(formViewType).append("',");
            sb.append("toViewType:= '").append(toViewType).append("',");
            sb.append("orgId:= ").append(orgId).append(")");
        } else {
            relationOrgs = OrgUnitServiceHelper.getFromOrgs((String)toViewType, (Long)orgId, (String)formViewType);
            sb.append("GetRelationOrg.getAllToOrg(").append("toViewType:= '").append(toViewType).append("',");
            sb.append("orgId:= ").append(orgId).append(",");
            sb.append("formViewType:= '").append(formViewType).append("')");
        }
        if (relationOrgs.isEmpty()) {
            sb.append(" relationOrgs is empty, return 0L");
            log.info(sb.toString());
            return 0L;
        }
        if (relationOrgs.size() == 1) {
            sb.append("relationOrgs = [").append(relationOrgs.get(0)).append("]");
            log.info(sb.toString());
            return relationOrgs.get(0);
        }
        sb.append("relationOrgs = [");
        for (int i = 0; i < relationOrgs.size(); ++i) {
            if (i >= 5) {
                sb.append("... total ").append(relationOrgs.size()).append(" orgs");
                break;
            }
            if (i > 0) {
                sb.append(",");
            }
            sb.append(relationOrgs.get(i));
        }
        sb.append("]");
        if (firstOrgId != null && relationOrgs.contains(firstOrgId) && this.checkOrgFunc(firstOrgId, targetOrgFunc)) {
            sb.append(" return inputOrgParam : ").append(firstOrgId);
            log.info(sb.toString());
            return firstOrgId;
        }
        if (isIncludeFromOrgSelf && relationOrgs.contains(orgId) && this.checkOrgFunc(orgId, targetOrgFunc)) {
            sb.append(" return srcOrgId : ").append(orgId);
            log.info(sb.toString());
            return orgId;
        }
        Iterator iterator = relationOrgs.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (!this.checkOrgFunc(id, targetOrgFunc)) continue;
            sb.append(" return ").append(id);
            log.info(sb.toString());
            return id;
        }
        sb.append("return 0");
        log.info(sb.toString());
        return 0L;
    }

    private Long getFirstOrgId() {
        if (this.getContext().getOption().containsVariable("botp_firstrelationorgid")) {
            Long orgId = Long.valueOf(this.getContext().getOption().getVariableValue("botp_firstrelationorgid", "0"));
            return orgId;
        }
        return null;
    }

    private boolean checkOrgFunc(Long orgId, String orgFunc) {
        if (StringUtils.isBlank((CharSequence)orgFunc)) {
            return true;
        }
        OrgServiceHelper orgServiceHelper = new OrgServiceHelper();
        DynamicObject orgObj = orgServiceHelper.getBizOrg(orgId, orgFunc);
        return orgObj != null;
    }
}

