/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.getvaluemode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditionType;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.AbstractGetValueMode;
import kd.bos.service.botp.convert.getvaluemode.GetConditionValue;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;

public class GetValueByCondition
extends AbstractGetValueMode {
    protected SingleRuleContext ruleContext;
    private CRValByConditions valByConditions;
    private Object defValue;
    protected List<IVariableMode> vars = new ArrayList<IVariableMode>();
    protected List<Tuple<IGetValueMode, IGetValueMode>> getValueHandlers = new ArrayList<Tuple<IGetValueMode, IGetValueMode>>();

    public GetValueByCondition(SingleRuleContext ruleContext, CRValByConditions valByConditions, Object defValue) {
        this.ruleContext = ruleContext;
        this.valByConditions = valByConditions;
        this.defValue = defValue;
        this.compile();
    }

    public CRValByConditions getValByConditions() {
        return this.valByConditions;
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public List<Tuple<IGetValueMode, IGetValueMode>> getValueHandlers() {
        return this.getValueHandlers;
    }

    public Object getDefValue() {
        return this.defValue;
    }

    @Override
    public Object getValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        Object value = this.defValue;
        for (Tuple<IGetValueMode, IGetValueMode> tuple : this.getValueHandlers) {
            if (!((Boolean)((IGetValueMode)tuple.item1).getValue(fldProperties, sourceRow)).booleanValue()) continue;
            value = ((IGetValueMode)tuple.item2).getValue(fldProperties, sourceRow);
            break;
        }
        return value;
    }

    @Override
    public boolean batchPreCall(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        boolean preCall = false;
        for (Tuple<IGetValueMode, IGetValueMode> tuple : this.getValueHandlers) {
            boolean preCallL = ((IGetValueMode)tuple.item1).batchPreCall(fldProperties, sourceRow);
            boolean preCallF = ((IGetValueMode)tuple.item2).batchPreCall(fldProperties, sourceRow);
            if (!preCallL && !preCallF) continue;
            preCall = true;
        }
        return preCall;
    }

    @Override
    public Object getValue(Map<String, String> fldAlias, Row row) {
        Object value = this.defValue;
        for (Tuple<IGetValueMode, IGetValueMode> tuple : this.getValueHandlers) {
            if (!((Boolean)((IGetValueMode)tuple.item1).getValue(fldAlias, row)).booleanValue()) continue;
            value = ((IGetValueMode)tuple.item2).getValue(fldAlias, row);
            break;
        }
        return value;
    }

    private void compile() {
        this.getValueHandlers.clear();
        if (this.valByConditions == null || this.valByConditions.getItems().isEmpty()) {
            this.getValueHandlers.add(this.buildGetDefValueTuple());
            return;
        }
        ArrayList items = new ArrayList();
        items.addAll(this.valByConditions.getItems());
        items.sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        for (CRValByCondition item : items) {
            IGetValueMode conditionHandler = null;
            IGetValueMode valueHandler = null;
            conditionHandler = this.buildConditionHandler(item);
            valueHandler = this.buildValueHandler(item);
            this.vars.addAll(conditionHandler.getVars());
            this.vars.addAll(valueHandler.getVars());
            this.getValueHandlers.add((Tuple<IGetValueMode, IGetValueMode>)new Tuple((Object)conditionHandler, (Object)valueHandler));
        }
        this.getValueHandlers.add(this.buildGetDefValueTuple());
    }

    protected IGetValueMode buildConditionHandler(CRValByCondition item) {
        if (item.getCondition() == null || item.getSelectType() == CRValByConditionType.Others) {
            return new GetConstValue(Boolean.TRUE);
        }
        String condition = item.getCondition().buildFullFormula((MainEntityType)this.ruleContext.getContext().getSourceMainType());
        if (StringUtils.isBlank((CharSequence)condition)) {
            return new GetConstValue(Boolean.TRUE);
        }
        return new GetConditionValue(this.ruleContext, condition);
    }

    protected IGetValueMode buildValueHandler(CRValByCondition item) {
        if (item.getFormula() == null) {
            return new GetConstValue(this.defValue);
        }
        String formula = item.getFormula().getExpression();
        if (StringUtils.isBlank((CharSequence)formula)) {
            return new GetConstValue(this.defValue);
        }
        return new GetFormulaValue(this.ruleContext, formula);
    }

    private Tuple<IGetValueMode, IGetValueMode> buildGetDefValueTuple() {
        GetConstValue condition = new GetConstValue(Boolean.TRUE);
        GetConstValue value = new GetConstValue(this.defValue);
        return new Tuple((Object)condition, (Object)value);
    }
}

