/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;

public class SourceRowsGroup {
    private SourceRowsGroupKey groupKey;
    private List<SourceRowId> sourceRowIds = new ArrayList<SourceRowId>();
    private List<DynamicObject> sourceRows = new ArrayList<DynamicObject>();
    private Map<SourceRowsGroupKey, SourceRowsGroup> childGroupMap = new HashMap<SourceRowsGroupKey, SourceRowsGroup>();
    private List<SourceRowsGroup> childGroupList = new ArrayList<SourceRowsGroup>();
    private Object targetBillId;
    private int startEntrySeq = 1;
    private boolean existNextBatch;

    public SourceRowsGroup(SourceRowsGroupKey groupKey) {
        this.groupKey = groupKey;
    }

    public SourceRowsGroupKey getGroupKey() {
        return this.groupKey;
    }

    public List<SourceRowId> getSourceRowIds() {
        return this.sourceRowIds;
    }

    public List<DynamicObject> getSourceRows() {
        return this.sourceRows;
    }

    public Map<SourceRowsGroupKey, SourceRowsGroup> getChildGroupMap() {
        return this.childGroupMap;
    }

    public List<SourceRowsGroup> getChildGroupList() {
        return this.childGroupList;
    }

    public Object getTargetBillId() {
        return this.targetBillId;
    }

    public void setTargetBillId(Object targetBillId) {
        this.targetBillId = targetBillId;
    }

    public int getStartEntrySeq() {
        return this.startEntrySeq;
    }

    public void setStartEntrySeq(int startEntrySeq) {
        this.startEntrySeq = startEntrySeq;
    }

    public boolean isExistNextBatch() {
        return this.existNextBatch;
    }

    public void setExistNextBatch(boolean existNextBatch) {
        this.existNextBatch = existNextBatch;
    }

    public int getEntryRowCount() {
        int entryRowCount = 0;
        if (this.groupKey == null) {
            for (SourceRowsGroup bill : this.childGroupList) {
                entryRowCount += bill.getEntryRowCount();
            }
        } else {
            if (this.childGroupList.isEmpty()) {
                return 1;
            }
            return this.childGroupList.size();
        }
        return entryRowCount;
    }

    public void addSourceRow(DynamicObject sourceRow, List<SourceRowsGroupKey> groupKeys) {
        this.sourceRows.add(sourceRow);
        if (groupKeys.isEmpty()) {
            return;
        }
        SourceRowsGroupKey firstGroupKey = groupKeys.get(0);
        ArrayList<SourceRowsGroupKey> otherGroupKeys = new ArrayList<SourceRowsGroupKey>(groupKeys.size());
        for (int i = 1; i < groupKeys.size(); ++i) {
            otherGroupKeys.add(groupKeys.get(i));
        }
        SourceRowsGroup childGroup = this.childGroupMap.computeIfAbsent(firstGroupKey, key -> {
            SourceRowsGroup newChildGroup = new SourceRowsGroup((SourceRowsGroupKey)key);
            this.childGroupList.add(newChildGroup);
            return newChildGroup;
        });
        childGroup.addSourceRow(sourceRow, otherGroupKeys);
    }

    public void addSourceRow(SourceRowId sourceRowId, List<SourceRowsGroupKey> groupKeys) {
        this.sourceRowIds.add(sourceRowId);
        if (groupKeys == null || groupKeys.isEmpty()) {
            return;
        }
        SourceRowsGroupKey firstGroupKey = groupKeys.get(0);
        ArrayList<SourceRowsGroupKey> otherGroupKeys = new ArrayList<SourceRowsGroupKey>(3);
        for (int i = 1; i < groupKeys.size(); ++i) {
            otherGroupKeys.add(groupKeys.get(i));
        }
        SourceRowsGroup childGroup = this.childGroupMap.computeIfAbsent(firstGroupKey, key -> {
            SourceRowsGroup newChildGroup = new SourceRowsGroup((SourceRowsGroupKey)key);
            this.childGroupList.add(newChildGroup);
            return newChildGroup;
        });
        childGroup.addSourceRow(sourceRowId, otherGroupKeys);
    }

    public SourceRowsGroup splitSubList(int batchRowCount) {
        int count;
        int startEntrySeq = this.getStartEntrySeq();
        if (startEntrySeq > this.getChildGroupList().size()) {
            return null;
        }
        SourceRowsGroup billGroup = new SourceRowsGroup(this.getGroupKey());
        billGroup.setTargetBillId(this.getTargetBillId());
        billGroup.setStartEntrySeq(startEntrySeq);
        for (count = 0; count < batchRowCount && startEntrySeq + count <= this.childGroupList.size(); ++count) {
            SourceRowsGroup rowGroup = this.childGroupList.get(startEntrySeq + count - 1);
            billGroup.getChildGroupList().add(rowGroup);
            billGroup.getChildGroupMap().put(rowGroup.getGroupKey(), rowGroup);
            billGroup.getSourceRowIds().addAll(rowGroup.getSourceRowIds());
        }
        this.setStartEntrySeq(startEntrySeq + count);
        billGroup.setExistNextBatch(this.getStartEntrySeq() <= this.getChildGroupList().size());
        return billGroup;
    }

    public void fillSourceRow(Map<SourceRowId, DynamicObject> rows) {
        for (SourceRowId sourceRowId : this.sourceRowIds) {
            DynamicObject dynamicObject = rows.get(sourceRowId);
            if (dynamicObject == null) continue;
            this.sourceRows.add(dynamicObject);
        }
        for (SourceRowsGroup childGroup : this.childGroupList) {
            childGroup.fillSourceRow(rows);
        }
    }

    public void clearSourceRow() {
        for (SourceRowsGroup childGroup : this.childGroupList) {
            childGroup.clearSourceRow();
        }
        this.sourceRows.clear();
    }

    public void clearMemory() {
        if (this.childGroupList == null) {
            return;
        }
        for (SourceRowsGroup childGroup : this.childGroupList) {
            childGroup.clearMemory();
        }
        this.childGroupList.clear();
        this.childGroupList = null;
        this.childGroupMap.clear();
        this.childGroupMap = null;
        this.sourceRowIds.clear();
        this.sourceRowIds = null;
        this.sourceRows.clear();
        this.sourceRows = null;
    }

    public String toString() {
        if (this.groupKey == null) {
            return super.toString();
        }
        return this.groupKey.toString();
    }
}

