/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.AbstractGetValueMode;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.var.IVariableMode;

public class SourceRowsGroupKeyBuilder {
    private String groupFieldKey;
    private SingleRuleContext ruleContext;
    private List<IGetValueMode> fldValueGetHandlers = new ArrayList<IGetValueMode>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    public static final String ALLINONE = "@all";

    public SourceRowsGroupKeyBuilder(SingleRuleContext ruleContext, String groupFieldKey) {
        this.ruleContext = ruleContext;
        this.groupFieldKey = groupFieldKey;
        this.compile();
    }

    public List<IGetValueMode> getFldValueGetHandlers() {
        return this.fldValueGetHandlers;
    }

    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public SourceRowsGroupKey getFldValues(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        Object[] fldValues = new Object[this.fldValueGetHandlers.size()];
        for (int i = 0; i < this.fldValueGetHandlers.size(); ++i) {
            IGetValueMode fldValueGetHandler = this.fldValueGetHandlers.get(i);
            fldValues[i] = fldValueGetHandler.getValue(fldProperties, sourceRow);
        }
        return new SourceRowsGroupKey(fldValues);
    }

    public SourceRowsGroupKey getFldValues(Map<String, String> fldAlias, Row row) {
        Object[] fldValues = new Object[this.fldValueGetHandlers.size()];
        for (int i = 0; i < this.fldValueGetHandlers.size(); ++i) {
            IGetValueMode fldValueGetHandler = this.fldValueGetHandlers.get(i);
            fldValues[i] = fldValueGetHandler.getValue(fldAlias, row);
        }
        return new SourceRowsGroupKey(fldValues);
    }

    private void compile() {
        String[] fldKeys = StringUtils.split((String)this.groupFieldKey, (String)",");
        this.fldValueGetHandlers = new ArrayList<IGetValueMode>(10);
        for (String fldKey : fldKeys) {
            AbstractGetValueMode fldValueGetHandler = null;
            fldValueGetHandler = ALLINONE.equals(fldKey) ? new GetConstValue(ALLINONE) : new GetSourceFieldValue(this.ruleContext, fldKey);
            this.fldValueGetHandlers.add(fldValueGetHandler);
            this.vars.addAll(fldValueGetHandler.getVars());
        }
    }

    public SingleRuleContext getRuleContext() {
        return this.ruleContext;
    }
}

