/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.log.ConvertLog;

public class CompleteLog
extends ConvertLog {
    private boolean complete;
    private boolean success;
    private Date endTime;
    private Set<Long> successTargetBillIds = new HashSet<Long>();

    public CompleteLog() {
    }

    public CompleteLog(boolean success) {
        this.success = success;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Set<Long> getSuccessTargetBillIds() {
        return this.successTargetBillIds;
    }

    public void setSuccessTargetBillIds(Set<Long> successTargetBillIds) {
        this.successTargetBillIds = successTargetBillIds;
    }

    public void completeConvertLog(LogORM logORM, MainEntityType logType) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        MainEntityType subMainType = (MainEntityType)logType.getSubEntityType(Arrays.asList("id", "opdate", "status", "tbillno", "endtime"));
        this.buildSuccessLogs(logORM, subMainType, logs);
        this.buildFailLogs(logORM, subMainType, logs);
        logORM.update(logs);
    }

    private void buildSuccessLogs(LogORM logORM, MainEntityType subMainType, List<DynamicObject> logs) {
        boolean noSuccessId;
        boolean bl = noSuccessId = this.successTargetBillIds == null || this.successTargetBillIds.isEmpty();
        if (noSuccessId && !this.success) {
            return;
        }
        QFilter filter = new QFilter("taskid", "=", (Object)this.getTaskId());
        if (!noSuccessId) {
            filter = filter.and(new QFilter("tbillid", "in", this.successTargetBillIds));
        }
        Set<Long> successLogIds = this.queryLogIds(logORM, subMainType, new QFilter[]{filter});
        for (Long logId : successLogIds) {
            DynamicObject convertLogObj = new DynamicObject((DynamicObjectType)subMainType);
            subMainType.getPrimaryKey().setValueFast((Object)convertLogObj, (Object)logId);
            convertLogObj.set("status", (Object)"1");
            convertLogObj.set("endtime", (Object)this.getEndTime());
            logs.add(convertLogObj);
        }
    }

    private void buildFailLogs(LogORM logORM, MainEntityType subMainType, List<DynamicObject> logs) {
        boolean noSuccessId;
        if (!this.complete) {
            return;
        }
        boolean bl = noSuccessId = this.successTargetBillIds == null || this.successTargetBillIds.isEmpty();
        if (noSuccessId && this.success) {
            return;
        }
        QFilter filter = new QFilter("taskid", "=", (Object)this.getTaskId()).and(new QFilter("status", "=", (Object)"0"));
        if (!noSuccessId) {
            filter = filter.and(new QFilter("tbillid", "not in", this.successTargetBillIds));
        }
        Set<Long> failLogIds = this.queryLogIds(logORM, subMainType, new QFilter[]{filter});
        for (Long logId : failLogIds) {
            DynamicObject convertLogObj = new DynamicObject((DynamicObjectType)subMainType);
            subMainType.getPrimaryKey().setValueFast((Object)convertLogObj, (Object)logId);
            convertLogObj.set("status", (Object)"-1");
            convertLogObj.set("endtime", (Object)this.getEndTime());
            logs.add(convertLogObj);
        }
    }

    private Set<Long> queryLogIds(LogORM logORM, MainEntityType logType, QFilter[] filters) {
        HashSet<Long> successLogIds = new HashSet<Long>();
        try (DataSet ds = logORM.queryDataSet(logType.getName(), "id", filters, 0, 100000);){
            while (ds.hasNext()) {
                Row row = ds.next();
                successLogIds.add(row.getLong("id"));
            }
            HashSet<Long> hashSet = successLogIds;
            return hashSet;
        }
    }
}

