/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.org;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.botp.convert.org.GetMainOrgProcess;
import kd.bos.service.botp.convert.org.HandoverOrgManager;
import kd.bos.service.botp.convert.org.MainOrgContext;
import kd.bos.service.botp.convert.org.MainOrgResult;
import kd.bos.service.botp.convert.org.PermOrgManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class GetMainOrgForMapping
extends GetMainOrgProcess {
    public GetMainOrgForMapping(MainOrgContext context, PermOrgManager permOrgManager, HandoverOrgManager handoverOrgManager) {
        super(context, permOrgManager, handoverOrgManager);
    }

    @Override
    protected Long get(List<DynamicObject> sourceRows) {
        if (this.context.getMappingMainOrg() == null) {
            return null;
        }
        Long pushDefOrgId = ((PushArgs)this.context.getConvertContext().getInputArgs()).getDefOrgId();
        return this.calcMainOrg(pushDefOrgId, sourceRows);
    }

    @Override
    protected MainOrgResult check(Long orgId) {
        if (this.context.getMappingMainOrg() == null) {
            return null;
        }
        if (orgId == null) {
            String failMessage = this.buildErrMessageForMainOrg();
            return MainOrgResult.fail(failMessage, MainOrgResult.FailType.NORMAL_REPORT);
        }
        Map orgObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{orgId}, (DynamicObjectType)this.context.getMainOrgProp().getDynamicComplexPropertyType());
        DynamicObject calcOrgObj = (DynamicObject)orgObjs.get(orgId);
        if (calcOrgObj == null) {
            String failMessage = this.buildErrMessageForMainOrg();
            return MainOrgResult.fail(failMessage, MainOrgResult.FailType.NORMAL_REPORT);
        }
        HasPermOrgResult permResult = this.permOrgManager.loadPermOrgResult();
        HashSet authOrgIds = new HashSet(permResult.getHasPermOrgs());
        if (this.context.getMainOrgProp().canBeMainOrg(((Long)calcOrgObj.getPkValue()).longValue(), !permResult.hasAllOrgPerm(), authOrgIds)) {
            return MainOrgResult.success((Long)calcOrgObj.getPkValue());
        }
        String failMessage = "";
        failMessage = permResult.hasAllOrgPerm() ? String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%3$s\u3011\u4e0d\u7b26\u5408\u76ee\u6807\u5355\u7ec4\u7ec7\u804c\u80fd\u8981\u6c42", (String)"CreateTargetBillAction_24", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), calcOrgObj.getString("name")) : (!authOrgIds.contains((Long)calcOrgObj.getPkValue()) ? String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%3$s\u3011\u6ca1\u6709\u65b0\u589e\u6743\u9650", (String)"CreateTargetBillAction_25", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), calcOrgObj.getString("name")) : String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u3010%3$s\u3011\u4e0d\u7b26\u5408\u76ee\u6807\u5355\u7ec4\u7ec7\u804c\u80fd\u8981\u6c42", (String)"CreateTargetBillAction_24", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), calcOrgObj.getString("name")));
        return MainOrgResult.fail(failMessage, MainOrgResult.FailType.NORMAL_REPORT);
    }

    private Long calcMainOrg(Long defOrgId, List<DynamicObject> sourceRows) {
        if (defOrgId != null && Long.compare(0L, defOrgId) != 0) {
            this.context.getConvertContext().getOption().setVariableValue("botp_firstrelationorgid", defOrgId.toString());
        } else {
            this.context.getConvertContext().getOption().removeVariable("botp_firstrelationorgid");
        }
        if (this.context.getMappingMainOrg() != null) {
            Long calcOrgId = (Long)this.context.getMappingMainOrg().calcMapValue(this.context.getLinkEntityMap().getSrcFldPropertys(), sourceRows);
            if (calcOrgId == null || Long.compare(0L, calcOrgId) == 0) {
                return null;
            }
            return calcOrgId;
        }
        return null;
    }

    @VisibleForTesting
    protected String buildErrMessageForMainOrg() {
        String failMessage = "";
        if (this.context.getMappingMainOrg() == null) {
            failMessage = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010%1$s\u3011\u3010%2$s\u3011\u5b57\u6bb5\u7684\u53d6\u503c\u516c\u5f0f\uff1b", (String)"CreateTargetBillAction_23", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString());
        } else if (this.context.getMappingMainOrg().getFieldMap().getFieldConvertType() == FieldConvertType.SourceField) {
            if (!this.context.getLinkEntityMap().getSrcFldAlias().containsKey(this.context.getMappingMainOrg().getFieldMap().getSourceFieldKey())) {
                failMessage = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u662f\u4e3b\u7ec4\u7ec7\u5b57\u6bb5\uff0c\u53ea\u80fd\u53d6\u6e90\u5355\u5355\u636e\u5934\u6216\u8005\u5173\u8054\u4e3b\u5b9e\u4f53\u5b57\u6bb5\u503c", (String)"CreateTargetBillAction_26", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString());
            } else {
                IDataEntityProperty srcProp = this.context.getConvertContext().getSourceMainType().findProperty(this.context.getMappingMainOrg().getFieldMap().getSourceFieldKey());
                String sourceField = "";
                sourceField = srcProp == null ? this.context.getMappingMainOrg().getFieldMap().getSourceFieldKey() : srcProp.getDisplayName().toString();
                failMessage = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6e90\u5355\u3010%3$s\u3011\u662f\u5426\u6709\u503c", (String)"CreateTargetBillAction_27", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString(), sourceField);
            }
        } else {
            failMessage = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u5b57\u6bb5\u53d6\u503c\u516c\u5f0f\u662f\u5426\u65e0\u8bef", (String)"CreateTargetBillAction_28", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString());
        }
        return failMessage;
    }
}

