/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.query.BotpQueryParameter;
import kd.bos.service.botp.convert.query.BotpRefQueryParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BotpQueryImpl {
    public DynamicObjectCollection query(BotpQueryParameter queryParameter, QFilter[] qFilters) {
        String selectSQLString = queryParameter.getSelectString();
        DynamicObjectCollection rows = new DynamicObjectCollection(queryParameter.getQueryEntityType(), null);
        HashMap<String, Set> refBdIds = new HashMap<String, Set>();
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet(this.getClass().getName(), queryParameter.getEntityNumber(), selectSQLString, qFilters);
        Iterator iterator = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                DynamicObject rowObj = new DynamicObject(queryParameter.getQueryEntityType());
                rows.add((Object)rowObj);
                rowObj.beginInit();
                for (DynamicSimpleProperty prop : queryParameter.getQueryProps()) {
                    prop.setValueFast((Object)rowObj, row.get(prop.getName()));
                    if (!queryParameter.getQueryRefIdProps().containsKey(prop)) continue;
                    Set idSet = refBdIds.computeIfAbsent(queryParameter.getQueryRefIdProps().get(prop).getRefEntityNumber(), s -> new HashSet());
                    idSet.add(row.get(prop.getName()));
                }
                rowObj.endInit();
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<String, Set> refQueryParamGroups = new HashMap<String, Set>(queryParameter.getQueryRefIdProps().size());
        for (Map.Entry entry : queryParameter.getQueryRefIdProps().entrySet()) {
            Set set = refQueryParamGroups.computeIfAbsent(((BotpRefQueryParameter)entry.getValue()).getRefEntityNumber(), s -> new HashSet(1));
            set.add(entry.getValue());
        }
        for (Map.Entry entry : refBdIds.entrySet()) {
            String bdEntityNumber = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            Set refQueryParams = (Set)refQueryParamGroups.get(bdEntityNumber);
            if (refQueryParams.isEmpty()) continue;
            HashSet<String> selectFields = new HashSet<String>();
            for (BotpRefQueryParameter refQueryParameter : refQueryParams) {
                selectFields.addAll(refQueryParameter.getRefProp1s());
            }
            MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)((String)entry.getKey()), selectFields);
            Map bdObjs = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (DynamicObjectType)subType);
            RowDataModel rowDataModel = new RowDataModel(subType.getName(), subType);
            for (DynamicObject row : rows) {
                row.beginInit();
                for (BotpRefQueryParameter refQueryParam : refQueryParams) {
                    DynamicSimpleProperty refIdProp = refQueryParam.getRefIdProp();
                    Object bdId = refIdProp.getValueFast((Object)row);
                    DynamicObject bdObj = (DynamicObject)bdObjs.get(bdId);
                    if (bdObj == null) continue;
                    rowDataModel.setRowContext(bdObj);
                    for (Map.Entry<String, String> refPropItem : refQueryParam.getRefFullPropAlias().entrySet()) {
                        Object fldValue = rowDataModel.getValue(refPropItem.getKey());
                        if (fldValue instanceof DynamicObject) {
                            fldValue = ((DynamicObject)fldValue).getPkValue();
                        }
                        row.set(refPropItem.getValue(), fldValue);
                    }
                }
                row.endInit();
            }
        }
        return rows;
    }

    public Map<String, Set<Object>> queryBaseIds(BotpQueryParameter queryParameter, QFilter[] qFilters) {
        String selectSQLString = queryParameter.getSelectString();
        DynamicObjectCollection rows = new DynamicObjectCollection(queryParameter.getQueryEntityType(), null);
        HashMap<String, Set<Object>> refBdIds = new HashMap<String, Set<Object>>();
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), queryParameter.getEntityNumber(), selectSQLString, qFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                DynamicObject rowObj = new DynamicObject(queryParameter.getQueryEntityType());
                rows.add((Object)rowObj);
                rowObj.beginInit();
                for (DynamicSimpleProperty prop : queryParameter.getQueryProps()) {
                    prop.setValueFast((Object)rowObj, row.get(prop.getName()));
                    if (!queryParameter.getQueryRefIdProps().containsKey(prop)) continue;
                    Set idSet = refBdIds.computeIfAbsent(queryParameter.getQueryRefIdProps().get(prop).getRefEntityNumber(), s -> new HashSet());
                    idSet.add(row.get(prop.getName()));
                }
                rowObj.endInit();
            }
        }
        return refBdIds;
    }
}

