/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.report;

import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.report.BuildHeadReport;

class BuildEntryReport
extends BuildHeadReport {
    protected String entryKey;
    protected String entryName;
    protected IGetValueMode entryPKValHandler;
    protected IGetValueMode entrySeqValHandler;

    BuildEntryReport() {
    }

    @Override
    protected String getEntryKey() {
        return this.entryKey;
    }

    @Override
    protected String getEntryName() {
        return this.entryName;
    }

    @Override
    public void initialize(SingleRuleContext ruleContext, EntityType entityType) {
        super.initialize(ruleContext, (EntityType)ruleContext.getContext().getSourceMainType());
        this.entityType = entityType;
        this.entityName = entityType.getDisplayName().toString();
        this.entryKey = entityType.getName();
        this.entryName = entityType.getDisplayName().toString();
        this.entryPKValHandler = new GetSourceFieldValue(ruleContext, entityType.getName() + ".id");
        String seq = entityType.getName() + ".seq";
        this.entrySeqValHandler = entityType.findProperty(seq) != null ? new GetSourceFieldValue(ruleContext, seq) : new GetConstValue(0);
    }

    @Override
    public SourceRowId buildRowInfo(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        SourceRowId rowId = super.buildRowInfo(fldProperties, sourceRow);
        rowId.setEntryId(this.entryPKValHandler.getValue(fldProperties, sourceRow));
        rowId.setEntrySeq(this.getEntrySeq(this.entrySeqValHandler, fldProperties, sourceRow));
        return rowId;
    }

    @Override
    public SourceRowId buildRowInfo(Map<String, String> fldAlias, Row row) {
        SourceRowId rowId = super.buildRowInfo(fldAlias, row);
        rowId.setEntryId(this.entryPKValHandler.getValue(fldAlias, row));
        rowId.setEntrySeq(this.getEntrySeq(this.entrySeqValHandler, fldAlias, row));
        return rowId;
    }

    protected int getEntrySeq(IGetValueMode seqGetHandler, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        int entrySeq = 0;
        Object srcRowSeq = seqGetHandler.getValue(fldProperties, sourceRow);
        if (srcRowSeq != null) {
            entrySeq = (Integer)srcRowSeq;
        }
        return entrySeq;
    }

    protected int getEntrySeq(IGetValueMode seqGetHandler, Map<String, String> fldAlias, Row row) {
        int entrySeq = 0;
        Object srcRowSeq = seqGetHandler.getValue(fldAlias, row);
        if (srcRowSeq != null) {
            entrySeq = (Integer)srcRowSeq;
        }
        return entrySeq;
    }
}

