/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.report;

import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.report.IBuildDetailReport;

class BuildHeadReport
implements IBuildDetailReport {
    protected EntityType entityType;
    protected String entityName;
    protected IGetValueMode pkValHandler;
    protected IGetValueMode billNoHandler;

    BuildHeadReport() {
    }

    protected String getEntryKey() {
        return null;
    }

    protected String getEntryName() {
        return null;
    }

    protected String getSubEntryKey() {
        return null;
    }

    protected String getSubEntryName() {
        return null;
    }

    @Override
    public void initialize(SingleRuleContext ruleContext, EntityType entityType) {
        this.entityType = entityType;
        this.entityName = entityType.getDisplayName().toString();
        this.pkValHandler = new GetSourceFieldValue(ruleContext, "id");
        this.billNoHandler = entityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)entityType).getBillNo()) ? new GetSourceFieldValue(ruleContext, ((BillEntityType)entityType).getBillNo()) : new GetConstValue("");
    }

    @Override
    public void addLinkRow(ConvertReportManager reportManager, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        Object billId = this.pkValHandler.getValue(fldProperties, sourceRow);
        String billNo = (String)this.billNoHandler.getValue(fldProperties, sourceRow);
        SourceRowId sourceRowId = this.buildRowInfo(fldProperties, sourceRow);
        reportManager.addLinkRow(billId, billNo, this.entityType.getName(), this.entityName, this.getEntryKey(), this.getEntryName(), this.getSubEntryKey(), this.getSubEntryName(), sourceRowId);
    }

    @Override
    public void addLinkRow(ConvertReportManager reportManager, Map<String, String> fldAlias, Row row) {
        Object billId = this.pkValHandler.getValue(fldAlias, row);
        String billNo = (String)this.billNoHandler.getValue(fldAlias, row);
        SourceRowId sourceRowId = this.buildRowInfo(fldAlias, row);
        reportManager.addLinkRow(billId, billNo, this.entityType.getName(), this.entityName, this.getEntryKey(), this.getEntryName(), this.getSubEntryKey(), this.getSubEntryName(), sourceRowId);
    }

    @Override
    public void addErrorReport(ConvertReportManager reportManager, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, String failMessage) {
        SourceRowId rowId = this.buildRowInfo(fldProperties, sourceRow);
        reportManager.addErrorReport(this.entityType.getName(), rowId, failMessage);
    }

    @Override
    public void addErrorReport(ConvertReportManager reportManager, SourceRowId rowId, String failMessage) {
        reportManager.addErrorReport(this.entityType.getName(), rowId, failMessage);
    }

    @Override
    public SourceRowId buildRowInfo(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        SourceRowId rowId = new SourceRowId();
        rowId.setBillId(this.pkValHandler.getValue(fldProperties, sourceRow));
        return rowId;
    }

    @Override
    public SourceRowId buildRowInfo(Map<String, String> fldAlias, Row row) {
        SourceRowId rowId = new SourceRowId();
        rowId.setBillId(this.pkValHandler.getValue(fldAlias, row));
        return rowId;
    }
}

