/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.botp.BOTPCovertReportService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.constants.PushReportMoudleEnum;
import kd.bos.entity.botp.constants.ReportStatusEnum;
import kd.bos.entity.botp.constants.ReportTypeEnum;
import kd.bos.entity.botp.report.ConvertWatchReport;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.report.ReportCotent;
import kd.bos.entity.report.ReportCotentTemplate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.report.ReportRecordAbstract;
import kd.bos.service.botp.convert.report.WatchReportManager;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.service.report.util.ReportUtil;
import kd.bos.util.CollectionUtils;

public class PushReport
extends ReportRecordAbstract {
    public static HashMap<String, Long> reportRecordMap = new HashMap();
    private static final Log log = LogFactory.getLog(PushReport.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";

    @Override
    public void setParams(Object object) {
        SingleRuleContext singleRuleContext = (SingleRuleContext)object;
        this.recordMap = reportRecordMap;
        this.isCreateReport = singleRuleContext.getRule().getOptionPolicy().isCreateReport();
        this.key = this.getRecordKey(singleRuleContext.getRule().getId());
        this.startDate = singleRuleContext.getRule().getOptionPolicy().getReportStartTime();
        this.endDate = singleRuleContext.getRule().getOptionPolicy().getReportEndTime();
    }

    public static boolean getIsCreateReport(SingleRuleContext singleRuleContext) {
        PushReport pushReport = new PushReport();
        return pushReport.isCreateReport(ReportTypeEnum.push, singleRuleContext);
    }

    public static void setArgsReport(ConvertContext context, ConvertResultManager resultManager, PushArgs args, boolean autoSave) {
        try {
            if (!context.isCreateReport()) {
                return;
            }
            ReportCotentTemplate reportCotentTemplate = new ReportCotentTemplate();
            PushReport.buildArgs(args, reportCotentTemplate);
            PushReport.addCell("autoSave", ResManager.loadKDString((String)"\u65b9\u6cd5\u4e0a\u7684\u81ea\u52a8\u4fdd\u5b58", (String)"ConvertEngine_20", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), String.valueOf(autoSave), reportCotentTemplate);
            resultManager.getCommonReportCotentMap().putIfAbsent(PushReportMoudleEnum.ARGS.name(), reportCotentTemplate);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void buildArgs(PushArgs pushArgs, ReportCotentTemplate reportCotentTemplate) {
        try {
            reportCotentTemplate.addCellHead(ResManager.loadKDString((String)"\u53c2\u6570", (String)"PushReport_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCellHead(ResManager.loadKDString((String)"\u53c2\u6570\u63cf\u8ff0", (String)"PushReport_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCellHead(ResManager.loadKDString((String)"\u53c2\u6570\u503c", (String)"PushReport_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), true);
            reportCotentTemplate.addCell("DefOrgId", false);
            reportCotentTemplate.addCell(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7ec4\u7ec7", (String)"PushReport_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCell(String.valueOf(pushArgs.getDefOrgId()), true);
            reportCotentTemplate.addCell("hasRight", false);
            reportCotentTemplate.addCell(ResManager.loadKDString((String)"\u662f\u5426\u5ffd\u7565\u9274\u6743", (String)"PushReport_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCell(String.valueOf(pushArgs.isHasRight()), true);
            reportCotentTemplate.addCell("isAutoSave", false);
            reportCotentTemplate.addCell(ResManager.loadKDString((String)"\u662f\u5426\u81ea\u52a8\u4fdd\u5b58", (String)"PushReport_5", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCell(String.valueOf(pushArgs.isAutoSave()), true);
            reportCotentTemplate.addCell("appId", false);
            reportCotentTemplate.addCell(ResManager.loadKDString((String)"\u5e94\u7528id", (String)"PushReport_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCell(String.valueOf(pushArgs.getAppId()), true);
            reportCotentTemplate.addCell("ruleId", false);
            reportCotentTemplate.addCell(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219id", (String)"PushReport_7", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCell(String.valueOf(pushArgs.getRuleId()), true);
            reportCotentTemplate.addCell("customParams", false);
            reportCotentTemplate.addCell(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570", (String)"PushReport_8", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), false);
            reportCotentTemplate.addCell(SerializationUtils.toJsonString((Object)pushArgs.getCustomParams()), true);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public static void addCell(String c1, String c2, String c3, ReportCotentTemplate reportCotentTemplate) {
        try {
            reportCotentTemplate.addCell(c1, false);
            reportCotentTemplate.addCell(c2, false);
            reportCotentTemplate.addCell(c3, true);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public static String getUniqueKey(Long taskId, String sBillId, String entityNumber, String convertId) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(taskId);
            stringBuilder.append(sBillId);
            stringBuilder.append(entityNumber);
            stringBuilder.append(convertId);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return null;
        }
    }

    public static ReportCotent getReportCotent(String uniqueKey, Integer moudleCount, String reportTitle, String partTitle, Integer order, ReportCotentTemplate reportCotentTemplate) {
        try {
            reportCotentTemplate.setReportCotent("push", uniqueKey, moudleCount);
            reportCotentTemplate.setReportData(reportTitle);
            reportCotentTemplate.setReportItems(partTitle, order);
            return reportCotentTemplate.getReportCotent();
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return null;
        }
    }

    public static void createReportAutoSave(SingleRuleContext ruleContext, ConvertRuleElement rule, ConvertResultManager resultManager, ConvertContext context) {
        try {
            if (!ruleContext.isCreateReport() || !ruleContext.isAutoSave()) {
                return;
            }
            Map<Long, WatchReportManager> managerMap = resultManager.getWatchReportManagers();
            for (Map.Entry<Long, WatchReportManager> entry : managerMap.entrySet()) {
                WatchReportManager watchReportManager = entry.getValue();
                if (StringUtils.isBlank((CharSequence)watchReportManager.getConvertId()) || !watchReportManager.getConvertId().equals(rule.getId())) {
                    return;
                }
                if (!watchReportManager.getAutoSave().booleanValue()) {
                    return;
                }
                ArrayList<ReportCotent> reportCotents = new ArrayList<ReportCotent>();
                PushReport.addLinkInfo(watchReportManager, reportCotents);
                PushReport.addPushArgs(watchReportManager, resultManager, context, reportCotents);
                PushReport.addPluginInfo(watchReportManager, reportCotents);
                PushReport.sendReport(watchReportManager, reportCotents, context);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void createReportNoAutoSave(ConvertContext context, ConvertResultManager resultManager) {
        try {
            if (!context.isCreateReport()) {
                return;
            }
            HashMap<Long, Map<Long, StringBuilder>> linkMap = new HashMap<Long, Map<Long, StringBuilder>>();
            Map<Long, WatchReportManager> managerMap = resultManager.getWatchReportManagers();
            for (Map.Entry<Long, WatchReportManager> entry : managerMap.entrySet()) {
                WatchReportManager watchReportManager = entry.getValue();
                if (watchReportManager.getAutoSave().booleanValue()) continue;
                ArrayList<ReportCotent> reportCotents = new ArrayList<ReportCotent>();
                PushReport.addLinkInfoNoAutoSave(linkMap, context, resultManager, watchReportManager, reportCotents);
                PushReport.addPushArgs(watchReportManager, resultManager, context, reportCotents);
                PushReport.addPluginInfo(watchReportManager, reportCotents);
                PushReport.sendReport(watchReportManager, reportCotents, context);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static void sendReport(WatchReportManager watchReportManager, List<ReportCotent> reportCotents, ConvertContext context) {
        try {
            String billId = String.valueOf(watchReportManager.getsBillId());
            String entityNumber = watchReportManager.getsEntityNumber();
            String ruleId = watchReportManager.getConvertId();
            String uniqueKey = PushReport.getUniqueKey(context.getTaskId(), billId, entityNumber, ruleId);
            String billno = watchReportManager.getsBillno();
            reportCotents = PushReport.canUseReport(reportCotents);
            if (CollectionUtils.isEmpty(reportCotents)) {
                return;
            }
            BOTPCovertReportService.addConvertReport((ConvertWatchReport)BOTPCovertReportService.buildConvertWatchReport((Long)context.getTaskId(), (Long)Long.parseLong(billId), (Long)Long.parseLong(ruleId), (String)entityNumber, (String)billno, (String)"push", (String)uniqueKey, (ReportStatusEnum)ReportStatusEnum.Z));
            for (ReportCotent reportCotent : reportCotents) {
                reportCotent.setMoudleCount(Integer.valueOf(reportCotents.size()));
                reportCotent.setUniqueKey(PushReport.getUniqueKey(watchReportManager, context));
                QueueProducer.produce((ReportCotent)reportCotent);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static String getUniqueKey(WatchReportManager watchReportManager, ConvertContext context) {
        String billId = String.valueOf(watchReportManager.getsBillId());
        String entityNumber = watchReportManager.getsEntityNumber();
        String ruleId = watchReportManager.getConvertId();
        String uniqueKey = PushReport.getUniqueKey(context.getTaskId(), billId, entityNumber, ruleId);
        return uniqueKey;
    }

    private static void addPushArgs(WatchReportManager watchReportManager, ConvertResultManager resultManager, ConvertContext context, List<ReportCotent> reportCotents) {
        String uniqueKey = PushReport.getUniqueKey(watchReportManager, context);
        ReportCotentTemplate argReport = resultManager.getCommonReportCotentMap().get(PushReportMoudleEnum.ARGS.name());
        PushReport.getReportCotent(uniqueKey, 0, ResManager.loadKDString((String)"\u4e0b\u63a8\u62a5\u544a", (String)"ConvertEngine_21", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0b\u63a8\u53c2\u6570", (String)"ConvertEngine_22", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), 1, argReport);
        if (argReport != null && argReport.getReportCotent() != null) {
            reportCotents.add(argReport.getReportCotent());
        }
    }

    private static void addLinkInfo(WatchReportManager watchReportManager, List<ReportCotent> reportCotents) {
        ReportCotentTemplate reportCotentTemplate = new ReportCotentTemplate();
        Map<String, Object> reportCotentTemplateMap = watchReportManager.getReportCotentTemplateMap();
        if (reportCotentTemplateMap != null && reportCotentTemplateMap.size() > 0) {
            ReportCotentTemplate reportCotentTemplate2 = reportCotentTemplate = reportCotentTemplateMap.get(PushReportMoudleEnum.LINK.name()) == null ? null : (ReportCotentTemplate)reportCotentTemplateMap.get(PushReportMoudleEnum.LINK.name());
        }
        if (reportCotentTemplate != null && reportCotentTemplate.getReportCotent() != null && reportCotentTemplateMap != null) {
            reportCotents.add(reportCotentTemplate.getReportCotent());
        }
    }

    private static void addPluginInfo(WatchReportManager watchReportManager, List<ReportCotent> reportCotents) {
        Map<String, Object> reportCotentTemplateMap = watchReportManager.getReportCotentTemplateMap();
        List reportCotentList = (List)reportCotentTemplateMap.get(PushReportMoudleEnum.PLUGIN.name());
        if (reportCotentList != null && reportCotentList.size() > 0) {
            reportCotents.addAll(reportCotentList);
        }
    }

    public static void collectPlufinInfo(ConvertResultManager resultManager, SingleRuleContext ruleContext, ConvertRuleElement rule, ConvertContext context) {
        try {
            Map<Long, WatchReportManager> managerMap = resultManager.getWatchReportManagers();
            Map cotentTemplateMap = ruleContext.getPlugInProxy().pluginReportCotentMap;
            if (cotentTemplateMap == null || cotentTemplateMap.size() == 0) {
                return;
            }
            for (Map.Entry<Long, WatchReportManager> entry : managerMap.entrySet()) {
                WatchReportManager watchReportManager = entry.getValue();
                if (watchReportManager == null || StringUtils.isBlank((CharSequence)watchReportManager.getConvertId())) {
                    return;
                }
                if (!rule.getId().equals(watchReportManager.getConvertId())) {
                    return;
                }
                ArrayList<ReportCotent> pluginCotents = new ArrayList<ReportCotent>(cotentTemplateMap.size());
                String uniqueKey = PushReport.getUniqueKey(watchReportManager, context);
                int i = 2;
                for (Map.Entry en : cotentTemplateMap.entrySet()) {
                    pluginCotents.add(PushReport.getReportCotent(uniqueKey, 0, ResManager.loadKDString((String)"\u4e0b\u63a8\u62a5\u544a", (String)"ConvertEngine_21", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u63d2\u4ef6%s", (String)"ConvertEngine_15", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), en.getKey()), i, (ReportCotentTemplate)en.getValue()));
                    ++i;
                }
                Map<String, Object> reportCotentTemplateMap = watchReportManager.getReportCotentTemplateMap();
                if (reportCotentTemplateMap == null || pluginCotents == null || pluginCotents.size() <= 0) continue;
                reportCotentTemplateMap.put(PushReportMoudleEnum.PLUGIN.name(), pluginCotents);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static List<ReportCotent> canUseReport(List<ReportCotent> reportCotents) {
        ArrayList<String> ignoreFields = new ArrayList<String>();
        ignoreFields.add("moudleCount");
        ignoreFields.add("uniqueKey");
        Iterator<ReportCotent> iterator = reportCotents.iterator();
        while (iterator.hasNext()) {
            ReportCotent reportCotent = iterator.next();
            if (ReportUtil.checkReportCanUse((ReportCotent)reportCotent, ignoreFields)) continue;
            iterator.remove();
        }
        return reportCotents;
    }

    private static void addLinkInfoNoAutoSave(Map<Long, Map<Long, StringBuilder>> linkMap, ConvertContext context, ConvertResultManager resultManager, WatchReportManager watchReportManager, List<ReportCotent> reportCotents) {
        String uniqueKey;
        ReportCotentTemplate linkReportCotentTemplate;
        Long billId = Long.valueOf(watchReportManager.getsBillId().toString());
        String entityNumber = watchReportManager.getsEntityNumber();
        String billno = watchReportManager.getsBillno();
        String ruleId = watchReportManager.getConvertId();
        if (linkMap.size() == 0) {
            PushReport.dealReportCotent(context, resultManager, linkMap);
        }
        if ((linkReportCotentTemplate = PushReport.createLinkReport(billId, uniqueKey = PushReport.getUniqueKey(context.getTaskId(), String.valueOf(billId), entityNumber, ruleId), linkMap)) != null && linkReportCotentTemplate.getReportCotent() != null) {
            reportCotents.add(linkReportCotentTemplate.getReportCotent());
        }
    }

    private static void dealReportCotent(ConvertContext context, ConvertResultManager resultManager, Map<Long, Map<Long, StringBuilder>> linkMap) {
        BillEntityType billEntityType = context.getTargetMainType();
        Map entities = billEntityType.getAllEntities();
        ArrayList lkEntityTypes = new ArrayList();
        for (Map.Entry entity : entities.entrySet()) {
            if (!(entity.getValue() instanceof LinkEntryType)) continue;
            lkEntityTypes.add(entity.getValue());
        }
        List<DynamicObject> targetDataObjects = resultManager.getTargetDataObjects();
        for (DynamicObject dynamicObject : targetDataObjects) {
            Long tbillId = dynamicObject.getLong("id");
            for (EntityType entityType : lkEntityTypes) {
                DynamicObjectCollection dynamicObjects;
                String entityTypeName = entityType.getName();
                String stableIdStr = entityTypeName + "_stableid";
                String sbillIdStr = entityTypeName + "_sbillid";
                String sIdStr = entityTypeName + "_sid";
                if ("BillEntityType".equals(entityType.getParent().getClass().getSimpleName())) {
                    DynamicObjectCollection headLks = (DynamicObjectCollection)dynamicObject.get(entityTypeName);
                    PushReport.setLinkInfo(headLks, tbillId, stableIdStr, sbillIdStr, sIdStr, linkMap, null);
                    continue;
                }
                if ("EntryType".equals(entityType.getParent().getClass().getSimpleName())) {
                    dynamicObjects = (DynamicObjectCollection)dynamicObject.get(entityType.getParent().getName());
                    for (DynamicObject entity : dynamicObjects) {
                        String sEntityId = String.valueOf(entity.getPkValue());
                        DynamicObjectCollection entityLks = (DynamicObjectCollection)entity.get(entityTypeName);
                        PushReport.setLinkInfo(entityLks, tbillId, stableIdStr, sbillIdStr, sIdStr, linkMap, sEntityId);
                    }
                    continue;
                }
                if (!"SubEntryType".equals(entityType.getParent().getClass().getSimpleName())) continue;
                dynamicObjects = (DynamicObjectCollection)dynamicObject.get(entityType.getParent().getParent().getName());
                for (DynamicObject entity : dynamicObjects) {
                    DynamicObjectCollection subEntrys = (DynamicObjectCollection)entity.get(entityType.getParent().getName());
                    for (DynamicObject subEntry : subEntrys) {
                        DynamicObjectCollection subEntryLks = (DynamicObjectCollection)subEntry.get(entityTypeName);
                        PushReport.setLinkInfo(subEntryLks, tbillId, stableIdStr, sbillIdStr, sIdStr, linkMap, null);
                    }
                }
            }
        }
    }

    private static ReportCotentTemplate createLinkReport(Long sbillId, String uniqueKey, Map<Long, Map<Long, StringBuilder>> linkMap) {
        ReportCotentTemplate reportCotentTemplate = null;
        try {
            reportCotentTemplate = new ReportCotentTemplate();
            reportCotentTemplate.setReportCotent("push", uniqueKey, null);
            reportCotentTemplate.setReportData(ResManager.loadKDString((String)"\u4e0b\u63a8\u62a5\u544a", (String)"ConvertEngine_21", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            reportCotentTemplate.setReportItems(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb", (String)"ConvertEngine_16", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), Integer.valueOf(2));
            reportCotentTemplate.addRowHead2Cols(ResManager.loadKDString((String)"\u76ee\u6807\u5355", (String)"ConvertEngine_17", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), ResManager.loadKDString((String)"lk\u4fe1\u606f", (String)"ConvertEngine_18", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            Map<Long, StringBuilder> stringBuilderMap = linkMap.get(sbillId);
            if (stringBuilderMap == null || stringBuilderMap.size() == 0) {
                return null;
            }
            for (Map.Entry<Long, StringBuilder> stringBuilderEntry : linkMap.get(sbillId).entrySet()) {
                reportCotentTemplate.addRow2Cols(String.valueOf(stringBuilderEntry.getKey()), stringBuilderEntry.getValue().toString());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return reportCotentTemplate;
    }

    private static void setLinkInfo(DynamicObjectCollection dynamicObjectLks, Long tbillId, String stableIdStr, String sbillIdStr, String sIdStr, Map<Long, Map<Long, StringBuilder>> linkMap, String sEntityId) {
        for (DynamicObject dynamicObjectLk : dynamicObjectLks) {
            Long stableId = dynamicObjectLk.getLong(stableIdStr);
            Long sbillid = dynamicObjectLk.getLong(sbillIdStr);
            Long sid = dynamicObjectLk.getLong(sIdStr);
            linkMap.putIfAbsent(sbillid, new HashMap());
            linkMap.get(sbillid).putIfAbsent(tbillId, new StringBuilder());
            StringBuilder stringBuilder = linkMap.get(sbillid).get(tbillId);
            stringBuilder.append("stableid:");
            stringBuilder.append(stableId);
            stringBuilder.append("sbillid:");
            stringBuilder.append(sbillid);
            stringBuilder.append("sid:");
            if (StringUtils.isNotEmpty((CharSequence)sEntityId) && !"0".equals(sEntityId)) {
                stringBuilder.append(sEntityId);
            } else {
                stringBuilder.append(sid);
            }
            stringBuilder.append(";");
        }
    }

    public static void setReportManager(ConvertContext context, ConvertResultManager resultManager, SingleRuleContext ruleContext, DynamicObjectCollection dynamicObjects) {
        try {
            if (!ruleContext.isCreateReport()) {
                return;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                PushReport.setReportManager(context, resultManager, ruleContext, dynamicObject);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public static void setReportManager(ConvertContext context, ConvertResultManager resultManager, SingleRuleContext ruleContext, DynamicObject dynamicObject) {
        try {
            if (!ruleContext.isCreateReport()) {
                return;
            }
            if (resultManager.getWatchReportManagers() != null && resultManager.getWatchReportManagers().size() > 9) {
                return;
            }
            String billnoProp = context.getSourceMainType().getBillNo();
            Long id = dynamicObject.getLong("id");
            WatchReportManager watchReportManager = new WatchReportManager();
            watchReportManager.setsBillId(id);
            if (StringUtils.isNotEmpty((CharSequence)billnoProp)) {
                watchReportManager.setsBillno(dynamicObject.getString(billnoProp));
            }
            watchReportManager.setConvertId(ruleContext.getRule().getId());
            watchReportManager.setsEntityNumber(context.getSourceMainType().getName());
            watchReportManager.setTaskId(context.getTaskId());
            watchReportManager.setReportCotentTemplateMap(new HashMap<String, Object>());
            watchReportManager.setAutoSave(ruleContext.isAutoSave());
            resultManager.getWatchReportManagers().put(id, watchReportManager);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public static void createLinkReportAutoSave(ConvertContext context, ConvertResultManager resultManager, SingleRuleContext ruleContext, DynamicObject sourceRow, DynamicObject linkRow, ExtendedDataEntity targetEntityRow) {
        try {
            if (ruleContext.isCreateReport() && ruleContext.isAutoSave()) {
                Object tbillId = targetEntityRow.getBillPkId();
                String sbillId = sourceRow.getString("id");
                if (targetEntityRow.getBillPkId() != null && Long.parseLong(targetEntityRow.getBillPkId().toString()) != 0L) {
                    if (resultManager.getWatchReportManagers() == null || resultManager.getWatchReportManagers().size() == 0) {
                        return;
                    }
                    WatchReportManager watchReportManager = resultManager.getWatchReportManagers().get(Long.parseLong(sbillId));
                    watchReportManager.getReportCotentTemplateMap().putIfAbsent(PushReportMoudleEnum.LINK.name(), new ReportCotentTemplate());
                    ReportCotentTemplate reportCotentTemplate = (ReportCotentTemplate)watchReportManager.getReportCotentTemplateMap().get(PushReportMoudleEnum.LINK.name());
                    int maxSize = 10;
                    if (reportCotentTemplate == null || reportCotentTemplate.getCells() != null && reportCotentTemplate.getCells().size() > maxSize) {
                        return;
                    }
                    String uniqueKey = PushReport.getUniqueKey(context.getTaskId(), sbillId, context.getSourceMainType().getName(), ruleContext.getRule().getId());
                    reportCotentTemplate.setReportCotent("push", uniqueKey, null);
                    reportCotentTemplate.setReportData(ResManager.loadKDString((String)"\u4e0b\u63a8\u62a5\u544a", (String)"FillLinkInfoAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                    reportCotentTemplate.setReportItems(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb", (String)"FillLinkInfoAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), Integer.valueOf(2));
                    reportCotentTemplate.addRowHead2Cols(ResManager.loadKDString((String)"\u76ee\u6807\u5355", (String)"FillLinkInfoAction_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), ResManager.loadKDString((String)"lk\u4fe1\u606f", (String)"FillLinkInfoAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("stableid:");
                    stringBuilder.append(linkRow.get(2));
                    stringBuilder.append("sbillid:");
                    stringBuilder.append(linkRow.get(3));
                    stringBuilder.append("sid:");
                    stringBuilder.append(linkRow.get(4));
                    reportCotentTemplate.addRow2Cols(String.valueOf(tbillId), stringBuilder.toString());
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

