/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.report;

import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.entity.botp.constants.ReportTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.regist.ReportRegistService;

public abstract class ReportRecordAbstract {
    private static final Log log = LogFactory.getLog(ReportRecordAbstract.class);
    public HashMap<String, Long> recordMap = new HashMap();
    public boolean isCreateReport = false;
    public String key;
    public Date startDate;
    public Date endDate;

    public abstract void setParams(Object var1);

    public boolean isCreateReport(ReportTypeEnum reportTypeEnum, Object params) {
        try {
            this.setParams(params);
            if (!ReportRegistService.getMoudleStatus((String)reportTypeEnum.name())) {
                return false;
            }
            if (!this.isCreateReport) {
                this.deleteReportRecord(this.key);
                return false;
            }
            if (this.startDate == null || this.endDate == null) {
                this.deleteReportRecord(this.key);
                return false;
            }
            Date nowDate = new Date();
            if (nowDate.after(this.startDate) && nowDate.before(this.endDate)) {
                if (!this.hasReportRecord(this.key, this.startDate, this.endDate)) {
                    return true;
                }
            } else {
                this.deleteReportRecord(this.key);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return false;
    }

    private void deleteReportRecord(String key) {
        if (this.recordMap != null && this.recordMap.containsKey(key)) {
            this.recordMap.remove(key);
        }
    }

    public String getRecordKey(String key) {
        String tenantCode = RequestContext.get().getTenantCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(key);
        stringBuilder.append("_");
        stringBuilder.append(tenantCode);
        return stringBuilder.toString();
    }

    public synchronized boolean hasReportRecord(String key, Date startDate, Date endDate) {
        if (this.recordMap.containsKey(key)) {
            Long putDate = this.recordMap.get(key);
            if (putDate > startDate.getTime() && putDate < endDate.getTime()) {
                return true;
            }
            Date nowDate = new Date();
            this.recordMap.put(key, nowDate.getTime());
            return false;
        }
        Date nowDate = new Date();
        this.recordMap.put(key, nowDate.getTime());
        return false;
    }
}

