/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.report;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.botp.BOTPWriteBackReportService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.constants.ReportStatusEnum;
import kd.bos.entity.botp.constants.ReportTypeEnum;
import kd.bos.entity.botp.report.WriteBackWatchReport;
import kd.bos.entity.report.ReportCotent;
import kd.bos.entity.report.ReportCotentTemplate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.report.ReportRecordAbstract;
import kd.bos.service.botp.track.BFTrackerBatchResult;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;

public class WritebackReport
extends ReportRecordAbstract {
    public static HashMap<String, Long> bfReportRecordMap = new HashMap();
    private static final Log log = LogFactory.getLog(WritebackReport.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";

    @Override
    public void setParams(Object object) {
        String entityNumber = (String)object;
        this.recordMap = bfReportRecordMap;
        Map billParameters = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)entityNumber);
        this.key = this.getRecordKey(entityNumber);
        this.isCreateReport = billParameters.getOrDefault("writebackreport", false);
        this.startDate = billParameters.getOrDefault("reportstarttime", null);
        this.endDate = billParameters.getOrDefault("reportendtime", null);
    }

    public static boolean getIsCreateReport(String entityNumber) {
        WritebackReport writebackReport = new WritebackReport();
        return writebackReport.isCreateReport(ReportTypeEnum.writeback, entityNumber);
    }

    public static void addBillIntoReportMap(DynamicObject obj, BFTrackerResult trackerResult) {
        try {
            if (obj.getPkValue() != null && trackerResult != null && trackerResult.getWriteBackReportMap() != null && trackerResult.getWriteBackReportMap().size() < 10) {
                trackerResult.getWriteBackReportMap().put(obj.getPkValue().toString(), null);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void createReport(BFTrackerContext trackerContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BFTrackerBatchResult batchResult) {
        try {
            if (!trackerContext.getCreateReport().booleanValue()) {
                return;
            }
            String entityNumber = trackerContext.getTargetMainType().getName();
            if (trackerResult.getTrackerLog().allBillNos == null || trackerResult.getTrackerLog().allBillNos.size() == 0) {
                trackerResult.getTrackerLog().allBillNos = trackerResult.getTrackerLog().batchLoadBillNos(linkItemContext, batchResult.getSnapshot(), batchResult.getSheets());
            }
            Map map = trackerContext.getPlugInProxy().cotentTemplateMap;
            Map reportCotentTemplateMap = trackerContext.getPlugInProxy().reportCotentTemplateMap;
            Map<String, Map<String, ReportCotentTemplate>> mapMap = trackerResult.getWriteBackReportMap();
            for (Map.Entry<String, Map<String, ReportCotentTemplate>> en : mapMap.entrySet()) {
                String billId = en.getKey();
                long taskId = trackerResult.getTrackerLog().taskId;
                String uniqueKey = entityNumber + billId + taskId;
                HashMap maps = new HashMap();
                if (reportCotentTemplateMap != null) {
                    maps.putAll(reportCotentTemplateMap);
                }
                if (map != null && map.get(billId) != null) {
                    maps.putAll((Map)map.get(billId));
                }
                if (maps == null || maps.size() == 0) {
                    log.info("\u6ca1\u6709\u8981\u751f\u6210\u62a5\u544a\u7684\u5185\u5bb9\uff0c\u5355\u636eid\uff1a" + billId);
                    continue;
                }
                mapMap.put(billId, maps);
                Map<String, ReportCotentTemplate> templateMap = en.getValue();
                if ((templateMap = WritebackReport.canUseReport(templateMap)) == null || templateMap.size() == 0) continue;
                BOTPWriteBackReportService.addWriteBackReport((WriteBackWatchReport)BOTPWriteBackReportService.buildWriteBackWatchReport((Long)taskId, (Long)Long.parseLong(billId), (String)entityNumber, (String)trackerResult.getTrackerLog().getBillNo(entityNumber, (Long)Long.parseLong(billId)), (String)"writeback", (String)uniqueKey, (ReportStatusEnum)ReportStatusEnum.D));
                Iterator<Map.Entry<String, ReportCotentTemplate>> iterator = templateMap.entrySet().iterator();
                int i = 0;
                int size = templateMap.size();
                while (iterator.hasNext()) {
                    Map.Entry<String, ReportCotentTemplate> entry = iterator.next();
                    ReportCotentTemplate reportCotentTemplate = entry.getValue();
                    QueueProducer.produce((ReportCotent)WritebackReport.getReportCotent(uniqueKey, size, ResManager.loadKDString((String)"\u53cd\u5199\u62a5\u544a", (String)"OutputSnapshotLogAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u53cd\u5199\u4e8c\u5f00\u63d2\u4ef6%s", (String)"OutputSnapshotLogAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), entry.getKey()), ++i, reportCotentTemplate));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static ReportCotent getReportCotent(String uniqueKey, Integer moudleCount, String reportTitle, String partTitle, Integer order, ReportCotentTemplate reportCotentTemplate) {
        reportCotentTemplate.setReportCotent("writeback", uniqueKey, moudleCount);
        reportCotentTemplate.setReportData(reportTitle);
        reportCotentTemplate.setReportItems(partTitle, order);
        return reportCotentTemplate.getReportCotent();
    }

    public static Map<String, ReportCotentTemplate> canUseReport(Map<String, ReportCotentTemplate> templateMap) {
        Iterator<Map.Entry<String, ReportCotentTemplate>> iterator = templateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ReportCotentTemplate> entry = iterator.next();
            if (entry.getValue() != null && !CollectionUtils.isEmpty((Collection)entry.getValue().getCells())) continue;
            iterator.remove();
        }
        return templateMap;
    }
}

