/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.opcontroller.IOpController;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.WriteBackMetaServiceHelper;

public class BFTrackerOpContext {
    private BFTrackerContext trackerContext;
    private IOpController opController;
    private boolean skipNextBatch = false;
    private Map<Long, WRuleCompiler> currRuleVers = new HashMap<Long, WRuleCompiler>(1);
    private Map<Long, WRuleCompiler> snapRuleVers = new HashMap<Long, WRuleCompiler>(1);
    private Map<Long, WRuleCompiler> allRuleVers = new HashMap<Long, WRuleCompiler>(1);
    private Map<String, Map<Long, WRuleCompiler>> dctRuleBySrcBill = new HashMap<String, Map<Long, WRuleCompiler>>(1);
    private DynamicObject[] dataEntities;
    private Map<Long, DynamicObject> billObjMap = null;
    private Long[] billIds;
    private boolean hasSnapshot;
    private Set<Long> histSrcMainTableIds = new HashSet<Long>(1);
    private Set<Long> histSrcBillIds = new HashSet<Long>(1);
    private Map<Long, String> headObjStrs = new HashMap<Long, String>(1);
    private DataEntitySerializerOption serializerOption;
    private IRefrencedataProvider refrencedataProvider;

    public BFTrackerOpContext(BFTrackerContext trackerContext, IOpController opController) {
        this.trackerContext = trackerContext;
        this.opController = opController;
    }

    public BFTrackerContext getTrackerContext() {
        return this.trackerContext;
    }

    public IOpController getOpController() {
        return this.opController;
    }

    public boolean isSkipNextBatch() {
        return this.skipNextBatch;
    }

    public void setSkipNextBatch(boolean skipNextBatch) {
        this.skipNextBatch = skipNextBatch;
    }

    public Map<Long, WRuleCompiler> getAllRuleVers() {
        return this.allRuleVers;
    }

    public Map<Long, WRuleCompiler> getCurrRuleVers() {
        return this.currRuleVers;
    }

    public Map<Long, WRuleCompiler> getSnapRuleVers() {
        return this.snapRuleVers;
    }

    public Map<String, Map<Long, WRuleCompiler>> getRuleBySrcBill() {
        return this.dctRuleBySrcBill;
    }

    public synchronized void addSnapRuleVer(Long verId) {
        Map<Long, WRuleCompiler> dctRule;
        WRuleCompiler ruleCompiler = this.getAllRuleVers().get(verId);
        if (ruleCompiler == null && !this.trackerContext.isIgnoreNoUseSb()) {
            Map<Long, WRuleCompiler> allCurrRules = this.trackerContext.getAllCurrRules(false);
            ruleCompiler = allCurrRules.get(verId);
        }
        if (ruleCompiler == null) {
            WriteBackRuleElement ruleVer = WriteBackMetaServiceHelper.loadWriteBackRuleVersion((long)verId);
            ruleCompiler = new WRuleCompiler(this.trackerContext, verId, ruleVer);
        }
        this.snapRuleVers.put(verId, ruleCompiler);
        if (!this.allRuleVers.containsKey(verId)) {
            this.allRuleVers.put(verId, ruleCompiler);
        }
        if ((dctRule = this.dctRuleBySrcBill.get(ruleCompiler.getSourceEntityNumber())) == null) {
            dctRule = new HashMap<Long, WRuleCompiler>();
            this.dctRuleBySrcBill.put(ruleCompiler.getSourceEntityNumber(), dctRule);
        }
        if (!dctRule.containsKey(verId)) {
            dctRule.put(verId, ruleCompiler);
        }
    }

    public DynamicObject[] getDataEntities() {
        return this.dataEntities;
    }

    public void setDataEntities(DynamicObject[] dataEntities) {
        this.dataEntities = dataEntities;
        if (dataEntities != null) {
            this.billObjMap = new HashMap<Long, DynamicObject>(dataEntities.length);
            for (DynamicObject obj : dataEntities) {
                if (obj.getPkValue() instanceof Long) {
                    Long billId = (Long)obj.getPkValue();
                    this.billObjMap.put(billId, obj);
                }
                String objStr = this.serHeadObj(obj);
                this.headObjStrs.put((Long)obj.getPkValue(), objStr);
            }
        }
    }

    public Long[] getBillIds() {
        return this.billIds;
    }

    public void setBillIds(Long[] billIds) {
        this.billIds = billIds;
    }

    public String getBillNo(long billId) {
        if (this.billObjMap == null) {
            return null;
        }
        DynamicObject billObj = this.billObjMap.get(billId);
        if (billObj == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.trackerContext.getTargetMainType().getBillNo()) && billObj.getDataEntityType().getProperties().containsKey((Object)this.trackerContext.getTargetMainType().getBillNo())) {
            return billObj.getString(this.trackerContext.getTargetMainType().getBillNo());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHasSnapshot() {
        BFTrackerOpContext bFTrackerOpContext = this;
        synchronized (bFTrackerOpContext) {
            return this.hasSnapshot;
        }
    }

    public synchronized void setHasSnapshot(boolean hasSnapshot) {
        this.hasSnapshot = this.hasSnapshot || hasSnapshot;
    }

    public synchronized Set<Long> getHistSrcMainTableIds() {
        return this.histSrcMainTableIds;
    }

    public synchronized Set<Long> getHistSrcBillIds() {
        return this.histSrcBillIds;
    }

    public DynamicObject getHeadObj(Long billId) {
        String objStr = this.headObjStrs.get(billId);
        DynamicObject headObj = this.deserHeadObj(objStr);
        this.getRefrencedataProvider().fillReferenceData(new Object[]{headObj}, (IDataEntityType)this.trackerContext.getLocalSubMainType());
        return headObj;
    }

    private String serHeadObj(DynamicObject obj) {
        return DataEntitySerializer.serializerToString((Object)obj, (DataEntitySerializerOption)this.getSerializerOption());
    }

    private DynamicObject deserHeadObj(String objStr) {
        return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)objStr, (IDataEntityType)this.trackerContext.getLocalSubMainType());
    }

    private DataEntitySerializerOption getSerializerOption() {
        if (this.serializerOption == null) {
            this.serializerOption = new DataEntitySerializerOption();
            this.serializerOption.setIncludeDataEntityState(false);
            this.serializerOption.setIncludeComplexProperty(false);
            this.serializerOption.setIncludeCollectionProperty(false);
            this.serializerOption.setIncludeType(false);
        }
        return this.serializerOption;
    }

    private IRefrencedataProvider getRefrencedataProvider() {
        if (this.refrencedataProvider == null) {
            this.refrencedataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
        }
        return this.refrencedataProvider;
    }
}

