/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.AllBusEntityCountInfo;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;
import kd.bos.util.botp.CustomParamsUtil;

public class BuildLinkUpNodesAction
extends AbstractTrackAction {
    private static final Log log = LogFactory.getLog(BuildLinkUpNodesAction.class);

    public BuildLinkUpNodesAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        if (CustomParamsUtil.getWriteBackParam((String)"BOS_BOTP_LINKUPNODES_ENTRY").booleanValue()) {
            this.buildLinkUpNodesByEntry();
            return;
        }
        this.buildLinkUpNodesByHead();
    }

    private void buildLinkUpNodesByHead() {
        AED<Row> aedRows = this.batchResult.getAEDRows();
        ArrayList<RowId> sRowIds = new ArrayList<RowId>(aedRows.getAddList().size() + aedRows.getEditList().size());
        HashMap<Long, Set<Long>> mainTableInfo4SbillId = new HashMap<Long, Set<Long>>();
        for (Row row : aedRows.getAddList()) {
            if (row.getSId() != null && row.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(row.getSId().getMainTableId());
            }
            sRowIds.add(row.getSId());
            this.addSTableInfo(mainTableInfo4SbillId, row.getSId().getMainTableId(), row.getSId().getBillId());
        }
        for (Tuple tuple : aedRows.getEditList()) {
            Row row = (Row)tuple.item1;
            sRowIds.add(row.getSId());
            if (row != null && row.getSId() != null && row.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(row.getSId().getMainTableId());
            }
            this.addSTableInfo(mainTableInfo4SbillId, row.getSId().getMainTableId(), row.getSId().getBillId());
        }
        Map<BFRowId, BFRowLinkUpNode> allNodesByBill = this.trackerContext.getDbService().readSourceRowIds(mainTableInfo4SbillId, this.trackerContext.getAllBusEntityCountInfo());
        HashMap<RowId, BFRowLinkUpNode> hashMap = new HashMap<RowId, BFRowLinkUpNode>(sRowIds.size());
        for (BFRowId bFRowId : sRowIds) {
            BFRowLinkUpNode sNode = allNodesByBill.get(bFRowId);
            if (sNode == null) {
                sNode = new BFRowLinkUpNode(bFRowId);
            }
            hashMap.put((RowId)bFRowId, sNode);
        }
        this.batchResult.setRowLinkUpNodes(hashMap);
        this.collectSourceEntityNumbers();
    }

    private void buildLinkUpNodesByEntry() {
        AED<Row> aedRows = this.batchResult.getAEDRows();
        ArrayList<RowId> sRowIds = new ArrayList<RowId>(aedRows.getAddList().size() + aedRows.getEditList().size());
        HashMap<Long, Set<Long>> tableInfo4SbillId = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> tableInfo4Sid = new HashMap<Long, Set<Long>>();
        for (Row row : aedRows.getAddList()) {
            if (row.getSId() != null && row.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(row.getSId().getMainTableId());
            }
            sRowIds.add(row.getSId());
            this.addSTableInfo(tableInfo4SbillId, row.getSId().getTableId(), row.getSId().getBillId());
            this.addSTableInfo(tableInfo4Sid, row.getSId().getTableId(), row.getSId().getEntryId());
        }
        for (Tuple tuple : aedRows.getEditList()) {
            Row row = (Row)tuple.item1;
            sRowIds.add(row.getSId());
            if (row != null && row.getSId() != null && row.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(row.getSId().getMainTableId());
            }
            this.addSTableInfo(tableInfo4SbillId, row.getSId().getTableId(), row.getSId().getBillId());
            this.addSTableInfo(tableInfo4Sid, row.getSId().getTableId(), row.getSId().getEntryId());
        }
        Map<BFRowId, BFRowLinkUpNode> allNodesByEntry = this.trackerContext.getDbService().readSourceRowIds(tableInfo4Sid, tableInfo4SbillId, this.trackerContext.getAllBusEntityCountInfo());
        HashMap<RowId, BFRowLinkUpNode> hashMap = new HashMap<RowId, BFRowLinkUpNode>(sRowIds.size());
        for (BFRowId bFRowId : sRowIds) {
            BFRowLinkUpNode sNode = allNodesByEntry.get(bFRowId);
            if (sNode == null) {
                sNode = new BFRowLinkUpNode(bFRowId);
            }
            hashMap.put((RowId)bFRowId, sNode);
        }
        this.batchResult.setRowLinkUpNodes(hashMap);
        this.collectSourceEntityNumbers();
    }

    private void addSTableInfo(Map<Long, Set<Long>> tableInfo, Long tableId, Long sid) {
        if (!tableInfo.containsKey(tableId)) {
            tableInfo.put(tableId, new HashSet());
        }
        tableInfo.get(tableId).add(sid);
    }

    private void collectSourceEntityNumbers() {
        try {
            AllBusEntityCountInfo allBusEntityCountInfo = this.trackerContext.getAllBusEntityCountInfo();
            for (Long id : allBusEntityCountInfo.getAllBusEntityCountInfo()) {
                TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)id);
                this.trackerContext.bfSourceEntityNumbers.add(tableDefine.getEntityNumber());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

