/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.util.CollectionUtils;

public class LoadCurrRuleVersAction
extends AbstractTrackAction {
    public LoadCurrRuleVersAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        boolean isWriteBack;
        boolean bl = isWriteBack = !this.batchResult.getAEDRows().getAddList().isEmpty() || !this.batchResult.getAEDRows().getEditList().isEmpty() || !this.batchResult.getAEDRows().getDeleteList().isEmpty();
        if (isWriteBack) {
            this.loadCurrRuleVers();
        }
    }

    private void loadCurrRuleVers() {
        Map<Object, Object> allCurrRules = new HashMap(16);
        if (this.trackerContext.isIgnoreNoUseSb() ? this.trackerContext.bfSourceEntityNumbers.size() == this.trackerContext.bfRuleCompilerd.size() : !this.trackerOpContext.getCurrRuleVers().isEmpty()) {
            return;
        }
        allCurrRules = this.trackerContext.getAllCurrRules(false);
        ArrayList<Object> invalidRuleIds = new ArrayList<Object>(4);
        ArrayList<Long> validRuleIds = new ArrayList<Long>(4);
        for (Map.Entry<Object, Object> entry : allCurrRules.entrySet()) {
            WriteBackRuleElement rule = ((WRuleCompiler)entry.getValue()).getRule();
            if (!this.trackerOpContext.getOpController().isOpValidRule(rule)) {
                invalidRuleIds.add(entry.getKey());
                continue;
            }
            if (this.trackerContext.isIgnoreNoUseSb() && CollectionUtils.isNotEmpty(this.trackerContext.bfSourceEntityNumbers) && !this.trackerContext.bfSourceEntityNumbers.contains(rule.getSourceEntityNumber())) continue;
            Long verId = (Long)entry.getKey();
            WRuleCompiler ruleCompiler = (WRuleCompiler)entry.getValue();
            validRuleIds.add(verId);
            this.trackerOpContext.getCurrRuleVers().put(verId, ruleCompiler);
            this.trackerOpContext.getAllRuleVers().put(verId, ruleCompiler);
            Map<Long, WRuleCompiler> dctRule = this.trackerOpContext.getRuleBySrcBill().get(ruleCompiler.getSourceEntityNumber());
            if (dctRule == null) {
                dctRule = new HashMap<Long, WRuleCompiler>();
                this.trackerOpContext.getRuleBySrcBill().put(ruleCompiler.getSourceEntityNumber(), dctRule);
            }
            if (dctRule.containsKey(verId)) continue;
            dctRule.put(verId, ruleCompiler);
        }
        this.trackerContext.bfRuleCompilerd.addAll(this.trackerContext.bfSourceEntityNumbers);
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String logMsg = String.format("LoadCurrRuleVersAction.doAction(), op valid rules(%s): %s; invalid rules(%s): %s", validRuleIds.size(), StringUtils.join((Object[])validRuleIds.toArray(), (String)","), invalidRuleIds.size(), StringUtils.join((Object[])invalidRuleIds.toArray(), (String)","));
            this.trackerContext.getOperateLog().info(logMsg);
        }
    }
}

