/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.HashSet;
import kd.bos.dataentity.Tuple;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;

public class LoadSnapRuleVersAction
extends AbstractTrackAction {
    public LoadSnapRuleVersAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        this.loadSnapRuleVers(this.batchResult.getAEDRows());
    }

    private void loadSnapRuleVers(AED<Row> aedRows) {
        HashSet<Long> ruleVerIds = new HashSet<Long>();
        for (Tuple<Row, Row> tuple : aedRows.getEditList()) {
            Row snapRow = (Row)tuple.item2;
            for (WRule wRule : snapRow.getWrules().values()) {
                Long verId = wRule.getRuleVerId();
                if (ruleVerIds.contains(verId)) continue;
                ruleVerIds.add(verId);
            }
        }
        for (Row snapRow : aedRows.getDeleteList()) {
            for (WRule wRule : snapRow.getWrules().values()) {
                Long verId = wRule.getRuleVerId();
                if (ruleVerIds.contains(verId)) continue;
                ruleVerIds.add(verId);
            }
        }
        for (Long verId : ruleVerIds) {
            this.trackerOpContext.addSnapRuleVer(verId);
        }
    }
}

