/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.getvaluemode;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.MulBasedataProp;
import org.apache.commons.beanutils.ConvertUtils;

public interface FieldValueTypeConvert {
    default public Object convert(Object value, Class<?> fldValType) {
        Class<?> newValueType;
        Object newValue = value;
        if (newValue != null && FieldValueTypeConvert.isTypeNotEquals(newValueType = newValue.getClass(), fldValType)) {
            if (StringUtils.isBlank((Object)newValue)) {
                if (fldValType.equals(Date.class)) {
                    newValue = null;
                } else if (fldValType.equals(BigDecimal.class)) {
                    newValue = 0;
                }
            } else {
                newValue = ConvertUtils.convert((Object)newValue, fldValType);
            }
        }
        return newValue;
    }

    default public Object convert(Object value, IDataEntityProperty prop) {
        if (!(value instanceof MulBasedataDynamicObjectCollection) || !(prop instanceof MulBasedataProp)) {
            return value;
        }
        MulBasedataProp mulprop = (MulBasedataProp)prop;
        MulBasedataDynamicObjectCollection newColl = new MulBasedataDynamicObjectCollection(mulprop.getDynamicCollectionItemPropertyType(), null);
        MulBasedataDynamicObjectCollection coll = (MulBasedataDynamicObjectCollection)value;
        for (DynamicObject obj : coll) {
            DynamicObject newObj = newColl.addNew();
            newObj.set("fbasedataid", obj.get("fbasedataid"));
            newObj.set("fbasedataid_id", obj.get("fbasedataid_id"));
        }
        return newColl;
    }

    public static boolean isTypeNotEquals(Class<?> newValueType, Class<?> pType) {
        if (newValueType.equals(Long.class) && pType.equals(Long.TYPE)) {
            return false;
        }
        if (newValueType.equals(Integer.class) && pType.equals(Integer.TYPE)) {
            return false;
        }
        if (newValueType.equals(Boolean.class) && pType.equals(Boolean.TYPE)) {
            return false;
        }
        return !newValueType.equals(pType) && !pType.isAssignableFrom(newValueType);
    }
}

