/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.getvaluemode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncParser;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.getvaluemode.FieldVariable;
import kd.bos.service.botp.track.getvaluemode.IGetValueMode;
import kd.bos.service.botp.track.getvaluemode.ReplaceVerValue;
import kd.bos.service.botp.track.getvaluemode.WBExpressionContext;

public class GetFormulaValue
implements IGetValueMode {
    private static Log log = LogFactory.getLog(GetFormulaValue.class);
    protected BillEntityType mainType;
    protected String formula;
    protected Expr expr;
    protected List<FieldVariable> vars = new ArrayList<FieldVariable>();
    protected FunctionManage funcLib;
    protected Set<String> funcs = new HashSet<String>();
    protected WBExpressionContext expContext;
    protected boolean isFunBatchCall;
    protected boolean withoutTrim = false;
    protected Set<BatchFuncRunParam> batchFuncRunParams = new HashSet<BatchFuncRunParam>(8);

    public GetFormulaValue(BillEntityType mainType, String formula, FunctionManage funcLib) {
        this.mainType = mainType;
        this.formula = formula;
        this.funcLib = funcLib;
        this.expContext = new WBExpressionContext();
        this.compileFormula();
    }

    public GetFormulaValue(BillEntityType mainType, String formula, FunctionManage funcLib, boolean withoutTrim) {
        this.mainType = mainType;
        this.formula = formula;
        this.funcLib = funcLib;
        this.expContext = new WBExpressionContext();
        this.withoutTrim = withoutTrim;
        this.compileFormula();
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public List<FieldVariable> getVars() {
        return this.vars;
    }

    public Set<String> getFuncs() {
        return this.funcs;
    }

    @Override
    public Object getValue(RowDataModel rowDataModel) {
        return this.getValue(rowDataModel, new ReplaceVerValue(){});
    }

    @Override
    public boolean batchPreCall(RowDataModel rowDataModel) {
        return this.batchPreCall(rowDataModel, new ReplaceVerValue(){});
    }

    @Override
    public Object getValue(RowDataModel rowDataModel, ReplaceVerValue replaceFunc) {
        this.expContext.setRowDataModel(rowDataModel);
        this.expContext.setReplaceFunc(replaceFunc);
        this.funBatchCall();
        Map<String, Object> ctx = this.getVarValues(this.expContext);
        BOSUDFunction[] funcInstances = this.createUDFunctions(this.expContext);
        Object value = FormulaEngine.execExcelFormula((Expr)this.expr, ctx, (UDFunction[])funcInstances);
        return value;
    }

    private void funBatchCall() {
        try {
            if (this.isFunBatchCall) {
                return;
            }
            BatchFuncParser batchFuncParser = new BatchFuncParser();
            if (this.batchFuncRunParams != null && this.batchFuncRunParams.size() > 0) {
                Map batchCallResult = batchFuncParser.batchCall(this.batchFuncRunParams, (ExpressionContext)this.expContext, this.funcLib);
                this.expContext.setBatchRunResult(batchCallResult);
                this.isFunBatchCall = true;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.isFunBatchCall = true;
        }
    }

    @Override
    public boolean batchPreCall(RowDataModel rowDataModel, ReplaceVerValue replaceFunc) {
        this.expContext.setRowDataModel(rowDataModel);
        this.expContext.setReplaceFunc(replaceFunc);
        BatchFuncParser batchFuncParser = new BatchFuncParser();
        BOSExpression expression = new BOSExpression(this.formula);
        Set batchFuncRunParamsSet = batchFuncParser.preCall(expression, (ExpressionContext)this.expContext, this.funcLib);
        if (batchFuncRunParamsSet == null || batchFuncRunParamsSet.size() == 0) {
            return false;
        }
        this.batchFuncRunParams.addAll(batchFuncRunParamsSet);
        return true;
    }

    protected final void compileFormula() {
        String[] varStrings = new String[]{};
        try {
            varStrings = FormulaEngine.extractVariables((String)this.formula);
            this.expr = FormulaEngine.parseFormula((String)this.formula);
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            this.expr.accept((Visitor)funVisitor);
            this.funcs.addAll(funVisitor.getFuncNames());
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"%1$s \u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a%2$s", (String)"GetFormulaValue_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.formula, exp.getMessage()));
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            FieldVariable var = this.buildVarMode(varString, keyItems);
            this.vars.add(var);
        }
    }

    protected FieldVariable buildVarMode(String varString, String[] keyItems) {
        FieldVariable var = null;
        IDataEntityProperty property = this.mainType.findProperty(keyItems[0]);
        if (property == null && this.mainType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)this.mainType.getProperties().get((Object)keyItems[0]);
        }
        if (property == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u5355\u636e(%1$s)\u4e0a\u627e\u4e0d\u5230\u5b57\u6bb5(%2$s)", (String)"GetFormulaValue_1", (String)"bos-mservice-botp", (Object[])new Object[0]), this.mainType.getDisplayName().toString(), varString));
        }
        var = new FieldVariable(varString, keyItems, property);
        return var;
    }

    protected Map<String, Object> getVarValues(WBExpressionContext expContext) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (FieldVariable var : this.getVars()) {
            OutValue value = new OutValue();
            if (!expContext.tryGetValue(var.getVar(), (OutValue<Object>)value).booleanValue()) {
                ctx.put(var.getVar(), null);
                continue;
            }
            Object item = value.get();
            if (item instanceof String) {
                if (!this.withoutTrim) {
                    item = ((String)item).trim();
                }
            } else if (item instanceof OrmLocaleValue) {
                item = ((OrmLocaleValue)item).getDefaultItem();
            }
            ctx.put(var.getVar(), item);
        }
        return ctx;
    }

    private BOSUDFunction[] createUDFunctions(WBExpressionContext expContext) {
        if (this.getFuncs().isEmpty()) {
            return null;
        }
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
        for (String funcName : this.getFuncs()) {
            if (!this.funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)this.funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[instances.size()]);
    }
}

