/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.BillTracker;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowLinkId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.servicehelper.TimeServiceHelper;

public class BillTrackerBuilder {
    Map<RowLinkId, BillTracker> currBillTrackers = new HashMap<RowLinkId, BillTracker>();
    Map<RowLinkId, BillTracker> histBillTrackers = new HashMap<RowLinkId, BillTracker>();
    BFTrackerDbService dbService;

    public BillTrackerBuilder(BFTrackerDbService dbService) {
        this.dbService = dbService;
    }

    public void buildCurrBillTracker(Sheet sheet) {
        for (Row row : sheet.getRows().values()) {
            Long sTableId = this.dbService.loadMainTableId(row.getSId().getTableId());
            Long tTableId = this.dbService.loadMainTableId(row.getId().getTableId());
            RowLinkId linkId = new RowLinkId(sTableId, row.getSId().getBillId(), tTableId, row.getId().getBillId());
            if (this.currBillTrackers.containsKey(linkId)) continue;
            BillTracker billTracker = new BillTracker();
            billTracker.setSTableId(sTableId);
            billTracker.setSBillId(row.getSId().getBillId());
            billTracker.setTTableId(tTableId);
            billTracker.setTBillId(row.getId().getBillId());
            billTracker.setCreateTime(TimeServiceHelper.getCurrentSystemTime());
            this.currBillTrackers.put(linkId, billTracker);
        }
    }

    public void buildHistBillTracker(List<Object> billTrackerObjs) {
        for (Object obj : billTrackerObjs) {
            BillTracker billTracker = (BillTracker)obj;
            RowLinkId linkId = new RowLinkId(billTracker.getSTableId(), billTracker.getSBillId(), billTracker.getTTableId(), billTracker.getTBillId());
            if (this.histBillTrackers.containsKey(linkId)) continue;
            this.histBillTrackers.put(linkId, billTracker);
        }
    }

    public AED<BillTracker> sync() {
        RowLinkId linkId;
        AED<BillTracker> aed = new AED<BillTracker>();
        for (Map.Entry<RowLinkId, BillTracker> entry : this.currBillTrackers.entrySet()) {
            linkId = entry.getKey();
            BillTracker currTracker = entry.getValue();
            BillTracker histTracker = this.histBillTrackers.get(linkId);
            if (histTracker != null) {
                aed.getEditList().add((Tuple<BillTracker, BillTracker>)new Tuple((Object)currTracker, (Object)histTracker));
                continue;
            }
            aed.getAddList().add(currTracker);
        }
        for (Map.Entry<RowLinkId, BillTracker> entry : this.histBillTrackers.entrySet()) {
            linkId = entry.getKey();
            BillTracker histTracker = entry.getValue();
            BillTracker currTracker = this.currBillTrackers.get(linkId);
            if (currTracker != null) continue;
            aed.getDeleteList().add(histTracker);
        }
        return aed;
    }
}

