/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.bizentity.SourceBillInfo;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.ISaveTracker;
import kd.bos.service.botp.track.helper.SaveTrackerAnsyResult;
import kd.bos.service.botp.track.helper.SaveTrackerRunnable;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

class SaveTrackerAnsy
implements ISaveTracker {
    private static Boolean isSaveTrackerAnsy = Boolean.valueOf(System.getProperty("botp_save_tracker_ansy_model", String.valueOf(Boolean.FALSE)));
    private static Integer trackerPoolNum = Integer.parseInt(System.getProperty("botp_save_tracker_pool_num", "16"));
    private static ThreadPool threadPool = isSaveTrackerAnsy != false ? ThreadPools.newFixedThreadPool((String)"SaveTrackerAnsy", (int)trackerPoolNum) : null;

    SaveTrackerAnsy() {
    }

    private boolean equalsDatabase(String dbRouteKey1, String dbRouteKey2) {
        return StringUtils.equalsIgnoreCase((CharSequence)dbRouteKey1, (CharSequence)dbRouteKey2);
    }

    @Override
    public void saveBeforeTrans(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
    }

    @Override
    public void saveBeginTrans(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        trackerContext.setBotpLinkLog(trackerResult.saveBotpLinkLog.isBotpLinkLogOpen());
        ISaveTracker.deleteEntryTrackers(trackerContext, trackerResult, dbService);
    }

    @Override
    public void saveTrans(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        String dbRouteKey = trackerContext.getTrackerTypes().getEntryTrackerType().getDBRouteKey();
        ISaveTracker.saveEntryTrackers(trackerContext, trackerResult, dbService);
        String dbRouteBillTracker = trackerContext.getTrackerTypes().getBillTrackerType().getDBRouteKey();
        if (this.equalsDatabase(dbRouteKey, dbRouteBillTracker)) {
            ISaveTracker.saveBillTrackers(trackerContext, trackerResult, dbService);
        }
        HashSet<String> srcEntityNumbers = new HashSet<String>(trackerResult.getSrcBillInfos().size());
        for (SourceBillInfo sourceBillInfo : trackerResult.getSrcBillInfos().values()) {
            BillEntityType srcMainType;
            if (!srcEntityNumbers.contains(sourceBillInfo.getMainType().getName())) {
                srcEntityNumbers.add(sourceBillInfo.getMainType().getName());
                List<BOTPLog> toSourceLogs = trackerResult.getTrackerLog().getToSourceLogs(sourceBillInfo.getMainType().getName());
                sourceBillInfo.getWbLogs().clear();
                sourceBillInfo.getWbLogs().addAll(toSourceLogs);
            }
            if (this.equalsDatabase(dbRouteKey, (srcMainType = sourceBillInfo.getSubMainType()).getDBRouteKey())) {
                ISaveTracker.saveSourceBill(trackerContext, sourceBillInfo);
                ISaveTracker.saveWriteBackLogs(trackerContext, sourceBillInfo);
                ISaveTracker.updateWBLogFinishStatus(trackerContext, sourceBillInfo);
                continue;
            }
            if (!this.saveInTransDiffDB()) continue;
            this.saveSourceBillDiffDB(trackerContext, trackerResult, sourceBillInfo, dbService);
        }
    }

    @Override
    public void saveAfterTrans(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        String dbRouteBillTracker;
        String dbRouteKey = trackerContext.getTrackerTypes().getEntryTrackerType().getDBRouteKey();
        if (!this.equalsDatabase(dbRouteKey, dbRouteBillTracker = trackerContext.getTrackerTypes().getBillTrackerType().getDBRouteKey())) {
            this.saveBillTrackerDiffDB(trackerContext, trackerResult, dbService);
        }
        for (SourceBillInfo sourceBillInfo : trackerResult.getSrcBillInfos().values()) {
            BillEntityType srcMainType = sourceBillInfo.getSubMainType();
            if (this.equalsDatabase(dbRouteKey, srcMainType.getDBRouteKey()) || this.saveInTransDiffDB()) continue;
            this.saveSourceBillDiffDB(trackerContext, trackerResult, sourceBillInfo, dbService);
        }
    }

    @Override
    public void saveFinally(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
    }

    protected boolean saveInTransDiffDB() {
        return false;
    }

    protected void saveBillTrackerDiffDB(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        if (!trackerResult.getNewBillTrackers().isEmpty() || !trackerResult.getDelBillTrackerIds().isEmpty()) {
            SaveTrackerRunnable task = new SaveTrackerRunnable();
            task.saveBillTracker(RequestContext.get(), trackerContext, trackerResult.getNewBillTrackers(), trackerResult.getDelBillTrackerIds(), trackerResult, dbService, RequestContext.get().getTraceId());
            SaveTrackerAnsyResult saveResult = null;
            try {
                if (isSaveTrackerAnsy.booleanValue()) {
                    Future ansyResult = threadPool.submit((Callable)task);
                    saveResult = (SaveTrackerAnsyResult)ansyResult.get();
                } else {
                    saveResult = task.call();
                }
            }
            catch (Exception e) {
                saveResult = new SaveTrackerAnsyResult();
                saveResult.setException(e);
            }
            if (saveResult.getException() instanceof KDBizException) {
                throw new KDBizException(saveResult.getException().getMessage());
            }
            if (saveResult.getException() != null) {
                throw new KDException(saveResult.getException(), new ErrorCode("saveBillTrackerDiffDB", "%s"), new Object[]{saveResult.getException().getMessage()});
            }
        }
    }

    protected void saveSourceBillDiffDB(BFTrackerContext trackerContext, BFTrackerResult trackerResult, SourceBillInfo sourceBillInfo, BFTrackerDbService dbService) {
        sourceBillInfo.setSaveByNewThread(true);
        SaveTrackerRunnable task = new SaveTrackerRunnable();
        task.setSourceBillInfo(sourceBillInfo);
        sourceBillInfo.deserEntryRows();
        DynamicObject[] srcBillObjs = sourceBillInfo.getHeadObjs();
        HashMap<EntityType, DynamicObject[]> srcEntryRows = new HashMap<EntityType, DynamicObject[]>(sourceBillInfo.getEntryRowObjs().size());
        for (Map.Entry<EntityType, Map<Long, DynamicObject>> entry : sourceBillInfo.getEntryRowObjs().entrySet()) {
            srcEntryRows.put(entry.getKey(), entry.getValue().values().toArray(new DynamicObject[0]));
        }
        task.saveSrcBill(RequestContext.get(), trackerContext, sourceBillInfo.getSubMainType(), srcBillObjs, srcEntryRows, sourceBillInfo.getBillCloseItems());
        if (isSaveTrackerAnsy.booleanValue()) {
            threadPool.execute((Runnable)task);
        } else {
            task.run();
        }
    }
}

