/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.WriteBackBizRule;
import kd.bos.entity.botp.runtime.CRBizRuleAction;
import kd.bos.entity.botp.runtime.CRBizRuleContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.getvaluemode.FieldVariable;
import kd.bos.service.botp.track.getvaluemode.GetConstValue;
import kd.bos.service.botp.track.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.track.getvaluemode.IGetValueMode;
import kd.bos.service.botp.track.helper.CRBizRuleDoNothing;
import kd.bos.service.botp.track.helper.WRuleCompiler;

public class WBizRuleCompiler {
    private BFTrackerContext trackerContext;
    private WRuleCompiler ruleCompiler;
    private WriteBackBizRule bizRule;
    private IGetValueMode preConditionExecuter;
    private CRBizRuleAction actionTrue;
    private CRBizRuleAction actionFalse;
    private Map<String, IDataEntityProperty> sourceFields = new HashMap<String, IDataEntityProperty>();

    public WBizRuleCompiler(BFTrackerContext trackerContext, WRuleCompiler ruleCompiler, WriteBackBizRule bizRule) {
        this.trackerContext = trackerContext;
        this.ruleCompiler = ruleCompiler;
        this.bizRule = bizRule;
        this.compile();
    }

    public BFTrackerContext getTrackerContext() {
        return this.trackerContext;
    }

    public WRuleCompiler getRuleCompiler() {
        return this.ruleCompiler;
    }

    public WriteBackBizRule getBizRule() {
        return this.bizRule;
    }

    public Map<String, IDataEntityProperty> getSourceFields() {
        return this.sourceFields;
    }

    public void doAction(RowDataModel rowDataModel, DynamicObject activeRow) {
        boolean pass = (Boolean)this.preConditionExecuter.getValue(rowDataModel);
        if (pass) {
            this.actionTrue.doAction(rowDataModel, activeRow);
        } else {
            this.actionFalse.doAction(rowDataModel, activeRow);
        }
    }

    private void compile() {
        this.compileCondition();
        this.compileBizRuleAction();
    }

    private void compileCondition() {
        String preCondition;
        this.preConditionExecuter = this.bizRule.getPreCondition() == null ? new GetConstValue(Boolean.TRUE) : (StringUtils.isBlank((CharSequence)(preCondition = this.bizRule.getPreCondition().buildFullFormula((MainEntityType)this.ruleCompiler.getSourceMainType()))) ? new GetConstValue(Boolean.TRUE) : new GetFormulaValue(this.ruleCompiler.getSourceMainType(), preCondition, this.trackerContext.getFuncLib()));
        for (FieldVariable var : this.preConditionExecuter.getVars()) {
            this.sourceFields.put(var.getFieldProp().getName(), var.getFieldProp());
        }
    }

    private void compileBizRuleAction() {
        this.actionTrue = this.createBizRuleAction(this.bizRule.getBizRuleTrue());
        this.actionFalse = this.createBizRuleAction(this.bizRule.getBizRuleFalse());
        this.sourceFields.putAll(this.actionTrue.getFieldProps());
        this.sourceFields.putAll(this.actionFalse.getFieldProps());
    }

    private CRBizRuleAction createBizRuleAction(CRBizRuleElement bizRuleElement) {
        CRBizRuleDoNothing bizRuleAction = new CRBizRuleDoNothing();
        if (bizRuleElement != null && StringUtils.isNotBlank((CharSequence)bizRuleElement.getRunActionClass())) {
            bizRuleAction = (CRBizRuleAction)TypesContainer.createInstance((String)bizRuleElement.getRunActionClass());
        }
        CRBizRuleContext bizRuleContext = new CRBizRuleContext(this.ruleCompiler.getSourceMainType(), this.getRuleCompiler().getRule(), bizRuleElement);
        bizRuleContext.setFuncLib(this.trackerContext.getFuncLib());
        bizRuleAction.setContext(bizRuleContext);
        return bizRuleAction;
    }
}

