/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ExcessCheckType;
import kd.bos.entity.botp.WriteBackBizRule;
import kd.bos.entity.botp.WriteBackFormula;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.getvaluemode.FieldVariable;
import kd.bos.service.botp.track.getvaluemode.GetConstValue;
import kd.bos.service.botp.track.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.track.getvaluemode.IGetValueMode;
import kd.bos.service.botp.track.getvaluemode.ReplaceVerValue;
import kd.bos.service.botp.track.helper.WBizRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;

public class WRuleCompiler {
    private Long verId;
    private WriteBackRuleElement rule;
    private BFTrackerContext trackerContext;
    private BillEntityType sourceMainType;
    private BillEntityType targetMainType;
    private Long srcMainTableId;
    private Map<Long, WRuleItemCompiler> items = new HashMap<Long, WRuleItemCompiler>();
    private List<WBizRuleCompiler> bizRules = new ArrayList<WBizRuleCompiler>();
    private boolean closeSrcRow;
    private boolean closeSrcBill;
    private IGetValueMode closeConditionExecuter;
    private IDataEntityProperty entryCloseStatusProp;
    private IGetValueMode excessSelectExecuter;
    private IGetValueMode excessSelectTrueExecuter;
    private IGetValueMode excessSelectFalseExecuter;
    private Map<String, IDataEntityProperty> sourceFields = new HashMap<String, IDataEntityProperty>();
    private boolean isOnlyFormulas;

    public void setSourceMainType(BillEntityType sourceMainType) {
        this.sourceMainType = sourceMainType;
    }

    public WRuleCompiler(BFTrackerContext trackerContext, Long verId, WriteBackRuleElement rule) {
        this(trackerContext, verId, rule, null);
    }

    public WRuleCompiler(BFTrackerContext trackerContext, Long verId, WriteBackRuleElement rule, BillEntityType sourceMainType) {
        this.verId = verId;
        this.rule = rule;
        this.trackerContext = trackerContext;
        this.targetMainType = this.trackerContext.getTargetMainType();
        this.sourceMainType = sourceMainType;
        if (sourceMainType == null) {
            this.sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)rule.getSourceEntityNumber());
        }
        this.isOnlyFormulas = false;
        this.compile();
    }

    public WRuleCompiler(BFTrackerContext trackerContext, Long verId, WriteBackRuleElement rule, BillEntityType sourceMainType, boolean isAfterPrepareProperty) {
        this.verId = verId;
        this.rule = rule;
        this.trackerContext = trackerContext;
        this.targetMainType = this.trackerContext.getTargetMainType();
        this.sourceMainType = sourceMainType;
        this.isOnlyFormulas = true;
        this.afterPreparePropertysCompile();
    }

    public Long getVerId() {
        return this.verId;
    }

    public WriteBackRuleElement getRule() {
        return this.rule;
    }

    public Map<Long, WRuleItemCompiler> getItems() {
        return this.items;
    }

    public List<WBizRuleCompiler> getBizRules() {
        return this.bizRules;
    }

    public String getSourceEntityNumber() {
        return this.rule.getSourceEntityNumber();
    }

    public BillEntityType getSourceMainType() {
        return this.sourceMainType;
    }

    public Long getSrcMainTableId() {
        return this.srcMainTableId;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public Map<String, IDataEntityProperty> getSourceFields() {
        return this.sourceFields;
    }

    public IDataEntityProperty getEntryCloseStatusProp() {
        return this.entryCloseStatusProp;
    }

    public boolean isCloseSrcRow() {
        return this.closeSrcRow;
    }

    public boolean isCloseSrcBill() {
        return this.closeSrcBill;
    }

    public boolean checkCloseRow(RowDataModel rowDataModel) {
        boolean pass = (Boolean)this.closeConditionExecuter.getValue(rowDataModel);
        return pass;
    }

    public boolean isOnlyFormulas() {
        return this.isOnlyFormulas;
    }

    public void setOnlyFormulas(boolean onlyFormulas) {
        this.isOnlyFormulas = onlyFormulas;
    }

    public boolean checkExcess(RowDataModel rowDataModel, Map<String, BigDecimal> writeValues) {
        final HashMap<String, BigDecimal> varValues = new HashMap<String, BigDecimal>();
        if (writeValues != null && writeValues.size() > 0) {
            String varString;
            String fldKey;
            for (FieldVariable var : this.excessSelectTrueExecuter.getVars()) {
                fldKey = var.getFieldProp().getName();
                varString = var.getVar();
                BigDecimal decimal = writeValues.get(fldKey);
                if (decimal == null) continue;
                varValues.put(varString, decimal);
            }
            for (FieldVariable var : this.excessSelectFalseExecuter.getVars()) {
                fldKey = var.getFieldProp().getName();
                varString = var.getVar();
                BigDecimal bigDecimal = writeValues.get(fldKey);
                if (bigDecimal == null) continue;
                varValues.put(varString, bigDecimal);
            }
        }
        ReplaceVerValue replaceVerValue = new ReplaceVerValue(){

            @Override
            public Object replace(RowDataModel rowDataModel, String var, Object oldValue) {
                BigDecimal decimal = (BigDecimal)varValues.get(var);
                if (decimal != null) {
                    BigDecimal value = oldValue == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(oldValue));
                    value = value.subtract(decimal);
                    return value;
                }
                return oldValue;
            }
        };
        boolean select = (Boolean)this.excessSelectExecuter.getValue(rowDataModel);
        boolean pass = false;
        pass = select ? (this.rule.getExcessCheckType() == ExcessCheckType.CanExcessOneTime || this.rule.getExcessCheckType() == ExcessCheckType.SelectByFormula && this.rule.getExcessSelectTrue() == ExcessCheckType.CanExcessOneTime ? ((Boolean)this.excessSelectTrueExecuter.getValue(rowDataModel, replaceVerValue)).booleanValue() : ((Boolean)this.excessSelectTrueExecuter.getValue(rowDataModel)).booleanValue()) : (this.rule.getExcessSelectFalse() == ExcessCheckType.CanExcessOneTime ? ((Boolean)this.excessSelectFalseExecuter.getValue(rowDataModel, replaceVerValue)).booleanValue() : ((Boolean)this.excessSelectFalseExecuter.getValue(rowDataModel)).booleanValue());
        return pass;
    }

    public void compile() {
        ConvertDataService reader = new ConvertDataService();
        TableDefine tableDefine = reader.loadTableDefine(this.sourceMainType.getName(), this.sourceMainType.getName());
        this.srcMainTableId = tableDefine.getTableId();
        this.compileClose();
        this.compileExcess();
        this.items.clear();
        for (WriteBackFormula item : this.rule.getFormulas()) {
            WRuleItemCompiler itemCompiler = new WRuleItemCompiler(this.trackerContext, this, item);
            this.items.put(item.getId(), itemCompiler);
            this.sourceFields.put(itemCompiler.getSourceField().getName(), (IDataEntityProperty)itemCompiler.getSourceField());
            this.addSourceField(itemCompiler.getScaleGetHandler().getVars());
        }
        this.compileBizRules();
    }

    public void afterPreparePropertysCompile() {
        this.items.clear();
        for (WriteBackFormula item : this.rule.getFormulas()) {
            WRuleItemCompiler itemCompiler = new WRuleItemCompiler(this.trackerContext, this, item, true);
            this.items.put(item.getId(), itemCompiler);
        }
    }

    private void compileClose() {
        IDataEntityProperty billStatusProp;
        this.closeSrcRow = false;
        this.closeSrcBill = false;
        this.closeConditionExecuter = this.createConditinExecuter(this.rule.getCloseCheckCondition(), true);
        this.addSourceField(this.closeConditionExecuter.getVars());
        String entryCloseFldKey = this.rule.getEntryCloseFieldKey();
        if (StringUtils.isNotBlank((CharSequence)entryCloseFldKey)) {
            this.entryCloseStatusProp = this.sourceMainType.findProperty(entryCloseFldKey);
            if (this.entryCloseStatusProp != null) {
                this.closeSrcRow = true;
                if (!this.sourceFields.containsKey(entryCloseFldKey)) {
                    this.sourceFields.put(entryCloseFldKey, this.entryCloseStatusProp);
                }
            }
        }
        String billCloseFldKey = this.rule.getBillCloseFieldKey();
        if (this.closeSrcRow && StringUtils.isNotBlank((CharSequence)billCloseFldKey) && (billStatusProp = this.sourceMainType.findProperty(billCloseFldKey)) != null && billStatusProp.getParent() instanceof MainEntityType) {
            this.closeSrcBill = true;
            if (!this.sourceFields.containsKey(billCloseFldKey)) {
                this.sourceFields.put(billCloseFldKey, billStatusProp);
            }
        }
    }

    private void compileExcess() {
        switch (this.rule.getExcessCheckType()) {
            case StrictControl: 
            case CanExcessOneTime: {
                this.excessSelectExecuter = new GetConstValue(Boolean.TRUE);
                this.excessSelectTrueExecuter = this.createConditinExecuter(this.getRule().getExcessCheckConditon(), false);
                this.excessSelectFalseExecuter = new GetConstValue(Boolean.FALSE);
                break;
            }
            case SelectByFormula: {
                this.excessSelectExecuter = this.createConditinExecuter(this.getRule().getExcessTypeSelectCondition(), true);
                this.excessSelectTrueExecuter = this.getRule().getExcessSelectTrue() == ExcessCheckType.CanExcellAlways ? new GetConstValue(Boolean.FALSE) : this.createConditinExecuter(this.rule.getExcessCheckConditon(), false);
                if (this.getRule().getExcessSelectFalse() == ExcessCheckType.CanExcellAlways) {
                    this.excessSelectFalseExecuter = new GetConstValue(Boolean.FALSE);
                    break;
                }
                this.excessSelectFalseExecuter = this.createConditinExecuter(this.rule.getExcessCheckConditon(), false);
                break;
            }
            default: {
                this.excessSelectExecuter = new GetConstValue(Boolean.TRUE);
                this.excessSelectTrueExecuter = new GetConstValue(Boolean.FALSE);
                this.excessSelectFalseExecuter = new GetConstValue(Boolean.FALSE);
            }
        }
        this.addSourceField(this.excessSelectExecuter.getVars());
        this.addSourceField(this.excessSelectTrueExecuter.getVars());
        this.addSourceField(this.excessSelectFalseExecuter.getVars());
    }

    private void compileBizRules() {
        ArrayList<WriteBackBizRule> bizRuleElements = new ArrayList<WriteBackBizRule>(this.rule.getBizRules());
        bizRuleElements.sort(new Comparator<WriteBackBizRule>(){

            @Override
            public int compare(WriteBackBizRule o1, WriteBackBizRule o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        this.bizRules.clear();
        for (WriteBackBizRule bizRuleElement : bizRuleElements) {
            if (!bizRuleElement.isEnabled()) continue;
            WBizRuleCompiler bizRuleCompiler = new WBizRuleCompiler(this.trackerContext, this, bizRuleElement);
            this.bizRules.add(bizRuleCompiler);
            this.sourceFields.putAll(bizRuleCompiler.getSourceFields());
        }
    }

    private IGetValueMode createConditinExecuter(CRCondition condition, boolean defValue) {
        IGetValueMode valueMode = null;
        String formula = "";
        if (condition != null) {
            formula = condition.buildFullFormula((MainEntityType)this.sourceMainType);
        }
        valueMode = StringUtils.isBlank((CharSequence)formula) ? new GetConstValue(defValue) : new GetFormulaValue(this.sourceMainType, formula, this.trackerContext.getFuncLib());
        return valueMode;
    }

    private void addSourceField(List<FieldVariable> vars) {
        for (FieldVariable var : vars) {
            if (this.sourceFields.containsKey(var.getFieldProp().getName())) continue;
            this.sourceFields.put(var.getFieldProp().getName(), var.getFieldProp());
        }
    }
}

