/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.log.TCLogDetailInfo;
import kd.bos.entity.botp.log.TCLogRow;
import kd.bos.entity.botp.log.WBLogDetailInfo;
import kd.bos.entity.botp.log.WBLogRow;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.RowLinkId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WRuleItemId;
import kd.bos.service.botp.track.bizentity.WSRow;

public class WbLogBuilder {
    public Sheets createSheets(BOTPLog tcLog, BOTPLog wbLog) {
        if (tcLog == null || wbLog == null) {
            return null;
        }
        if (!(tcLog.getDetailInfo() instanceof TCLogDetailInfo)) {
            return null;
        }
        if (!(wbLog.getDetailInfo() instanceof WBLogDetailInfo)) {
            return null;
        }
        TCLogDetailInfo tcDetails = (TCLogDetailInfo)tcLog.getDetailInfo();
        WBLogDetailInfo wbDetails = (WBLogDetailInfo)wbLog.getDetailInfo();
        Sheets sheets = new Sheets(tcDetails.getEntityKey(), tcDetails.getLinkEntryKey());
        Sheet sheet = new Sheet();
        sheet.setBillId(tcLog.getTBillId());
        sheets.put(tcLog.getTBillId(), sheet);
        ArrayList allTcRows = new ArrayList();
        allTcRows.addAll(tcDetails.getHistRows());
        allTcRows.addAll(tcDetails.getAddRows());
        HashMap<Long, TCLogRow> tcRows = new HashMap<Long, TCLogRow>();
        for (TCLogRow tcRow : allTcRows) {
            if (tcDetails.getDelTcIds().contains(tcRow.getId())) continue;
            tcRows.put(tcRow.getId(), tcRow);
        }
        ArrayList allWbRows = new ArrayList();
        allWbRows.addAll(wbDetails.getHistWBs());
        allWbRows.addAll(wbDetails.getAddWBs());
        HashMap<Long, ArrayList<WBLogRow>> wbRowsByTcId = new HashMap<Long, ArrayList<WBLogRow>>(tcDetails.getHistRows().size());
        for (WBLogRow wBLogRow : allWbRows) {
            if (wbDetails.getDelWbIds().contains(wBLogRow.getId())) continue;
            ArrayList<WBLogRow> list = (ArrayList<WBLogRow>)wbRowsByTcId.get(wBLogRow.getTc());
            if (list == null) {
                list = new ArrayList<WBLogRow>();
                wbRowsByTcId.put(wBLogRow.getTc(), list);
            }
            list.add(wBLogRow);
        }
        for (Map.Entry entry : tcRows.entrySet()) {
            TCLogRow tcRow = (TCLogRow)entry.getValue();
            Row row = this.createRow(sheet, tcLog, tcRow);
            List wbRows = (List)wbRowsByTcId.get(tcRow.getId());
            if (wbRows == null) continue;
            for (WBLogRow wbRow : wbRows) {
                WRule wRule = this.createWRule(row, wbLog, wbRow);
                wRule.getCurrSourceRows().putAll(wRule.getHistorySourceRows());
                wRule.getHistorySourceRows().clear();
            }
        }
        return sheets;
    }

    public Sheets createSnapshot(BOTPLog tcLog, BOTPLog wbLog) {
        if (tcLog == null || wbLog == null) {
            return null;
        }
        if (!(tcLog.getDetailInfo() instanceof TCLogDetailInfo)) {
            return null;
        }
        if (!(wbLog.getDetailInfo() instanceof WBLogDetailInfo)) {
            return null;
        }
        TCLogDetailInfo tcDetails = (TCLogDetailInfo)tcLog.getDetailInfo();
        WBLogDetailInfo wbDetails = (WBLogDetailInfo)wbLog.getDetailInfo();
        Sheets sheets = new Sheets(tcDetails.getEntityKey(), tcDetails.getLinkEntryKey());
        Sheet sheet = new Sheet();
        sheet.setBillId(tcLog.getTBillId());
        sheets.put(tcLog.getTBillId(), sheet);
        HashMap<Long, ArrayList<WBLogRow>> wbRowsByTcId = new HashMap<Long, ArrayList<WBLogRow>>(tcDetails.getHistRows().size());
        for (WBLogRow wbRow : wbDetails.getHistWBs()) {
            ArrayList<WBLogRow> list = (ArrayList<WBLogRow>)wbRowsByTcId.get(wbRow.getTc());
            if (list == null) {
                list = new ArrayList<WBLogRow>();
                wbRowsByTcId.put(wbRow.getTc(), list);
            }
            list.add(wbRow);
        }
        for (TCLogRow tcRow : tcDetails.getHistRows()) {
            Row row = this.createRow(sheet, tcLog, tcRow);
            List wbRows = (List)wbRowsByTcId.get(tcRow.getId());
            if (wbRows == null) continue;
            for (WBLogRow wbRow : wbRows) {
                this.createWRule(row, wbLog, wbRow);
            }
        }
        return sheets;
    }

    private Row createRow(Sheet sheet, BOTPLog tcLog, TCLogRow tcRow) {
        Long sMainTableId = tcLog.getSTableId();
        Long sBillId = tcRow.getSb();
        Long sTableId = tcRow.getSt();
        Long sId = tcRow.getSi();
        Long mainTableId = tcLog.getTTableId();
        Long tableId = tcRow.getTt();
        Long tId = tcRow.getTi();
        RowLinkId linkId = new RowLinkId(sTableId, sId, tableId, tId);
        Row row = (Row)sheet.getRows().get(linkId);
        if (row == null) {
            row = new Row();
            row.setEntryTrackerId(tcRow.getId());
            RowId rowId = new RowId(mainTableId, sheet.getBillId(), tableId, tId);
            row.setId(rowId);
            RowId sRowId = new RowId(sMainTableId, sBillId, sTableId, sId);
            row.setSId(sRowId);
            sheet.getRows().put(linkId, row);
        }
        return row;
    }

    private WRule createWRule(Row row, BOTPLog wbLog, WBLogRow wbRow) {
        Long ruleVerId = wbRow.getRv();
        Long ruleItemId = wbRow.getRi();
        WRuleItemId itemId = new WRuleItemId(ruleVerId, ruleItemId);
        WRule wRule = (WRule)row.getWrules().get(itemId);
        if (wRule == null) {
            wRule = new WRule();
            wRule.setRuleItemId(ruleItemId);
            wRule.setRuleVerId(ruleVerId);
            row.getWrules().put(itemId, wRule);
        }
        Long wb_SBillId = wbRow.getSb();
        Long wb_STableId = wbRow.getSt();
        Long wb_SId = wbRow.getSi();
        BigDecimal wb_value = wbRow.getV();
        Long wb_SMainTableId = wbLog.getSTableId();
        WSRow wsRow = new WSRow();
        wsRow.setWBEntryId(wbRow.getId());
        RowId sId = new RowId(wb_SMainTableId, wb_SBillId, wb_STableId, wb_SId);
        wsRow.setSId(sId);
        wsRow.setVal(wb_value);
        wRule.getHistorySourceRows().put(sId, wsRow);
        return wRule;
    }
}

