/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.opcontroller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.SheetBuilder;
import kd.bos.service.botp.track.helper.SheetSnapBuilder;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.opcontroller.IOpController;

class AbstractOpController
implements IOpController {
    private BFTrackerOpType opType;
    protected BFTrackerContext trackerContext;
    protected BFTrackerDbService dbService;
    protected SheetBuilder sheetBuilder;
    protected SheetSnapBuilder sheetSnapBuilder;

    AbstractOpController() {
    }

    @Override
    public BFTrackerOpType getOpType() {
        return this.opType;
    }

    @Override
    public void setOpType(BFTrackerOpType opType) {
        this.opType = opType;
    }

    @Override
    public void setContext(BFTrackerContext trackerContext, BFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.dbService = dbService;
        this.sheetBuilder = new SheetBuilder(trackerContext, this.dbService);
        this.sheetSnapBuilder = new SheetSnapBuilder(this.trackerContext, this.dbService);
    }

    @Override
    public Set<Long> readOtherEntryIds(LinkItemContext linkItemContext, Long[] billIds) {
        EntryType entryType = (EntryType)linkItemContext.getEntityType();
        return this.dbService.readEntryIds(billIds, entryType);
    }

    @Override
    public Set<Long> readSnapshotOtherEntryIds(LinkItemContext linkItemContext, Long[] billIds) {
        return this.dbService.readSnapshotTIds(billIds, linkItemContext.getEntityTableId());
    }

    @Override
    public Sheets createSheets(LinkItemContext linkItemContext, DynamicObject[] dataEntities) {
        Sheets sheets = new Sheets(linkItemContext.getLinkSetItem().getParentEntityKey(), linkItemContext.getLinkSetItem().getLinkEntityKey());
        for (DynamicObject dataEntity : dataEntities) {
            Sheet sheet = this.sheetBuilder.createSheet(linkItemContext, dataEntity);
            if (sheet == null) continue;
            sheets.put(sheet.getBillId(), sheet);
        }
        return sheets;
    }

    @Override
    public Sheets createSubSheets(LinkItemContext linkItemContext, DynamicObject[] dataEntities, Long[] billIds, Set<Long> entryIds) {
        EntryType currEntryType = this.trackerContext.getLocalSubEntryTypes().get(linkItemContext.getEntryKey());
        DynamicObject[] entryRows = this.dbService.readEntryRows(currEntryType, linkItemContext.getEntityTableId(), entryIds);
        HashMap billRows = new HashMap();
        DynamicProperty billProp = currEntryType.getProperty("billid");
        for (DynamicObject row : entryRows) {
            Long billId = (Long)billProp.getValueFast((Object)row);
            if (!billRows.containsKey(billId)) {
                billRows.put(billId, new ArrayList());
            }
            ((List)billRows.get(billId)).add(row);
        }
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(billIds.length);
        for (Map.Entry billItem : billRows.entrySet()) {
            DynamicObject headObj = linkItemContext.getTrackerOpContext().getHeadObj((Long)billItem.getKey());
            DynamicObjectCollection rows = headObj.getDynamicObjectCollection(currEntryType.getName());
            rows.clear();
            rows.getDeleteRows().clear();
            for (DynamicObject row : (List)billItem.getValue()) {
                rows.add((Object)row);
            }
            billObjs.add(headObj);
        }
        Sheets sheets = new Sheets(linkItemContext.getLinkSetItem().getParentEntityKey(), linkItemContext.getLinkSetItem().getLinkEntityKey());
        for (DynamicObject dataEntity : billObjs) {
            Sheet sheet = this.sheetBuilder.createSheet(linkItemContext, dataEntity);
            if (sheet == null) continue;
            sheets.put(sheet.getBillId(), sheet);
        }
        return sheets;
    }

    @Override
    public Sheets createSubSnapshotSheets(LinkItemContext linkItemContext, Set<Long> entryIds) {
        Map<Long, List<DynamicObject>> snapshotObjs = this.dbService.readSnapshot(linkItemContext.getTrackerOpContext().getBillIds(), linkItemContext.getEntityTableId(), entryIds);
        return this.sheetSnapBuilder.createSheets(linkItemContext, snapshotObjs);
    }

    @Override
    public void createWRules(LinkItemContext linkItemContext, Map<Long, WRuleCompiler> currRuleVers, Map<RowId, BFRowLinkUpNode> rowLinkUpNodes, AED<Row> aedRows) {
        this.sheetBuilder.createWRules(linkItemContext, currRuleVers, rowLinkUpNodes, aedRows);
    }

    @Override
    public boolean isOpValidRule(WriteBackRuleElement rule) {
        return true;
    }

    @Override
    public void checkCanWriteBack(WRule wrule) {
    }

    @Override
    public void calcRealAmount(WRule wrule) {
    }
}

