/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.wblogicunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.BillCloseType;
import kd.bos.entity.botp.plugin.args.AfterCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCloseRowEventArgs;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.bizentity.BillCloseItem;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.SourceBillInfo;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.wblogicunit.AbstractWriteBackLogicUnit;

class CloseRowLogic
extends AbstractWriteBackLogicUnit {
    public CloseRowLogic(WriteBackContext writeBackContext) {
        super(writeBackContext);
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, List<WRule> wRules) {
        Map<Long, Map<Long, Map<RowId, List<WSRow>>>> dctRules = this.splitByRule(wRules);
        for (Map.Entry<Long, Map<Long, Map<RowId, List<WSRow>>>> entryRule : dctRules.entrySet()) {
            Long ruleVerId = entryRule.getKey();
            WRuleCompiler ruleCompiler = this.writeBackContext.getRules().get(ruleVerId);
            Map<Long, Map<RowId, List<WSRow>>> dctRule = entryRule.getValue();
            this.execRuleCloseLogic(rowDataModel, ruleCompiler, dctRule);
        }
    }

    private Map<Long, Map<Long, Map<RowId, List<WSRow>>>> splitByRule(List<WRule> wRules) {
        HashMap<Long, Map<Long, Map<RowId, List<WSRow>>>> dctRules = new HashMap<Long, Map<Long, Map<RowId, List<WSRow>>>>();
        for (WRule wRule : wRules) {
            Long ruleVerId = wRule.getRuleVerId();
            HashMap dctRule = (HashMap)dctRules.get(ruleVerId);
            if (dctRule == null) {
                dctRule = new HashMap();
                dctRules.put(ruleVerId, dctRule);
            }
            for (WSRow wsRow : wRule.getExecuteSourceRows().values()) {
                ArrayList<WSRow> listRow;
                Long sBillId = wsRow.getSId().getBillId();
                HashMap<RowId, ArrayList<WSRow>> dctBill = (HashMap<RowId, ArrayList<WSRow>>)dctRule.get(sBillId);
                if (dctBill == null) {
                    dctBill = new HashMap<RowId, ArrayList<WSRow>>();
                    dctRule.put(sBillId, dctBill);
                }
                if ((listRow = (ArrayList<WSRow>)dctBill.get((Object)wsRow.getSId())) == null) {
                    listRow = new ArrayList<WSRow>();
                    dctBill.put(wsRow.getSId(), listRow);
                }
                listRow.add(wsRow);
            }
        }
        return dctRules;
    }

    private void execRuleCloseLogic(RowDataModel rowDataModel, WRuleCompiler ruleCompiler, Map<Long, Map<RowId, List<WSRow>>> dctRule) {
        if (!ruleCompiler.isCloseSrcRow()) {
            return;
        }
        for (Map.Entry<Long, Map<RowId, List<WSRow>>> entryBill : dctRule.entrySet()) {
            Map<RowId, List<WSRow>> dctBill = entryBill.getValue();
            this.execBillCloseLogic(rowDataModel, ruleCompiler, dctBill);
        }
    }

    private void execBillCloseLogic(RowDataModel rowDataModel, WRuleCompiler ruleCompiler, Map<RowId, List<WSRow>> dctBill) {
        for (Map.Entry<RowId, List<WSRow>> entryRow : dctBill.entrySet()) {
            WSRow wsRow = entryRow.getValue().get(0);
            BeforeCloseRowEventArgs beforeEventArgs = this.firePlugBeforeEvent(ruleCompiler, wsRow);
            if (beforeEventArgs.isCancel()) continue;
            rowDataModel.setRowContext(wsRow.getSrcActiveRow());
            boolean closeRow = ruleCompiler.checkCloseRow(rowDataModel);
            if (closeRow) {
                rowDataModel.setValue(ruleCompiler.getRule().getEntryCloseFieldKey(), (Object)ruleCompiler.getRule().getEntryCloseFieldSuccesStatus());
            } else {
                rowDataModel.setValue(ruleCompiler.getRule().getEntryCloseFieldKey(), (Object)ruleCompiler.getRule().getEntryCloseFieldFailStatus());
            }
            AfterCloseRowEventArgs afterCloseRowEventArgs = this.firePlugAfterEvent(ruleCompiler, wsRow, closeRow);
        }
        if (ruleCompiler.isCloseSrcBill()) {
            DynamicObject firstRow = dctBill.entrySet().iterator().next().getValue().get(0).getSrcActiveRow();
            DynamicObject billObj = this.getBillObj(firstRow);
            BillCloseItem billCloseItem = new BillCloseItem((Long)billObj.getPkValue(), ruleCompiler.getRule().getBillCloseFieldKey(), ruleCompiler.getRule().getBillCloseFieldSuccesStatus(), ruleCompiler.getRule().getBillCloseFieldFailStatus(), ruleCompiler.getRule().getBillCloseType(), ruleCompiler.getRule().getEntryCloseFieldKey(), ruleCompiler.getRule().getEntryCloseFieldSuccesStatus(), ruleCompiler.getRule().getEntryCloseFieldFailStatus());
            SourceBillInfo sourceBillInfo = this.writeBackContext.getTrackerResult().getSrcBillInfos().get(this.writeBackContext.buildSrcBillInfoKey());
            sourceBillInfo.addBillCloseItem(billCloseItem);
        }
    }

    private DynamicObject getBillObj(DynamicObject activeRow) {
        DynamicObject parentObj = activeRow;
        while (parentObj.getParent() != null) {
            parentObj = (DynamicObject)parentObj.getParent();
        }
        return parentObj;
    }

    private boolean checkCloseBill(WRuleCompiler ruleCompiler, DynamicObject billObj) {
        ExtendedDataEntitySet extDataSet = new ExtendedDataEntitySet();
        extDataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)this.writeBackContext.getSrcSubMainType());
        String fieldKey = ruleCompiler.getEntryCloseStatusProp().getName();
        String entryKey = ruleCompiler.getEntryCloseStatusProp().getParent().getName();
        String closeStatus = ruleCompiler.getRule().getEntryCloseFieldSuccesStatus();
        ExtendedDataEntity[] rows = extDataSet.FindByEntityKey(entryKey);
        if (rows.length == 0) {
            return false;
        }
        int closeRowCount = 0;
        for (ExtendedDataEntity row : rows) {
            String currRowStatus = (String)row.getValue(fieldKey);
            if (closeStatus.equalsIgnoreCase(currRowStatus)) {
                ++closeRowCount;
            }
            if (closeRowCount <= 0 || ruleCompiler.getRule().getBillCloseType() != BillCloseType.OneRowClosed) continue;
            return true;
        }
        return closeRowCount > 0 && ruleCompiler.getRule().getBillCloseType() == BillCloseType.OneRowClosed || closeRowCount == rows.length;
    }

    private BeforeCloseRowEventArgs firePlugBeforeEvent(WRuleCompiler rule, WSRow wsRow) {
        BeforeCloseRowEventArgs eventArgs = new BeforeCloseRowEventArgs(rule.getRule(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), this.writeBackContext.getLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireBeforeCloseRow(eventArgs);
        return eventArgs;
    }

    private AfterCloseRowEventArgs firePlugAfterEvent(WRuleCompiler rule, WSRow wsRow, boolean closeRow) {
        AfterCloseRowEventArgs eventArgs = new AfterCloseRowEventArgs(rule.getRule(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), this.writeBackContext.getLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireAfterCloseRow(eventArgs);
        return eventArgs;
    }
}

