/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.wblogicunit;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;
import kd.bos.service.botp.track.wblogicunit.AbstractWriteBackLogicUnit;

class CommitAmountLogic
extends AbstractWriteBackLogicUnit {
    public CommitAmountLogic(WriteBackContext writeBackContext) {
        super(writeBackContext);
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, List<WRule> wRules) {
        Map<Long, WRuleCompiler> rules = this.writeBackContext.getRules();
        for (WRule wRule : wRules) {
            for (WSRow wsRow : wRule.getExecuteSourceRows().values()) {
                DynamicObject activeRow = wsRow.getSrcActiveRow();
                if (activeRow == null) continue;
                rowDataModel.setRowContext(activeRow);
                WRuleCompiler rule = rules.get(wRule.getRuleVerId());
                WRuleItemCompiler ruleItem = rule.getItems().get(wRule.getRuleItemId());
                ruleItem.doWriteBack(this.writeBackContext, rowDataModel, wsRow);
                this.firePlugEvent(rule, ruleItem, wsRow);
            }
        }
    }

    private void firePlugEvent(WRuleCompiler rule, WRuleItemCompiler itemCompiler, WSRow wsRow) {
        WSRow realWSRow = (WSRow)wsRow.getParent().getResultSourceRows().get((Object)wsRow.getSId());
        BigDecimal realVal = realWSRow != null ? realWSRow.getVal() : new BigDecimal(0);
        AfterCommitAmountEventArgs eventArgs = new AfterCommitAmountEventArgs(rule.getRule(), itemCompiler.getItem(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), itemCompiler.getSourceField().getName(), wsRow.getVal(), realVal, wsRow.getCVal(), this.writeBackContext.getLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        eventArgs.setTargetRowId((BFRowId)wsRow.getParent().getParent().getId());
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireAfterCommitAmount(eventArgs);
    }
}

